/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class AuthMethod
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getLoginConfiguration() != null) {
            boolean foundIt = false;
            boolean na = false;
            String authMethod = descriptor.getLoginConfiguration().getAuthenticationMethod();
            if (authMethod.length() > 0) {
                foundIt = authMethod.equals("BASIC") || authMethod.equals("FORM") || authMethod.equals("CLIENT-CERT") || authMethod.equals("DIGEST");
            } else {
                na = true;
            }
            if (foundIt) {
                result.passed(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "The auth-method [ {0} ] is legal value within web application [ {1} ]", new Object[]{authMethod, descriptor.getName()}));
            } else if (na) {
                result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no auth-method elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
            } else {
                result.failed(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: The auth-method [ {0} ] is not legal value within web application [ {1} ].  It must be either [ {2} ], [ {3} ], [ {4} ] or [ {5} ].", new Object[]{authMethod, descriptor.getName(), "BASIC", "FORM", "CLIENT-CERT", "DIGEST"}));
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no auth-method elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

