/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ErrorPageDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class ErrorCode
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getErrorPageDescriptors().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            int oneErrorCode = 0;
            int oneNA = 0;
            Enumeration e10 = descriptor.getErrorPageDescriptors();
            while (e10.hasMoreElements()) {
                foundIt = false;
                ++oneErrorCode;
                ErrorPageDescriptorImpl errorpage = (ErrorPageDescriptorImpl)e10.nextElement();
                String exceptionType = errorpage.getExceptionType();
                if (exceptionType == null || exceptionType.length() <= 0) {
                    Integer errorCode = new Integer(errorpage.getErrorCode());
                    foundIt = ErrorCode.isValidErrorCode(errorCode);
                    if (foundIt) {
                        result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Error code [ {0} ] contains valid HTTP error code within web application [ {1} ]", new Object[]{errorCode.toString(), descriptor.getName()}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: error-code [ {0} ] does not contain valid HTTP error code within web application [ {1} ]", new Object[]{errorCode.toString(), descriptor.getName()}));
                    continue;
                }
                result.addNaDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Not Applicable: Error-code is [ {0} ], using [ {1} ] instead within web application [ {2} ]", new Object[]{new Integer(errorpage.getErrorCode()), exceptionType, descriptor.getName()}));
                ++oneNA;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (oneNA == oneErrorCode) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no error-code elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }

    public static boolean isValidErrorCode(Integer errorCodeTypeInteger) {
        int errorCodeType = errorCodeTypeInteger;
        return errorCodeType == 100 || errorCodeType == 101 || errorCodeType == 200 || errorCodeType == 201 || errorCodeType == 202 || errorCodeType == 203 || errorCodeType == 204 || errorCodeType == 205 || errorCodeType == 206 || errorCodeType == 300 || errorCodeType == 301 || errorCodeType == 302 || errorCodeType == 303 || errorCodeType == 304 || errorCodeType == 305 || errorCodeType == 306 || errorCodeType == 307 || errorCodeType == 400 || errorCodeType == 401 || errorCodeType == 402 || errorCodeType == 403 || errorCodeType == 404 || errorCodeType == 405 || errorCodeType == 406 || errorCodeType == 407 || errorCodeType == 408 || errorCodeType == 409 || errorCodeType == 410 || errorCodeType == 411 || errorCodeType == 412 || errorCodeType == 413 || errorCodeType == 414 || errorCodeType == 415 || errorCodeType == 416 || errorCodeType == 417 || errorCodeType == 500 || errorCodeType == 501 || errorCodeType == 502 || errorCodeType == 503 || errorCodeType == 504 || errorCodeType == 505;
    }
}

