/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;

public class WebResourceName
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            int na = 0;
            int noSc = 0;
            boolean foundIt = false;
            Enumeration e10 = descriptor.getSecurityConstraints();
            while (e10.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e10.nextElement();
                if (securityConstraintImpl.getWebResourceCollections().hasMoreElements()) {
                    Enumeration ee2 = securityConstraintImpl.getWebResourceCollections();
                    while (ee2.hasMoreElements()) {
                        WebResourceCollectionImpl webResCollection = (WebResourceCollectionImpl)ee2.nextElement();
                        String webRCName = webResCollection.getName();
                        foundIt = webRCName.length() > 0;
                        if (foundIt) {
                            result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "web-resource-name [ {0} ] contains the name of this web resource collection within web application [ {1} ]", new Object[]{webRCName, descriptor.getName()}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: web-resource-name [ {0} ] does not contain the name of this web resource collection within web application [ {1} ]", new Object[]{webRCName, descriptor.getName()}));
                    }
                    continue;
                }
                result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "There are no web web resource collections in the web security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no web-resource-name elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

