/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.EventSemaphore;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.Log;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.ResyncThread;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.jtsxa.OTSResource;
import com.sun.jts.jtsxa.OTSResourceImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Status;

public class RecoveryManager {
    private static Enumeration xaResourceList = null;
    private static boolean initialised = false;
    private static int resyncCoords = 0;
    private static ResyncThread resyncThread = null;
    private static EventSemaphore resyncInProgress = new EventSemaphore();
    private static EventSemaphore recoveryInProgress = new EventSemaphore();
    private static EventSemaphore xaResourceListReady = new EventSemaphore();
    private static Hashtable coordsByGlobalTID = new Hashtable();
    private static Hashtable coordsByLocalTID = new Hashtable();
    private static Object lockObject = new Object();

    static synchronized boolean addCoordinator(GlobalTID globalTID, Long localTID, CoordinatorImpl coord, int timeout) {
        boolean result = true;
        coordsByGlobalTID.put(globalTID, coord);
        coordsByLocalTID.put(localTID, coord);
        if (timeout != 0) {
            TimeoutManager.setTimeout(localTID, 1, timeout);
        }
        return result;
    }

    private static boolean checkIfUniqueXid(Map uniqueXids, Xid xid) {
        int glen = xid.getGlobalTransactionId().length;
        int blen = xid.getBranchQualifier().length;
        byte[] xidRep = new byte[glen + 1 + blen];
        System.arraycopy(xid.getGlobalTransactionId(), 0, xidRep, 0, glen);
        xidRep[glen] = 44;
        System.arraycopy(xid.getBranchQualifier(), 0, xidRep, glen + 1, blen);
        String xidStr = new String(xidRep);
        if (uniqueXids.get(xidStr) == null) {
            uniqueXids.put(xidStr, xidStr);
            return true;
        }
        return false;
    }

    static synchronized CoordinatorImpl getCoordinator(GlobalTID globalTID) {
        CoordinatorImpl result = (CoordinatorImpl)coordsByGlobalTID.get(globalTID);
        return result;
    }

    static CoordinatorImpl[] getCoordinators() {
        CoordinatorImpl[] result = new CoordinatorImpl[coordsByGlobalTID.size()];
        Enumeration coords = coordsByGlobalTID.elements();
        int pos = 0;
        while (coords.hasMoreElements()) {
            result[pos++] = (CoordinatorImpl)coords.nextElement();
        }
        return result;
    }

    static synchronized CoordinatorImpl getLocalCoordinator(Long localTID) {
        CoordinatorImpl result = (CoordinatorImpl)coordsByLocalTID.get(localTID);
        return result;
    }

    public static byte[] getRestart() {
        byte[] result = null;
        LogFile logFile = Configuration.getLogFile();
        if (logFile != null) {
            result = logFile.readRestart();
        }
        return result;
    }

    static synchronized void initialise() {
        if (initialised) {
            return;
        }
        initialised = true;
        if (Configuration.isRecoverable()) {
            resyncThread = new ResyncThread();
            resyncThread.start();
        } else {
            String serverName = Configuration.getServerName();
            if (serverName != null && Log.checkFileExists(serverName)) {
                ErrorLog.error(49, new Object[]{serverName}, false);
            }
            try {
                recoveryInProgress.post();
                RecoveryManager.resyncComplete(false, false);
            }
            catch (Throwable throwable) {}
        }
    }

    private static void proceedWithXARecovery() {
        Enumeration xaResources = xaResourceList;
        String manualRecovery = Configuration.getPropertyValue("com.sun.jts.ManualRecovery");
        if (manualRecovery == null || !manualRecovery.equalsIgnoreCase("true")) {
            return;
        }
        if (Thread.currentThread().getName().equals("JTS Resync Thread") && xaResourceListReady != null) {
            try {
                xaResourceListReady.waitEvent();
                xaResources = xaResourceList;
            }
            catch (InterruptedException interruptedException) {
                ErrorLog.error(30, null, true);
            }
        }
        if (xaResources == null) {
            return;
        }
        Vector<OTSResource> otsResources = new Vector<OTSResource>();
        Hashtable uniqueXids = new Hashtable();
        block6: while (xaResources.hasMoreElements()) {
            XAResource xaResource = (XAResource)xaResources.nextElement();
            Xid[] inDoubtXids = null;
            int flags = 0x1000000;
            block7: while (true) {
                try {
                    inDoubtXids = xaResource.recover(flags);
                }
                catch (XAException xAException) {
                    ErrorLog.error(58, null, false);
                    continue block6;
                }
                flags = 0;
                if (inDoubtXids == null || inDoubtXids.length == 0) continue block6;
                int i2 = 0;
                while (true) {
                    String serverName;
                    if (i2 >= inDoubtXids.length) continue block7;
                    String branchQualifier = new String(inDoubtXids[i2].getBranchQualifier());
                    if (branchQualifier.startsWith(serverName = Configuration.getServerName()) && RecoveryManager.checkIfUniqueXid(uniqueXids, inDoubtXids[i2])) {
                        otsResources.addElement(new OTSResourceImpl(inDoubtXids[i2], xaResource, null).getCORBAObjReference());
                    }
                    ++i2;
                }
                break;
            }
        }
        int i3 = 0;
        while (i3 < otsResources.size()) {
            OTSResource otsResource = (OTSResource)otsResources.elementAt(i3);
            GlobalTID globalTID = new GlobalTID(otsResource.getGlobalTID());
            TopCoordinator coord = (TopCoordinator)coordsByGlobalTID.get(globalTID);
            if (coord == null) {
                try {
                    otsResource.rollback();
                }
                catch (Throwable exc) {
                    ErrorLog.warning(13, new Object[]{exc.toString(), "OTSResource rollback"});
                }
            } else {
                coord.directRegisterResource(otsResource);
            }
            ++i3;
        }
    }

    static boolean recover() {
        boolean result;
        block5: {
            result = false;
            boolean keypointRequired = false;
            Enumeration logRecords = CoordinatorLog.getLogged();
            while (logRecords.hasMoreElements()) {
                keypointRequired = false;
                try {
                    new TopCoordinator().reconstruct((CoordinatorLog)logRecords.nextElement());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    ErrorLog.error(12, new Object[]{exc.toString()}, true);
                }
            }
            RecoveryManager.proceedWithXARecovery();
            recoveryInProgress.post();
            boolean bl2 = result = coordsByGlobalTID.size() > 0;
            if (result) break block5;
            try {
                RecoveryManager.resyncComplete(false, keypointRequired);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public static void recoverXAResources(Enumeration xaResources) {
        String manualRecovery = Configuration.getPropertyValue("com.sun.jts.ManualRecovery");
        if (manualRecovery == null || !manualRecovery.equalsIgnoreCase("true")) {
            return;
        }
        Object object = lockObject;
        synchronized (object) {
            if (!xaResourceListReady.isPosted()) {
                xaResourceList = xaResources;
                xaResourceListReady.post();
                RecoveryManager.waitForResync();
                Object var3_3 = null;
                return;
            }
            RecoveryManager.waitForResync();
            xaResourceList = xaResources;
            RecoveryManager.proceedWithXARecovery();
        }
    }

    static synchronized boolean removeCoordinator(GlobalTID globalTID, Long localTID, boolean aborted) {
        boolean result;
        block7: {
            result = false;
            CoordinatorImpl coord = null;
            boolean bl2 = result = coordsByGlobalTID.remove(globalTID) != null;
            if (result) {
                coord = (CoordinatorImpl)coordsByLocalTID.remove(localTID);
                boolean bl3 = result = coord != null;
            }
            if (coord != null) {
                try {
                    if (coord.is_top_level_transaction()) {
                        CoordinatorLog.removeLog(localTID);
                    }
                }
                catch (SystemException systemException) {
                    result = false;
                }
            }
            TimeoutManager.setTimeout(localTID, 0, 0);
            CurrentTransaction.endAll(globalTID, aborted);
            if (resyncCoords <= 0 || --resyncCoords != 0) break block7;
            try {
                RecoveryManager.resyncComplete(true, true);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    static void resync() {
        resyncCoords = coordsByGlobalTID.size();
        Enumeration resyncList = ((Hashtable)coordsByGlobalTID.clone()).elements();
        boolean[] isRoot = new boolean[1];
        while (resyncList.hasMoreElements()) {
            TopCoordinator coord = (TopCoordinator)resyncList.nextElement();
            try {
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    Status state = coord.recover(isRoot);
                    if (state == Status.StatusUnknown) {
                        TimeoutManager.setTimeout(new Long(coord.getLocalTID()), 2, 60);
                    } else if (state == Status.StatusCommitted) {
                        try {
                            coord.commit();
                        }
                        catch (Throwable exc) {
                            ErrorLog.error(13, new Object[]{exc.toString(), "commit"}, false);
                        }
                        if (isRoot[0]) {
                            try {
                                coord.afterCompletion(state);
                            }
                            catch (Throwable exc) {
                                ErrorLog.error(13, new Object[]{exc.toString(), "after_completion"}, false);
                            }
                        }
                    } else {
                        try {
                            coord.rollback(true);
                        }
                        catch (Throwable exc) {
                            ErrorLog.error(13, new Object[]{exc.toString(), "rollback"}, false);
                        }
                        if (isRoot[0]) {
                            try {
                                coord.afterCompletion(Status.StatusRolledBack);
                            }
                            catch (Throwable exc) {
                                ErrorLog.error(13, new Object[]{exc.toString(), "after_completion"}, false);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static void resyncComplete(boolean resynced, boolean keypointRequired) throws LogicErrorException {
        if (keypointRequired) {
            CoordinatorLog.keypoint();
        }
        resyncInProgress.post();
        resyncInProgress = null;
    }

    public static void setRestart(byte[] bytes) {
        LogFile logFile = Configuration.getLogFile();
        if (logFile != null && !logFile.writeRestart(bytes)) {
            ErrorLog.error(32, null, false);
        }
    }

    static void shutdown(boolean immediate) {
        if (immediate) {
            if (resyncThread != null) {
                resyncThread.stop();
            }
        } else if (resyncInProgress != null) {
            try {
                resyncInProgress.waitEvent();
                if (resyncThread != null) {
                    resyncThread.join();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!immediate && Configuration.isRecoverable()) {
            CoordinatorLog.keypoint();
            CoordinatorLog.finalizeAll();
        }
    }

    static synchronized boolean validLocalTID(Long localTID) {
        boolean result = coordsByLocalTID.containsKey(localTID);
        return result;
    }

    public static void waitForRecovery() {
        block2: {
            if (recoveryInProgress == null) break block2;
            try {
                recoveryInProgress.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                ErrorLog.error(30, null, true);
            }
        }
    }

    public static void waitForResync() {
        block2: {
            if (resyncInProgress == null) break block2;
            try {
                resyncInProgress.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                ErrorLog.error(30, null, true);
            }
        }
    }
}

