/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.internal.ssl.X500Name;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

final class X509KeyManagerImpl
implements X509KeyManager {
    private HashMap a = new HashMap();
    private HashMap b = new HashMap();
    private HashMap c = new HashMap();

    X509KeyManagerImpl(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (!(certificateArray instanceof X509Certificate[])) {
                object = new X509Certificate[certificateArray.length];
                System.arraycopy(certificateArray, 0, object, 0, certificateArray.length);
                certificateArray = object;
            }
            object = keyStore.getKey(string, cArray);
            this.b.put(string, certificateArray);
            this.a.put(string, object);
        }
    }

    public String chooseClientAlias(String string, Principal[] principalArray) {
        String[] stringArray = this.getClientAliases(string, principalArray);
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public synchronized String chooseServerAlias(String string, Principal[] principalArray) {
        String[] stringArray;
        if (principalArray == null || principalArray.length == 0) {
            stringArray = (String[])this.c.get(string);
            if (stringArray == null) {
                stringArray = this.getServerAliases(string, principalArray);
                this.c.put(string, stringArray);
            }
        } else {
            stringArray = this.getServerAliases(string, principalArray);
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public X509Certificate[] getCertificateChain(String string) {
        Object v2 = this.b.get(string);
        if (!(v2 instanceof X509Certificate[])) {
            return null;
        }
        return (X509Certificate[])v2;
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        String[] stringArray;
        Iterator iterator = this.b.keySet().iterator();
        HashMap<String[], String[]> hashMap = new HashMap<String[], String[]>();
        int n2 = principalArray != null ? principalArray.length : 0;
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            X509Certificate[] x509CertificateArray = (X509Certificate[])this.b.get(stringArray);
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < x509CertificateArray.length) {
                    block6: {
                        X500Name x500Name = null;
                        try {
                            x500Name = new X500Name(x509CertificateArray[n4].getIssuerDN().getName());
                        }
                        catch (IOException iOException) {
                            System.out.println("Caught: " + iOException);
                            iOException.printStackTrace();
                            break block6;
                        }
                        if (x500Name.equals(principalArray[n3])) {
                            hashMap.put(stringArray, stringArray);
                            break;
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            if (n2 != 0) continue;
            hashMap.put(stringArray, stringArray);
        }
        stringArray = hashMap.values().toArray(new String[hashMap.size()]);
        return stringArray;
    }

    public PrivateKey getPrivateKey(String string) {
        Object v2 = this.a.get(string);
        if (!(v2 instanceof PrivateKey)) {
            return null;
        }
        return (PrivateKey)v2;
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        String[] stringArray;
        Iterator iterator = this.b.keySet().iterator();
        HashMap<String[], String[]> hashMap = new HashMap<String[], String[]>();
        int n2 = principalArray != null ? principalArray.length : 0;
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            X509Certificate[] x509CertificateArray = (X509Certificate[])this.b.get(stringArray);
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < x509CertificateArray.length) {
                    block6: {
                        X500Name x500Name = null;
                        try {
                            x500Name = new X500Name(x509CertificateArray[n4].getIssuerDN().getName());
                        }
                        catch (IOException iOException) {
                            System.out.println("Caught: " + iOException);
                            iOException.printStackTrace();
                            break block6;
                        }
                        if (x500Name.equals(principalArray[n3])) {
                            hashMap.put(stringArray, stringArray);
                            break;
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            if (n2 != 0) continue;
            hashMap.put(stringArray, stringArray);
        }
        stringArray = hashMap.values().toArray(new String[hashMap.size()]);
        return stringArray;
    }
}

