/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.log.Log;
import com.sun.enterprise.security.LoginContext;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

abstract class HttpAuthenticator {
    private static final boolean debug = false;
    private static int MAX_COUNT = 5;
    private static int SLEEP_TIME = 5000;
    public static final String SECURITY_CONTEXT = "SecurityContext";
    private String realm = "default";
    private HttpServletRequest request;
    private HttpServletResponse response;

    protected HttpAuthenticator(HttpServletRequest req, HttpServletResponse res) {
        this.request = req;
        this.response = res;
    }

    public abstract boolean authenticate() throws IOException;

    protected boolean authenticate(String username, String password) {
        return this.authenticate(username, password.getBytes());
    }

    protected boolean authenticate(String username, String authmethod, byte[] authData) {
        LoginContext lc = this.initLoginContext();
        lc.setRealmName(this.getRealm());
        if (authmethod != null) {
            lc.setAuthenticationMethod(authmethod);
        }
        SecurityContext.setCurrent(null);
        try {
            if (lc == null) {
                return false;
            }
            lc.login(username, authData);
        }
        catch (LoginException le) {
            Log.err.println(le);
            return false;
        }
        HttpSession session = this.getRequest().getSession(true);
        if (session != null) {
            session.setAttribute(SECURITY_CONTEXT, SecurityContext.getCurrent());
        }
        return true;
    }

    protected boolean authenticate(String username, byte[] authData) {
        return this.authenticate(username, null, authData);
    }

    public String getRealm() {
        return this.realm;
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    protected HttpServletResponse getResponse() {
        return this.response;
    }

    public abstract void init() throws IOException;

    private LoginContext initLoginContext() {
        LoginContext lc = null;
        int i2 = 0;
        while (i2 < MAX_COUNT) {
            try {
                lc = new LoginContext();
                lc.setRealmName(this.getRealm());
                break;
            }
            catch (Exception e10) {
                e10.printStackTrace(Log.err);
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {}
                ++i2;
            }
        }
        return lc;
    }

    public void reset() {
    }

    public abstract void sendError() throws IOException;

    public void setRealm(String realm) {
        this.realm = realm;
    }
}

