/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.security.acl.AccessControlEntryImpl;
import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.AccessControlListImpl;
import com.sun.enterprise.security.acl.Resource;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.acl.WebResource;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.ORBManager;
import com.sun.web.security.AccessControlInfo;
import com.sun.web.security.DataConstraint;
import com.sun.web.security.ProtectionDomain;
import com.sun.web.server.ServletDeployer;
import com.sun.web.server.WebServer;
import com.sun.web.server.WebService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.tomcat.core.Context;

public class ServletDeployerImpl
implements ServletDeployer {
    private static final boolean debug = false;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$web$server$ServletDeployerImpl != null ? class$com$sun$web$server$ServletDeployerImpl : (class$com$sun$web$server$ServletDeployerImpl = ServletDeployerImpl.class$("com.sun.web.server.ServletDeployerImpl")));
    private WebServer server;
    private File webDocumentRoot;
    static /* synthetic */ Class class$com$sun$web$server$ServletDeployerImpl;

    ServletDeployerImpl(WebServer server) throws RemoteException {
        this.server = server;
        try {
            this.webDocumentRoot = this.getDocumentRoot(server.getWebService().getDocumentRoot());
        }
        catch (IOException ioe) {
            throw new RemoteException(localStrings.getLocalString("web.server.servlet.cannot_resolve_filename", "Cannot Resolve the filename {0} ", new Object[]{ioe.getMessage()}));
        }
    }

    private void addSecurityConstraint(String appName, Context context, AccessControlInfo accInfo, SecurityConstraintImpl sc, ProtectionDomain pd) {
        AccessControlList acl = this.getAccessControlList(sc);
        DataConstraint dc2 = DataConstraint.getInstance();
        Enumeration e10 = this.getWebResources(appName, context, sc).elements();
        while (e10.hasMoreElements()) {
            Resource r2 = (Resource)e10.nextElement();
            if (acl != null) {
                accInfo.protectResource(r2, acl, pd);
            }
            if (sc.getUserDataConstraint().getTransportGuarantee() == null) continue;
            dc2.setConstraint(r2, sc.getUserDataConstraint().getTransportGuarantee());
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private String convertArchiveEntryToFilename(String archiveEntry) {
        return archiveEntry.replace('\\', File.separatorChar).replace('/', File.separatorChar);
    }

    public void doActivate() throws Exception {
        PortableRemoteObject.exportObject(this);
        Tie servantsTie = Util.getTie(this);
        servantsTie.orb(ORBManager.getORB());
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        namingManager.publishObject("WebInstaller", (Object)servantsTie, true);
    }

    private void doneDeployingComponent(DeploymentSession session) throws RemoteException {
        if (session != null) {
            session.notification(new NotificationEvent("", "Web Component Deployed", ""));
        }
    }

    private AccessControlList getAccessControlList(SecurityConstraintImpl sc) {
        AccessControlListImpl acl = null;
        AuthorizationConstraintImpl ac2 = (AuthorizationConstraintImpl)sc.getAuthorizationConstraint();
        if (ac2 != null && ac2.getSecurityRoles().hasMoreElements()) {
            acl = new AccessControlListImpl();
        } else if (ac2 != null) {
            System.out.println("Authorization Constraint = " + ac2);
            acl = new AccessControlListImpl();
            acl.addEntry(new AccessControlEntryImpl(RoleMapper.getDefaultRole()));
        }
        if (ac2 != null) {
            Enumeration e10 = ac2.getSecurityRoles();
            while (e10.hasMoreElements()) {
                SecurityRoleDescriptor srd = (SecurityRoleDescriptor)e10.nextElement();
                Role r2 = new Role(srd.getName());
                AccessControlEntryImpl ace = new AccessControlEntryImpl(r2);
                acl.addEntry(ace);
            }
        }
        return acl;
    }

    private File getDocumentRoot(URL docBase) throws IOException {
        File relativeDocumentRoot = new File(docBase.getFile());
        return new File(relativeDocumentRoot.getCanonicalPath());
    }

    private ProtectionDomain getProtectionDomain(WebBundleDescriptor wbd) {
        ProtectionDomain pd = new ProtectionDomain();
        if (wbd.getLoginConfiguration() != null) {
            pd.setRealmName(wbd.getLoginConfiguration().getRealmName());
            pd.setAuthMethod(wbd.getLoginConfiguration().getAuthenticationMethod());
            pd.setLoginPage(wbd.getLoginConfiguration().getFormLoginPage());
            pd.setLoginErrorPage(wbd.getLoginConfiguration().getFormErrorPage());
        }
        return pd;
    }

    private Vector getWebResources(String appName, Context context, SecurityConstraintImpl sc) {
        Vector<WebResource> v2 = new Vector<WebResource>();
        Enumeration e10 = sc.getWebResourceCollections();
        while (e10.hasMoreElements()) {
            WebResourceCollectionImpl wrc = (WebResourceCollectionImpl)e10.nextElement();
            Enumeration ee2 = wrc.getUrlPatterns();
            while (ee2.hasMoreElements()) {
                String urlPattern = (String)ee2.nextElement();
                Enumeration eee = wrc.getHttpMethods();
                while (eee.hasMoreElements()) {
                    String httpMethod = (String)eee.nextElement();
                    if (!urlPattern.startsWith("/")) {
                        urlPattern = "/" + urlPattern;
                    }
                    WebResource r2 = new WebResource(appName, String.valueOf(context.getPath()) + urlPattern, httpMethod);
                    v2.addElement(r2);
                }
            }
        }
        return v2;
    }

    /*
     * Unable to fully structure code
     */
    public void loadWebComponents(String applicationFilename, DeploymentSession session) throws RemoteException {
        block8: {
            service = null;
            contextName = null;
            contextNames = new Vector<String>();
            try {
                sw = Switch.getSwitch();
                application = ApplicationArchivist.open(new File(applicationFilename));
                itr = application.getWebBundleDescriptors().iterator();
                while (itr.hasNext()) {
                    wbd = (WebBundleDescriptor)itr.next();
                    webApplicationDirectory = wbd.getContextRoot();
                    destination = new File(this.webDocumentRoot, webApplicationDirectory);
                    service = this.server.getWebService();
                    warFile = new File(destination, "original.war");
                    application.getApplicationArchivist().extractBundleToFile(wbd, warFile);
                    Archivist.extractJarFile(warFile, destination);
                    docBase = new File(destination.toString()).toURL();
                    contextName = "/" + wbd.getContextRoot();
                    contextNames.addElement(contextName);
                    context = service.addContext(contextName, docBase);
                    jcl = (JarClassLoader)context.getClassLoader();
                    jcl.addJar(applicationFilename);
                    context.setClassPath(jcl.getClassPath());
                    System.out.println(String.valueOf(ServletDeployerImpl.localStrings.getLocalString("web.server.created.context", "Created Context:")) + context.getPath());
                    sw.setDescriptorFor(context, wbd);
                    sw.getNamingManager().bindObjects(wbd);
                    this.setSecurityInfo(context, wbd);
                    context.init();
                    try {
                        if (session != null && session.isCancelled()) {
                            enum = contextNames.elements();
                            while (enum.hasMoreElements()) {
                                service.getServer().removeContext((String)enum.nextElement());
                            }
                            return;
                        }
                        this.doneDeployingComponent(session);
                    }
                    catch (Throwable v0) {
                        System.out.println("Error notifiying deployer of web component deploment");
                    }
                }
                break block8;
            }
            catch (Throwable e) {
                enum = contextNames.elements();
                ** while (enum.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                service.getServer().removeContext((String)enum.nextElement());
                continue;
            }
lbl47:
            // 1 sources

            e.printStackTrace();
            throw new RemoteException(ServletDeployerImpl.localStrings.getLocalString("web.server.servlet.error_loading_servlet", "An error was encountered while loading servlets"));
        }
    }

    private void progress(String message, DeploymentSession session) {
        block2: {
            if (session == null) break block2;
            try {
                session.setStatusMessage(message);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        }
    }

    private void removeSecurityConstraint(String appName, Context context, AccessControlInfo accInfo, SecurityConstraintImpl sc) {
        DataConstraint dc2 = DataConstraint.getInstance();
        Enumeration e10 = this.getWebResources(appName, context, sc).elements();
        while (e10.hasMoreElements()) {
            Resource r2 = (Resource)e10.nextElement();
            accInfo.unprotectResource(r2);
            dc2.removeConstraint(r2);
        }
    }

    private void setSecurityInfo(Context context, WebBundleDescriptor descriptor) {
        String appName = descriptor.getApplication().getName();
        String name = descriptor.getName();
        AccessControlInfo accInfo = AccessControlInfo.getInstance(context);
        String[] supportedMethods = new String[]{"GET", "POST"};
        ProtectionDomain pd = this.getProtectionDomain(descriptor);
        Enumeration e10 = descriptor.getSecurityConstraints();
        while (e10.hasMoreElements()) {
            SecurityConstraintImpl sc = (SecurityConstraintImpl)e10.nextElement();
            this.addSecurityConstraint(appName, context, accInfo, sc, pd);
        }
        RoleMapper.setRoleMapper(descriptor.getApplication().getName(), descriptor.getApplication().getRoleMapper());
    }

    public void unloadWebComponents(String applicationFilename) throws RemoteException {
        Application application = null;
        try {
            application = ApplicationArchivist.open(new File(applicationFilename));
        }
        catch (Exception ioe) {
            throw new RemoteException(String.valueOf(applicationFilename) + " could not be opened: " + ioe.getMessage());
        }
        Iterator itr = application.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            String webApplicationDirectory = wbd.getContextRoot();
            String contextName = "/" + wbd.getContextRoot();
            File destination = new File(this.webDocumentRoot, webApplicationDirectory);
            WebService service = this.server.getWebService();
            try {
                Set filesToDelete = FileUtil.getAllFilesAndDirectoriesUnder(destination);
                Iterator files = filesToDelete.iterator();
                while (files.hasNext()) {
                    File next = (File)files.next();
                    File actualFile = new File(destination, next.toString());
                    boolean bl2 = actualFile.delete();
                }
                Context ctx = service.getServer().getContext(contextName);
                this.unsetSecurityInfo(ctx, wbd);
                service.removeContext(contextName);
                Switch.getSwitch().removeDescriptorFor(ctx);
                destination.delete();
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                throw new RemoteException(localStrings.getLocalString("web.server.servlet.error_unloading_servlet", "An error was encountered while unloading servlets"));
            }
        }
    }

    private void unsetSecurityInfo(Context context, WebBundleDescriptor descriptor) {
        String appName = descriptor.getApplication().getName();
        AccessControlInfo accInfo = AccessControlInfo.getInstance(context);
        Enumeration e10 = descriptor.getSecurityConstraints();
        while (e10.hasMoreElements()) {
            SecurityConstraintImpl sc = (SecurityConstraintImpl)e10.nextElement();
            this.removeSecurityConstraint(appName, context, accInfo, sc);
        }
        AccessControlInfo.removeInstance(context);
        RoleMapper.removeRoleMapper(descriptor.getApplication().getName());
    }
}

