/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.parser.AttributeListEx;
import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWritable;
import com.sun.xml.tree.XmlWriteContext;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private ElementNode nameScope;

    AttributeSet(AttributeSet attributeSet, boolean bl2) {
        int n2 = attributeSet.getLength();
        this.list = new Vector(n2);
        int n3 = 0;
        while (n3 < n2) {
            Node node = attributeSet.item(n3);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            node = node.cloneNode(bl2);
            ((AttributeNode)node).setNameScope(null);
            this.list.addElement(node);
            ++n3;
        }
    }

    AttributeSet(ElementNode elementNode) {
        this.list = new Vector(5);
        this.nameScope = elementNode;
    }

    AttributeSet(AttributeList attributeList) throws DOMException {
        int n2 = attributeList.getLength();
        AttributeListEx attributeListEx = null;
        this.list = new Vector(n2);
        if (attributeList instanceof AttributeListEx) {
            attributeListEx = (AttributeListEx)attributeList;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.list.addElement(new AttributeNode(attributeList.getName(n3), attributeList.getValue(n3), attributeListEx == null ? true : attributeListEx.isSpecified(n3), attributeListEx == null ? null : attributeListEx.getDefault(n3)));
            ++n3;
        }
        this.list.trimToSize();
    }

    public int getLength() {
        return this.list.size();
    }

    ElementNode getNameScope() {
        return this.nameScope;
    }

    public Node getNamedItem(String string) {
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            Node node = this.item(n3);
            if (node.getNodeName().equals(string)) {
                return node;
            }
            ++n3;
        }
        return null;
    }

    String getValue(String string) {
        Attr attr = (Attr)this.getNamedItem(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.list.size()) {
            if (((AttributeNode)this.list.elementAt(n2)).isReadonly()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Node item(int n2) {
        if (n2 < 0 || n2 >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(n2);
    }

    public Node removeNamedItem(String string) throws DOMException {
        int n2 = this.list.size();
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n3 = 0;
        while (n3 < n2) {
            Node node = this.item(n3);
            if (node.getNodeName().equals(string)) {
                AttributeNode attributeNode = (AttributeNode)node;
                if (attributeNode.getDefaultValue() != null) {
                    attributeNode = new AttributeNode(attributeNode);
                    attributeNode.setOwnerDocument((XmlDocument)this.nameScope.getOwnerDocument());
                    this.list.setElementAt(attributeNode, n3);
                } else {
                    this.list.removeElementAt(n3);
                }
                attributeNode.setNameScope(null);
                return node;
            }
            ++n3;
        }
        throw new DomEx(8);
    }

    void setNameScope(ElementNode elementNode) {
        if (elementNode != null && this.nameScope != null) {
            throw new IllegalStateException(elementNode.getMessage("A-004"));
        }
        this.nameScope = elementNode;
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n3);
            attributeNode.setNameScope(null);
            attributeNode.setNameScope(elementNode);
            ++n3;
        }
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.nameScope.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getNameScope() != null) {
            throw new DomEx(10);
        }
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n3);
            if (attributeNode2.getNodeName().equals(node.getNodeName())) {
                if (attributeNode2.isReadonly()) {
                    throw new DomEx(7);
                }
                attributeNode.setNameScope(this.nameScope);
                this.list.setElementAt(node, n3);
                attributeNode2.setNameScope(null);
                return attributeNode2;
            }
            ++n3;
        }
        attributeNode.setNameScope(this.nameScope);
        this.list.addElement(node);
        return null;
    }

    public void setReadonly() {
        this.readonly = true;
        int n2 = 0;
        while (n2 < this.list.size()) {
            ((AttributeNode)this.list.elementAt(n2)).setReadonly(true);
            ++n2;
        }
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n2 = this.list.size();
        int n3 = 0;
        while (n3 < n2) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n3);
            if (attributeNode.getSpecified()) {
                writer.write(32);
                attributeNode.writeXml(xmlWriteContext);
            }
            ++n3;
        }
    }
}

