/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;

public class BasicAttribute
implements Attribute {
    protected String attrID;
    protected transient Vector values;
    protected boolean ordered = false;
    private static final long serialVersionUID = 6743528196119291326L;

    public BasicAttribute(String string) {
        this(string, false);
    }

    public BasicAttribute(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttribute(String string, Object object, boolean bl2) {
        this(string, bl2);
        this.values.addElement(object);
    }

    public BasicAttribute(String string, boolean bl2) {
        this.attrID = string;
        this.values = new Vector();
        this.ordered = bl2;
    }

    public void add(int n2, Object object) {
        if (!this.isOrdered() && this.contains(object)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        this.values.insertElementAt(object, n2);
    }

    public boolean add(Object object) {
        if (this.isOrdered() || this.find(object) < 0) {
            this.values.addElement(object);
            return true;
        }
        return false;
    }

    private static boolean arrayEquals(Object object, Object object2) {
        int n2 = Array.getLength(object);
        if (n2 != Array.getLength(object2)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            Object object3 = Array.get(object, n3);
            Object object4 = Array.get(object2, n3);
            if (object3 == null || object4 == null ? object3 != object4 : !object3.equals(object4)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void clear() {
        this.values.setSize(0);
    }

    public Object clone() {
        BasicAttribute basicAttribute;
        try {
            basicAttribute = (BasicAttribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            basicAttribute = new BasicAttribute(this.attrID, this.ordered);
        }
        basicAttribute.values = (Vector)this.values.clone();
        return basicAttribute;
    }

    public boolean contains(Object object) {
        return this.find(object) >= 0;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Attribute) {
            int n2;
            Attribute attribute = (Attribute)object;
            if (this.isOrdered() != attribute.isOrdered()) {
                return false;
            }
            if (this.attrID.equals(attribute.getID()) && (n2 = this.size()) == attribute.size()) {
                try {
                    if (this.isOrdered()) {
                        int n3 = 0;
                        while (n3 < n2) {
                            if (!BasicAttribute.valueEquals(this.get(n3), attribute.get(n3))) {
                                return false;
                            }
                            ++n3;
                        }
                    } else {
                        NamingEnumeration namingEnumeration = attribute.getAll();
                        while (namingEnumeration.hasMoreElements()) {
                            if (this.find(namingEnumeration.nextElement()) >= 0) continue;
                            return false;
                        }
                    }
                }
                catch (NamingException namingException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private int find(Object object) {
        if (object == null) {
            int n2 = this.values.size();
            int n3 = 0;
            while (n3 < n2) {
                if (this.values.elementAt(n3) == null) {
                    return n3;
                }
                ++n3;
            }
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n4 = this.values.size();
                int n5 = 0;
                while (n5 < n4) {
                    Object e10 = this.values.elementAt(n5);
                    if (e10 != null && clazz == e10.getClass() && BasicAttribute.arrayEquals(object, e10)) {
                        return n5;
                    }
                    ++n5;
                }
            } else {
                return this.values.indexOf(object, 0);
            }
        }
        return -1;
    }

    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException("Attribute " + this.getID() + " has no value");
        }
        return this.values.elementAt(0);
    }

    public Object get(int n2) throws NamingException {
        return this.values.elementAt(n2);
    }

    public NamingEnumeration getAll() throws NamingException {
        return new ValuesEnumImpl();
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute definition");
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("attribute syntax");
    }

    public String getID() {
        return this.attrID;
    }

    public int hashCode() {
        int n2 = this.attrID.hashCode();
        int n3 = this.values.size();
        int n4 = 0;
        while (n4 < n3) {
            Object e10 = this.values.elementAt(n4);
            if (e10 != null) {
                if (e10.getClass().isArray()) {
                    int n5 = Array.getLength(e10);
                    int n6 = 0;
                    while (n6 < n5) {
                        Object object = Array.get(e10, n6);
                        if (object != null) {
                            n2 += object.hashCode();
                        }
                        ++n6;
                    }
                } else {
                    n2 += e10.hashCode();
                }
            }
            ++n4;
        }
        return n2;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.values = new Vector(n2);
        while (--n2 >= 0) {
            this.values.addElement(objectInputStream.readObject());
        }
    }

    public Object remove(int n2) {
        Object e10 = this.values.elementAt(n2);
        this.values.removeElementAt(n2);
        return e10;
    }

    public boolean remove(Object object) {
        int n2 = this.find(object);
        if (n2 >= 0) {
            this.values.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public Object set(int n2, Object object) {
        if (!this.isOrdered() && this.contains(object)) {
            throw new IllegalStateException("Cannot add duplicate to unordered attribute");
        }
        Object e10 = this.values.elementAt(n2);
        this.values.setElementAt(object, n2);
        return e10;
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.attrID) + ": ");
        if (this.values.size() == 0) {
            stringBuffer.append("No values");
        } else {
            boolean bl2 = true;
            Enumeration enumeration = this.values.elements();
            while (enumeration.hasMoreElements()) {
                if (!bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(enumeration.nextElement());
                bl2 = false;
            }
        }
        return stringBuffer.toString();
    }

    private static boolean valueEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            return BasicAttribute.arrayEquals(object, object2);
        }
        return object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.values.size());
        int n2 = 0;
        while (n2 < this.values.size()) {
            objectOutputStream.writeObject(this.values.elementAt(n2));
            ++n2;
        }
    }

    class ValuesEnumImpl
    implements NamingEnumeration {
        Enumeration list;

        ValuesEnumImpl() {
            this.list = BasicAttribute.this.values.elements();
        }

        public void close() throws NamingException {
            this.list = null;
        }

        public boolean hasMore() throws NamingException {
            return this.list.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.list.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.list.nextElement();
        }

        public Object nextElement() {
            return this.list.nextElement();
        }
    }
}

