/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SunJavaCompiler;
import org.apache.jasper.runtime.JspLoader;

public class JspEngineContext {
    JspReader reader;
    ServletWriter writer;
    ServletContext context;
    JspLoader loader;
    String classpath;
    boolean isErrPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    HttpServletRequest req;
    HttpServletResponse res;

    public JspEngineContext(JspLoader loader, String classpath, ServletContext context, String jspFile, boolean isErrPage, Options options, HttpServletRequest req, HttpServletResponse res) {
        this.loader = loader;
        this.classpath = classpath;
        this.context = context;
        this.jspFile = jspFile;
        this.isErrPage = isErrPage;
        this.options = options;
        this.req = req;
        this.res = res;
    }

    public Compiler createCompiler() throws JasperException {
        JspCompiler jspCompiler = new JspCompiler(this);
        jspCompiler.setJavaCompiler(new SunJavaCompiler());
        return jspCompiler;
    }

    public JspLoader getClassLoader() {
        return this.loader;
    }

    public String getClassPath() {
        return String.valueOf(this.loader.getClassPath()) + this.classpath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public final String getFullClassName() {
        if (this.servletPackageName == null) {
            return this.servletClassName;
        }
        return String.valueOf(this.servletPackageName) + "." + this.servletClassName;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getOutputDir() {
        return this.options.scratchDir().toString();
    }

    public JspReader getReader() {
        return this.reader;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public boolean keepGenerated() {
        return this.options.keepGenerated();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.servletPackageName = servletPackageName;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }
}

