/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class ForwardGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    String page;
    boolean isExpression = false;
    Hashtable params;

    public ForwardGenerator(Hashtable attrs, Hashtable param) throws JasperException {
        if (attrs.size() != 1) {
            throw new JasperException(Constants.getString("jsp.error.invalid.forward"));
        }
        this.page = (String)attrs.get("page");
        if (this.page == null) {
            throw new JasperException(Constants.getString("jsp.error.invalid.forward"));
        }
        this.params = param;
        this.isExpression = JspUtil.isExpression(this.page);
    }

    public void generate(ServletWriter writer, Class phase) {
        boolean initial = true;
        String sep = "?";
        writer.println("if (true) {");
        writer.pushIndent();
        writer.println("out.clear();");
        writer.println("String _jspx_qfStr = \"\";");
        if (this.params.size() > 0) {
            Enumeration en2 = this.params.keys();
            while (en2.hasMoreElements()) {
                String key = (String)en2.nextElement();
                String[] value = (String[])this.params.get(key);
                if (initial) {
                    sep = "?";
                    initial = false;
                } else {
                    sep = "&";
                }
                if (value.length == 1 && JspUtil.isExpression(value[0])) {
                    writer.println("_jspx_qfStr = _jspx_qfStr + \"" + sep + key + "=\" + " + JspUtil.getExpr(value[0]) + ";");
                    continue;
                }
                if (value.length == 1) {
                    writer.println("_jspx_qfStr = _jspx_qfStr + \"" + sep + key + "=\" + \"" + value[0] + "\";");
                    continue;
                }
                int i2 = 0;
                while (i2 < value.length) {
                    if (!JspUtil.isExpression(value[i2])) {
                        writer.println("_jspx_qfStr = _jspx_qfStr + \"" + sep + key + "=\" + \"" + value[i2] + "\";");
                    } else {
                        writer.println("_jspx_qfStr = _jspx_qfStr + \"" + sep + key + "=\" +" + JspUtil.getExpr(value[i2]) + ";");
                    }
                    if (sep.equals("?")) {
                        sep = "&";
                    }
                    ++i2;
                }
            }
        }
        if (!this.isExpression) {
            writer.println("pageContext.forward(" + writer.quoteString(this.page) + " +  _jspx_qfStr);");
        } else {
            writer.println("pageContext.forward(" + JspUtil.getExpr(this.page) + " +  _jspx_qfStr);");
        }
        writer.println("return;");
        writer.popIndent();
        writer.println("}");
    }
}

