/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.compiler.ClassFileData;
import org.apache.jasper.compiler.ClassName;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;

public class JspCompiler
extends Compiler
implements Mangler {
    String pkgName;
    String className;
    String javaFileName;
    String classFileName;
    File jsp;
    String outputDir;
    ClassFileData cfd;
    boolean outDated;
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public JspCompiler(JspEngineContext ctxt) throws JasperException {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOutputDir();
        this.outDated = false;
        this.setMangler(this);
        this.computePackageName();
        this.computeClassFileName();
    }

    private final void computeClassFileData() {
        block7: {
            ServletContext ctx = this.ctxt.getServletContext();
            File jspReal = null;
            jspReal = ctx != null ? new File(ctx.getRealPath(this.jsp.getPath())) : this.jsp;
            File classFile = new File(this.classFileName);
            if (!classFile.exists()) {
                this.className = this.getInitialClassName();
                this.cfd = new ClassFileData(true, this.classFileName, this.className);
                this.outDated = true;
            } else {
                boolean bl2 = this.outDated = classFile.lastModified() < jspReal.lastModified();
                if (this.outDated) {
                    this.cfd = new ClassFileData(this.outDated, this.classFileName, this.className);
                    this.cfd.incrementNumber();
                } else {
                    this.cfd = new ClassFileData(this.outDated, this.classFileName, null);
                }
                try {
                    String classNameFromFile = ClassName.getClassName(this.classFileName);
                    String cn2 = this.cfd.getClassName();
                    int lastDot = cn2.lastIndexOf(46);
                    if (lastDot != -1) {
                        this.className = cn2.substring(lastDot + 1, classNameFromFile.length());
                        break block7;
                    }
                    this.className = cn2;
                }
                catch (JasperException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
    }

    void computeClassFileName() {
        String prefix = this.getPrefix(this.jsp.getPath());
        this.classFileName = String.valueOf(prefix) + this.getBaseClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = String.valueOf(this.outputDir) + File.separatorChar + this.classFileName;
        }
    }

    public final void computeJavaFileName() {
        this.javaFileName = String.valueOf(this.getClassName()) + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = String.valueOf(this.outputDir) + File.separatorChar + this.javaFileName;
        }
    }

    void computePackageName() {
        String pathName = this.jsp.getPath();
        StringBuffer modifiedpkgName = new StringBuffer();
        int indexOfSepChar = pathName.lastIndexOf(File.separatorChar);
        if (indexOfSepChar == -1 || indexOfSepChar == 0) {
            this.pkgName = null;
        } else {
            int i2 = 0;
            while (i2 < keywords.length) {
                char fs = File.separatorChar;
                int index1 = pathName.indexOf(String.valueOf(fs) + keywords[i2]);
                int index2 = pathName.indexOf(keywords[i2]);
                if (index1 != -1 || index2 != -1) {
                    int index = index2 == -1 ? index1 : index2;
                    while (index != -1) {
                        String tmpathName = String.valueOf(pathName.substring(0, index + 1)) + '%';
                        pathName = String.valueOf(tmpathName) + pathName.substring(index + 2);
                        index = pathName.indexOf(String.valueOf(fs) + keywords[i2]);
                    }
                }
                ++i2;
            }
            pathName = pathName.replace('.', '_');
            this.pkgName = pathName.substring(0, pathName.lastIndexOf(File.separatorChar)).replace(File.separatorChar, '.');
            int i3 = 0;
            while (i3 < this.pkgName.length()) {
                if (Character.isLetter(this.pkgName.charAt(i3)) || this.pkgName.charAt(i3) == '.') {
                    modifiedpkgName.append(this.pkgName.substring(i3, i3 + 1));
                } else {
                    modifiedpkgName.append(JspCompiler.mangleChar(this.pkgName.charAt(i3)));
                }
                ++i3;
            }
            if (modifiedpkgName.charAt(0) == '.') {
                String modifiedpkgNameString = modifiedpkgName.toString();
                this.pkgName = modifiedpkgNameString.substring(1, modifiedpkgName.length());
            } else {
                this.pkgName = modifiedpkgName.toString();
            }
        }
    }

    private final String getBaseClassName() {
        String className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        StringBuffer modifiedClassName = new StringBuffer();
        int i2 = 0;
        while (i2 < className.length()) {
            if (Character.isLetterOrDigit(className.charAt(i2))) {
                modifiedClassName.append(className.substring(i2, i2 + 1));
            } else {
                modifiedClassName.append(JspCompiler.mangleChar(className.charAt(i2)));
            }
            ++i2;
        }
        return modifiedClassName.toString();
    }

    public final String getClassFileName() {
        return this.classFileName;
    }

    public final String getClassName() {
        if (this.className == null) {
            this.computeClassFileData();
        }
        return this.className;
    }

    private final String getInitialClassName() {
        String prefix = this.getPrefix(this.jsp.getPath());
        return String.valueOf(prefix) + this.getBaseClassName() + "_jsp_" + "0";
    }

    public final String getJavaFileName() {
        if (this.javaFileName == null) {
            this.computeJavaFileName();
        }
        return this.javaFileName;
    }

    public final String getPackageName() {
        return this.pkgName;
    }

    private final String getPrefix(String pathName) {
        if (pathName != null) {
            StringBuffer modifiedName = new StringBuffer();
            int i2 = 0;
            while (i2 < pathName.length()) {
                if (Character.isLetter(pathName.charAt(i2))) {
                    modifiedName.append(pathName.substring(i2, i2 + 1));
                } else {
                    modifiedName.append(JspCompiler.mangleChar(pathName.charAt(i2)));
                }
                ++i2;
            }
            return modifiedName.toString();
        }
        return "";
    }

    public boolean isOutDated() {
        ServletContext ctx = this.ctxt.getServletContext();
        File jspReal = null;
        jspReal = ctx != null ? new File(ctx.getRealPath(this.jsp.getPath())) : this.jsp;
        File classFile = new File(this.classFileName);
        this.outDated = classFile.exists() ? classFile.lastModified() < jspReal.lastModified() : true;
        return this.outDated;
    }

    private static final String mangleChar(char ch2) {
        String s2 = Integer.toHexString(ch2);
        int nzeros = 5 - s2.length();
        char[] result = new char[6];
        result[0] = 95;
        int i2 = 1;
        while (i2 <= nzeros) {
            result[i2] = 48;
            ++i2;
        }
        int i3 = nzeros + 1;
        int j2 = 0;
        while (i3 < 6) {
            result[i3] = s2.charAt(j2);
            ++i3;
            ++j2;
        }
        return new String(result);
    }
}

