/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";

    public static void checkAttributes(String typeOfTag, Hashtable attrs, ValidAttribute[] validAttributes) throws JasperException {
        boolean valid = true;
        Hashtable temp = (Hashtable)attrs.clone();
        String missingAttribute = null;
        int i2 = 0;
        while (i2 < validAttributes.length) {
            if (validAttributes[i2].mandatory) {
                if (temp.get(validAttributes[i2].name) != null) {
                    temp.remove(validAttributes[i2].name);
                    valid = true;
                } else {
                    valid = false;
                    missingAttribute = validAttributes[i2].name;
                    break;
                }
            }
            ++i2;
        }
        if (!valid) {
            throw new JasperException(Constants.getString("jsp.error.mandatory.attribute", new Object[]{typeOfTag, missingAttribute}));
        }
        if (temp.size() == 0) {
            return;
        }
        Enumeration enumeration = temp.keys();
        String attribute = null;
        while (enumeration.hasMoreElements()) {
            valid = false;
            attribute = (String)enumeration.nextElement();
            int i3 = 0;
            while (i3 < validAttributes.length) {
                if (attribute.equals(validAttributes[i3].name)) {
                    valid = true;
                    break;
                }
                ++i3;
            }
            if (valid) continue;
            throw new JasperException(Constants.getString("jsp.error.invalid.attribute", new Object[]{typeOfTag, attribute}));
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "&;`'\"|*?~<>^()[]{}$\\\n";
        int index = 0;
        while (index < unescString.length()) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = String.valueOf(escString) + "\\";
            }
            escString = String.valueOf(escString) + nextChar;
            ++index;
        }
        return escString;
    }

    public static String getExpr(String expression) {
        int length = expression.length();
        String returnString = expression.startsWith(OPEN_EXPR) && expression.endsWith(CLOSE_EXPR) ? expression.substring(OPEN_EXPR.length(), length - CLOSE_EXPR.length()) : "";
        return returnString;
    }

    public static boolean isExpression(String token) {
        return token.startsWith(OPEN_EXPR) && token.endsWith(CLOSE_EXPR);
    }

    public static XmlDocument parseXMLDoc(InputStream in, URL dtdURL, String dtdId) throws JasperException {
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        ValidatingParser parser = new ValidatingParser();
        Resolver resolver = new Resolver();
        resolver.registerCatalogEntry(dtdId, dtdURL.toString());
        try {
            parser.setEntityResolver(resolver);
            builder.setParser(parser);
            builder.setDisableNamespaces(false);
            parser.parse(new InputSource(in));
        }
        catch (SAXException sx) {
            throw new JasperException(Constants.getString("jsp.error.parse.error.in.TLD", new Object[]{sx.getMessage()}));
        }
        catch (IOException io) {
            throw new JasperException(Constants.getString("jsp.error.unable.to.open.TLD", new Object[]{io.getMessage()}));
        }
        XmlDocument tld = builder.getDocument();
        return tld;
    }

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == '%' && chars[i2 + 1] == '\\' && chars[i2 + 2] == '\\' && chars[i2 + 3] == '>') {
                caw.write(37);
                caw.write(62);
                i2 += 3;
            } else {
                caw.write(chars[i2]);
            }
            ++i2;
        }
        return caw.toCharArray();
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String name) {
            this(name, false);
        }

        public ValidAttribute(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }
    }
}

