/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.ApplicationSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.RequestAdapter;
import org.apache.tomcat.core.RequestUtil;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.ServerSessionManager;
import org.apache.tomcat.util.StringManager;

public class Request {
    protected String requestURI;
    protected String queryString;
    String serverName;
    protected Vector cookies = new Vector();
    protected String contextPath;
    protected String lookupPath;
    protected String servletPath;
    protected String pathInfo;
    protected Hashtable parameters = new Hashtable();
    protected String reqSessionId;
    protected int contentLength = -1;
    protected String contentType = null;
    protected String charEncoding = null;
    protected String authType;
    protected String remoteUser;
    protected RequestAdapter reqA;
    protected Response response;
    protected HttpServletRequestFacade requestFacade;
    protected Context context;
    protected Hashtable attributes = new Hashtable();
    protected ServerSession serverSession;
    protected boolean didReadFormData;
    protected boolean didParameters;
    protected boolean didCookies;
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.core");

    public Request() {
        this.requestFacade = new HttpServletRequestFacade(this);
    }

    public void addQueryString(String inQueryString) {
        if (inQueryString == null || inQueryString.trim().length() <= 0) {
            return;
        }
        this.queryString = this.queryString == null || this.queryString.trim().length() <= 0 ? inQueryString : String.valueOf(inQueryString) + "&" + this.queryString;
        Hashtable newParameters = null;
        try {
            newParameters = HttpUtils.parseQueryString(this.queryString);
        }
        catch (Exception exception) {
            return;
        }
        if (newParameters != null) {
            this.parameters = RequestUtil.mergeParameters(newParameters, this.parameters);
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        this.charEncoding = this.reqA.getCharacterEncoding();
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        this.charEncoding = this.getCharsetFromContentType(this.getContentType());
        return this.charEncoding;
    }

    public String getCharsetFromContentType(String type) {
        return RequestUtil.getCharsetFromContentType(type);
    }

    public int getContentLength() {
        if (this.contentLength > -1) {
            return this.contentLength;
        }
        this.contentLength = this.reqA.getContentLength();
        if (this.contentLength > -1) {
            return this.contentLength;
        }
        this.contentLength = this.getIntHeader("content-length");
        return this.contentLength;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.reqA.getContentType();
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader("content-type");
        if (this.contentType != null) {
            return this.contentType;
        }
        return this.contentType;
    }

    public Context getContext() {
        return this.context;
    }

    public Cookie[] getCookies() {
        if (!this.didCookies) {
            this.didCookies = true;
            this.processCookies();
        }
        Cookie[] cookieArray = new Cookie[this.cookies.size()];
        int i2 = 0;
        while (i2 < this.cookies.size()) {
            cookieArray[i2] = (Cookie)this.cookies.elementAt(i2);
            ++i2;
        }
        return cookieArray;
    }

    public long getDateHeader(String name) {
        return this.reqA.getMimeHeaders().getDateHeader(name);
    }

    public HttpServletRequestFacade getFacade() {
        return this.requestFacade;
    }

    public String getHeader(String name) {
        return this.reqA.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.reqA.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        Vector v2 = this.reqA.getMimeHeaders().getHeadersVector(name);
        return v2.elements();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.reqA.getInputStream();
    }

    public int getIntHeader(String name) {
        return this.reqA.getMimeHeaders().getIntHeader(name);
    }

    public String getLookupPath() {
        return this.lookupPath;
    }

    public String getMethod() {
        return this.reqA.getMethod();
    }

    public Enumeration getParameterNames() {
        if (!this.didParameters) {
            this.processFormData(this.getQueryString());
        }
        if (!this.didReadFormData) {
            this.readFormData();
        }
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        String qString;
        if (!this.didParameters && (qString = this.getQueryString()) != null) {
            this.processFormData(qString);
        }
        if (!this.didReadFormData) {
            this.readFormData();
        }
        return (String[])this.parameters.get(name);
    }

    public Hashtable getParametersCopy() {
        if (!this.didParameters) {
            this.processFormData(this.getQueryString());
        }
        if (!this.didReadFormData) {
            this.readFormData();
        }
        return (Hashtable)this.parameters.clone();
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getProtocol() {
        return this.reqA.getProtocol();
    }

    public String getQueryString() {
        if (this.queryString != null) {
            return this.queryString;
        }
        return this.reqA.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        return RequestUtil.getReader(this);
    }

    public String getRemoteAddr() {
        return this.reqA.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.reqA.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public RequestAdapter getRequestAdapter() {
        return this.reqA;
    }

    public String getRequestURI() {
        if (this.requestURI != null) {
            return this.requestURI;
        }
        return this.reqA.getRequestURI();
    }

    public String getRequestedSessionId() {
        return this.reqSessionId;
    }

    public String getScheme() {
        return this.reqA.getScheme();
    }

    public String getServerName() {
        if (this.serverName != null) {
            return this.serverName;
        }
        this.serverName = this.reqA.getServerName();
        if (this.serverName != null) {
            return this.serverName;
        }
        String hostHeader = this.getHeader("host");
        if (hostHeader != null) {
            int i2 = hostHeader.indexOf(58);
            if (i2 > -1) {
                hostHeader = hostHeader.substring(0, i2);
            }
            this.serverName = hostHeader;
            return this.serverName;
        }
        System.out.println("No server name, defaulting to localhost");
        this.serverName = "localhost";
        return this.serverName;
    }

    public int getServerPort() {
        return this.reqA.getServerPort();
    }

    public ServerSession getServerSession(boolean create) {
        if (this.context == null) {
            System.out.println("CONTEXT WAS NEVER SET");
            return null;
        }
        if (this.serverSession == null && create) {
            this.serverSession = ServerSessionManager.getManager().getServerSession(this, this.response, create);
            this.serverSession.accessed();
        }
        return this.serverSession;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public ApplicationSession getSession() {
        return this.getSession(true);
    }

    public ApplicationSession getSession(boolean create) {
        this.getServerSession(create);
        ApplicationSession appSession = null;
        if (this.serverSession != null) {
            appSession = this.serverSession.getApplicationSession(this.context, create);
        }
        return appSession;
    }

    public void processCookies() {
        RequestUtil.processCookies(this, this.cookies);
    }

    public void processFormData(InputStream in, int contentLength) {
        byte[] buf = new byte[contentLength];
        int read = RequestUtil.readData(in, buf, contentLength);
        String s2 = new String(buf, 0, read);
        this.processFormData(s2);
    }

    public void processFormData(String data) {
        this.didParameters = true;
        RequestUtil.processFormData(data, this.parameters);
    }

    private void readFormData() {
        Hashtable postParameters;
        this.didReadFormData = true;
        if (!this.didParameters) {
            this.processFormData(this.getQueryString());
        }
        if ((postParameters = RequestUtil.readFormData(this)) != null) {
            this.parameters = RequestUtil.mergeParameters(this.parameters, postParameters);
        }
    }

    public void recycle() {
        this.response = null;
        this.context = null;
        this.attributes.clear();
        this.parameters.clear();
        this.cookies.removeAllElements();
        this.contentLength = -1;
        this.contentType = null;
        this.charEncoding = null;
        this.authType = null;
        this.remoteUser = null;
        this.reqSessionId = null;
        this.serverSession = null;
        this.didParameters = false;
        this.didReadFormData = false;
        this.didCookies = false;
        if (this.reqA != null) {
            this.reqA.recycle();
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void replaceQueryString(String inQueryString) {
        this.queryString = inQueryString;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setCharEncoding(String enc) {
        this.charEncoding = enc;
    }

    public void setCharacterEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setContext(Context context) {
        this.context = context;
        this.contextPath = context.getPath();
        String requestURI = this.getRequestURI();
        this.lookupPath = requestURI.substring(this.contextPath.length(), requestURI.length());
        int qindex = this.lookupPath.indexOf("?");
        if (qindex > -1) {
            this.lookupPath = this.lookupPath.substring(0, qindex);
        }
        if (this.lookupPath.length() < 1) {
            this.lookupPath = "/";
        }
    }

    public void setParameters(Hashtable h2) {
        if (h2 != null) {
            this.parameters = h2;
        }
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        try {
            this.parameters = HttpUtils.parseQueryString(queryString);
        }
        catch (Exception exception) {
            this.parameters.clear();
        }
    }

    public void setRequestAdapter(RequestAdapter reqA) {
        this.reqA = reqA;
    }

    public void setRequestURI(String r2) {
        this.requestURI = r2;
    }

    public void setRequestedSessionId(String reqSessionId) {
        this.reqSessionId = reqSessionId;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerSession(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String unUrlDecode(String data) {
        try {
            return RequestUtil.URLDecode(data);
        }
        catch (NumberFormatException numberFormatException) {
            String msg = this.sm.getString("serverRequest.urlDecode.nfe", data);
            throw new IllegalArgumentException(msg);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            String msg = this.sm.getString("serverRequest.urlDecode.nfe", data);
            throw new IllegalArgumentException(msg);
        }
    }
}

