/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.jasper.runtime.JspLoader;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.DirectoryFilter;
import org.apache.tomcat.core.JarFileFilter;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.util.NetworkClassLoader;

class ServletClassLoader
extends NetworkClassLoader {
    private Container container;

    ServletClassLoader(Container container) {
        super(container.getContext().getClassLoader());
        this.container = container;
        this.initURLs();
    }

    protected Class defineClass(String className, byte[] classData) {
        return this.defineClass(className, classData, 0, classData.length, JspLoader.getProtectionDomain());
    }

    String getClassPath() {
        String separator = System.getProperty("path.separator", ":");
        String cpath = "";
        Enumeration e10 = this.getURLs();
        while (e10.hasMoreElements()) {
            URL url = (URL)e10.nextElement();
            cpath = String.valueOf(cpath) + separator + url.getFile();
        }
        return cpath;
    }

    private void getJars(Vector v2, File f2) {
        JarFileFilter jarfilter = new JarFileFilter();
        DirectoryFilter dirfilter = new DirectoryFilter();
        if (f2.exists() && f2.isDirectory() && f2.isAbsolute()) {
            String[] jarlist = f2.list(jarfilter);
            int i2 = 0;
            while (jarlist != null && i2 < jarlist.length) {
                v2.addElement(jarlist[i2]);
                ++i2;
            }
            String[] dirlist = f2.list(dirfilter);
            int i3 = 0;
            while (dirlist != null && i3 < dirlist.length) {
                File dir = new File(f2, dirlist[i3]);
                this.getJars(v2, dir);
                ++i3;
            }
        }
    }

    private void initURLs() {
        URL baseURL = this.container.getServletBase();
        String protocol = baseURL.getProtocol();
        int port = baseURL.getPort();
        String hostname = baseURL.getHost();
        String basepath = baseURL.getFile();
        Enumeration e10 = this.container.getClassPaths();
        while (e10.hasMoreElements()) {
            String cpath = (String)e10.nextElement();
            try {
                URL classesURL = new URL(protocol, hostname, port, String.valueOf(basepath) + cpath + "/");
                this.addURL(classesURL);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        Enumeration e11 = this.container.getLibPaths();
        while (e11.hasMoreElements()) {
            String libpath = (String)e11.nextElement();
            File f2 = new File(String.valueOf(basepath) + libpath + "/");
            Vector jars = new Vector();
            this.getJars(jars, f2);
            int i2 = 0;
            while (i2 < jars.size()) {
                try {
                    String jarfile = (String)jars.elementAt(i2);
                    URL jarURL = new URL(protocol, hostname, port, String.valueOf(basepath) + jarfile);
                    this.addURL(jarURL);
                }
                catch (MalformedURLException malformedURLException) {}
                ++i2;
            }
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.setParent(this.container.getContext().getClassLoader());
        return super.loadClass(name, resolve);
    }

    synchronized Class loadServlet(ServletWrapper wrapper, String name) throws ClassNotFoundException {
        Class clazz = this.loadClass(name, true);
        return clazz;
    }
}

