/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.HttpServletRequestFacade;
import org.apache.tomcat.core.HttpServletResponseFacade;
import org.apache.tomcat.core.InterceptorException;
import org.apache.tomcat.core.InvocationHandler;
import org.apache.tomcat.core.LifecycleInvocationHandler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestAdapterImpl;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ResponseAdapterImpl;
import org.apache.tomcat.core.ServiceInvocationHandler;
import org.apache.tomcat.core.ServletConfigImpl;
import org.apache.tomcat.core.ServletContextFacade;
import org.apache.tomcat.util.StringManager;

class ServletWrapper {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Container container;
    private String description = null;
    private String servletClassName;
    private Class servletClass;
    private File servletClassFile;
    private String path = null;
    private Servlet servlet;
    private long lastAccessed;
    private ServletConfigImpl config;
    private boolean isReloadable = false;
    private long classFileLastMod = 0L;
    private int serviceCount = 0;

    ServletWrapper(Container container) {
        this.container = container;
        this.config = new ServletConfigImpl(container.getContext());
    }

    void destroy() {
        if (this.servlet != null) {
            ServletWrapper servletWrapper = this;
            synchronized (servletWrapper) {
                while (this.serviceCount > 0) {
                    try {
                        this.wait(30000L);
                        break;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    final Servlet sinstance = this.servlet;
                    Context context = this.getContext();
                    this.handleInvocation(context.getDestroyInterceptors().elements(), new LifecycleInvocationHandler(context, this.servlet){

                        void method() throws ServletException {
                            sinstance.destroy();
                        }
                    });
                }
                catch (IOException iOException) {
                }
                catch (ServletException servletException) {}
            }
        }
    }

    private Context getContext() {
        return this.container.getContext();
    }

    String getPath() {
        return this.path;
    }

    String getServletClass() {
        return this.servletClassName;
    }

    String getServletDescription() {
        return this.description;
    }

    String getServletName() {
        return this.config.getServletName();
    }

    public void handleException(HttpServletRequestFacade request, HttpServletResponseFacade response, Throwable t2) {
        Context context = request.getRealRequest().getContext();
        ServletContextFacade contextFacade = context.getFacade();
        String path = null;
        Class<?> clazz = t2.getClass();
        while (path == null && clazz != null) {
            String name = clazz.getName();
            path = context.getErrorPage(name);
            clazz = clazz.getSuperclass();
        }
        if (path != null && request.getAttribute("javax.servlet.error.exception_type") == null) {
            RequestDispatcher rd = contextFacade.getRequestDispatcher(path);
            request.setAttribute("javax.servlet.error.exception_type", t2.getClass().getName());
            request.setAttribute("javax.servlet.error.message", t2.getMessage());
            try {
                try {
                    response.getRealResponse().reset();
                    rd.forward(request, response);
                }
                catch (IllegalStateException illegalStateException) {
                    rd.include(request, response);
                }
            }
            catch (IOException iOException) {
            }
            catch (ServletException servletException) {}
        } else {
            try {
                this.sendInternalServletError(t2, response);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleInvocation(Enumeration interceptors, InvocationHandler inv) throws ServletException, IOException {
        block10: {
            iStack = new Stack<E>();
            try {
                try {
                    e = interceptors;
                    while (e.hasMoreElements()) {
                        iStack.push(e.nextElement());
                        inv.preInvoke(iStack.peek());
                    }
                    inv.method();
                }
                catch (InterceptorException v0) {
                }
                var5_5 = null;
                ** while (!iStack.empty())
            }
            catch (Throwable var4_7) {
                var5_6 = null;
                ** while (!iStack.empty())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    inv.postInvoke(iStack.pop());
                }
                catch (InterceptorException v1) {}
                continue;
lbl21:
                // 1 sources

                break block10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    inv.postInvoke(iStack.pop());
                }
                catch (InterceptorException v2) {}
                continue;
            }
lbl31:
            // 1 sources

            throw var4_7;
        }
    }

    void handleRequest(HttpServletRequestFacade request, HttpServletResponseFacade response) throws IOException {
        Object context;
        ServletWrapper servletWrapper = this;
        synchronized (servletWrapper) {
            if (this.path != null && this.servletClass == null && this.servletClassName == null) {
                String requestURI = String.valueOf(this.path) + request.getPathInfo();
                RequestDispatcher rd = request.getRequestDispatcher(requestURI);
                try {
                    try {
                        rd.forward(request, response);
                    }
                    catch (IllegalStateException illegalStateException) {
                        rd.include(request, response);
                    }
                }
                catch (ServletException servletException) {
                    response.sendError(404);
                }
                catch (IOException iOException) {
                    response.sendError(404);
                }
                Object var4_16 = null;
                return;
            }
            if (this.servlet == null) {
                try {
                    this.loadServlet();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    response.sendError(404);
                    Object var4_17 = null;
                    return;
                }
                catch (Exception e10) {
                    this.servlet = null;
                    this.sendInternalServletError(e10, response);
                    Object var4_18 = null;
                    return;
                }
            }
        }
        try {
            try {
                ServletWrapper e10 = this;
                synchronized (e10) {
                    ++this.serviceCount;
                }
                context = this.getContext();
                Enumeration serviceInterceptors = ((Context)context).getServiceInterceptors().elements();
                ServiceInvocationHandler serviceHandler = new ServiceInvocationHandler((Context)context, this.servlet, request, response);
                this.handleInvocation(serviceInterceptors, serviceHandler);
            }
            catch (ServletException e11) {
                this.handleException(request, response, e11);
                Object var4_19 = null;
                ServletWrapper context2 = this;
                synchronized (context2) {
                    --this.serviceCount;
                    this.notifyAll();
                }
                return;
            }
            catch (SocketException socketException) {
                Object var4_20 = null;
                ServletWrapper context2 = this;
                synchronized (context2) {
                    --this.serviceCount;
                    this.notifyAll();
                }
                return;
            }
            catch (Throwable e12) {
                this.handleException(request, response, e12);
                Object var4_21 = null;
                ServletWrapper context2 = this;
                synchronized (context2) {
                    --this.serviceCount;
                    this.notifyAll();
                }
                return;
            }
            Object var4_22 = null;
            context = this;
        }
        catch (Throwable throwable) {
            Object var4_23 = null;
            ServletWrapper context2 = this;
            synchronized (context2) {
                --this.serviceCount;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (context) {
            --this.serviceCount;
            this.notifyAll();
        }
    }

    void loadServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
        if (this.path != null && this.servletClass == null && this.servletClassName == null) {
            RequestAdapterImpl reqA = new RequestAdapterImpl();
            ResponseAdapterImpl resA = new ResponseAdapterImpl();
            Request request = new Request();
            Response response = new Response();
            request.recycle();
            response.recycle();
            request.setRequestAdapter(reqA);
            response.setResponseAdapter(resA);
            request.setResponse(response);
            response.setRequest(request);
            String requestURI = String.valueOf(this.path) + "?" + "jsp_precompile" + "=" + "true";
            reqA.setRequestURI(String.valueOf(this.getContext().getPath()) + this.path);
            reqA.setQueryString("jsp_precompile=true");
            request.setContext(this.getContext());
            request.getSession(true);
            RequestDispatcher rd = this.config.getServletContext().getRequestDispatcher(requestURI);
            try {
                rd.forward(request.getFacade(), response.getFacade());
            }
            catch (ServletException servletException) {
            }
            catch (IOException iOException) {}
        } else {
            if (this.servletClass == null) {
                if (this.servletClassName == null) {
                    String msg = this.sm.getString("wrapper.load.noclassname");
                    throw new IllegalStateException(msg);
                }
                this.servletClass = this.container.getLoader().loadServlet(this, this.servletClassName);
            }
            this.servlet = (Servlet)this.servletClass.newInstance();
            this.config.setServletClassName(this.servlet.getClass().getName());
            try {
                final Servlet sinstance = this.servlet;
                final ServletConfigImpl servletConfig = this.config;
                Context context = this.getContext();
                this.handleInvocation(context.getInitInterceptors().elements(), new LifecycleInvocationHandler(context, this.servlet){

                    void method() throws ServletException {
                        sinstance.init(servletConfig);
                    }
                });
            }
            catch (IOException iOException) {}
        }
    }

    void printRootCause(ServletException e10, PrintWriter out) {
        Throwable cause = e10.getRootCause();
        if (cause != null) {
            out.println("<b>Root cause:</b>");
            out.println("<pre>");
            cause.printStackTrace(out);
            out.println("</pre>");
            if (cause instanceof ServletException) {
                this.printRootCause((ServletException)cause, out);
            }
        }
    }

    void sendInternalServletError(Throwable e10, HttpServletResponseFacade response) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<b>Internal Servlet Error:</b><br>");
        pw.println("<pre>");
        e10.printStackTrace(pw);
        pw.println("</pre>");
        if (e10 instanceof ServletException) {
            this.printRootCause((ServletException)e10, pw);
        }
        response.sendError(500, sw.toString());
    }

    void setInitArgs(Hashtable initArgs) {
        this.config.setInitArgs(initArgs);
    }

    void setPath(String path) {
        this.path = path;
    }

    void setReloadable(boolean reloadable) {
        this.isReloadable = reloadable;
    }

    void setServletClass(Class servletClass) {
        this.servletClass = servletClass;
        this.config.setServletClassName(this.servletClass.getName());
    }

    void setServletClass(String servletClassName) {
        this.servletClassName = servletClassName;
        this.config.setServletClassName(servletClassName);
    }

    void setServletClassFile(File servletClassFile) {
        this.servletClassFile = servletClassFile;
        this.classFileLastMod = servletClassFile.lastModified();
        this.config.setServletClassName(this.servletClassFile.getName());
    }

    void setServletDescription(String description) {
        this.description = description;
    }

    void setServletName(String servletName) {
        this.config.setServletName(servletName);
    }
}

