/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.security.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.tomcat.security.file.FileRealmDatabase;
import org.apache.tomcat.security.file.FileRealmGroup;
import org.apache.tomcat.security.file.FileRealmUser;
import org.apache.tomcat.util.HexUtils;
import org.apache.tomcat.util.StringManager;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class FileRealmTool {
    private static String[] args = null;
    private static int current = 0;
    private static FileRealmDatabase database = null;
    private static String filename = null;
    private static boolean modified = false;
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.security.file");

    private static void addGroup() {
        FileRealmGroup group;
        String name = FileRealmTool.getArg();
        if (name.length() < 1) {
            System.err.println(sm.getString("tool.missing.group"));
            System.exit(2);
        }
        if ((group = database.getGroup(name)) != null) {
            return;
        }
        group = database.createGroup(name);
        modified = true;
    }

    private static void addMember() {
        FileRealmUser user;
        String userName;
        FileRealmGroup group;
        String groupName = FileRealmTool.getArg();
        if (groupName.length() < 1) {
            System.err.println(sm.getString("tool.missing.group"));
            System.exit(2);
        }
        if ((group = database.getGroup(groupName)) == null) {
            System.err.println(sm.getString("tool.unknown.group", groupName));
            System.exit(2);
        }
        if ((userName = FileRealmTool.getArg()).length() < 1) {
            System.err.println(sm.getString("tool.missing.user"));
            System.exit(2);
        }
        if ((user = database.getUser(userName)) == null) {
            System.err.println(sm.getString("tool.unknown.user", userName));
            System.exit(2);
        }
        if (!user.hasGroup(group)) {
            user.addGroup(group);
            modified = true;
        }
    }

    private static void addRole() {
        String role;
        String principalName = FileRealmTool.getArg();
        if (principalName.length() < 1) {
            System.err.println(sm.getString("tool.missing.principal"));
            System.exit(2);
        }
        FileRealmGroup group = database.getGroup(principalName);
        FileRealmUser user = database.getUser(principalName);
        if (group == null && user == null) {
            System.err.println(sm.getString("tool.unknown.principal", principalName));
            System.exit(2);
        }
        if ((role = FileRealmTool.getArg()).length() < 1) {
            System.err.println(sm.getString("tool.missing.role"));
            System.exit(2);
        }
        if (group != null && !group.hasRole(role)) {
            group.addRole(role);
            modified = true;
        }
        if (user != null && !user.hasRole(role)) {
            user.addRole(role);
            modified = true;
        }
    }

    private static void addUser() {
        FileRealmUser user;
        String password;
        String name = FileRealmTool.getArg();
        if (name.length() < 1) {
            System.err.println(sm.getString("tool.missing.user"));
            System.exit(2);
        }
        if ((password = FileRealmTool.getArg()).length() < 1) {
            System.err.println(sm.getString("tool.missing.password"));
            System.exit(2);
        }
        if ((user = database.getUser(name)) != null) {
            user.setPassword(password);
        } else {
            user = database.createUser(name, password);
        }
        modified = true;
    }

    private static void close() {
        if (!modified) {
            return;
        }
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(filename));
        }
        catch (IOException e10) {
            System.err.println(String.valueOf(sm.getString("tool.close.open", filename)) + ": " + e10);
            e10.printStackTrace();
            System.exit(1);
        }
        try {
            database.write(stream);
        }
        catch (IOException e11) {
            System.err.println(String.valueOf(sm.getString("tool.close.write", filename)) + ": " + e11);
            e11.printStackTrace();
            System.exit(1);
        }
        try {
            ((OutputStream)stream).close();
        }
        catch (IOException iOException) {}
    }

    private static void dropGroup() {
        FileRealmGroup group;
        String name = FileRealmTool.getArg();
        if (name.length() < 1) {
            System.err.println(sm.getString("tool.missing.group"));
            System.exit(2);
        }
        if ((group = database.getGroup(name)) == null) {
            System.err.println(sm.getString("tool.unknown.group"));
            System.exit(2);
        }
        database.remove(group);
        modified = true;
    }

    private static void dropMember() {
        FileRealmUser user;
        String userName;
        FileRealmGroup group;
        String groupName = FileRealmTool.getArg();
        if (groupName.length() < 1) {
            System.err.println(sm.getString("tool.missing.group"));
            System.exit(2);
        }
        if ((group = database.getGroup(groupName)) == null) {
            System.err.println(sm.getString("tool.unknown.group", groupName));
            System.exit(2);
        }
        if ((userName = FileRealmTool.getArg()).length() < 1) {
            System.err.println(sm.getString("tool.missing.user"));
            System.exit(2);
        }
        if ((user = database.getUser(userName)) == null) {
            System.err.println(sm.getString("tool.unknown.user", userName));
            System.exit(2);
        }
        if (user.hasGroup(group)) {
            user.remove(group);
            modified = true;
        }
    }

    private static void dropRole() {
        String role;
        String principalName = FileRealmTool.getArg();
        if (principalName.length() < 1) {
            System.err.println(sm.getString("tool.missing.principal"));
            System.exit(2);
        }
        FileRealmGroup group = database.getGroup(principalName);
        FileRealmUser user = database.getUser(principalName);
        if (group == null && user == null) {
            System.err.println(sm.getString("tool.unknown.principal", principalName));
            System.exit(2);
        }
        if ((role = FileRealmTool.getArg()).length() < 1) {
            System.err.println(sm.getString("tool.missing.role"));
            System.exit(2);
        }
        if (group != null && group.hasRole(role)) {
            group.remove(role);
            modified = true;
        }
        if (user != null && user.hasRole(role)) {
            user.remove(role);
            modified = true;
        }
    }

    private static void dropUser() {
        FileRealmUser user;
        String name = FileRealmTool.getArg();
        if (name.length() < 1) {
            System.err.println(sm.getString("tool.missing.user"));
            System.exit(2);
        }
        if ((user = database.getUser(name)) == null) {
            System.err.println(sm.getString("tool.unknown.user"));
            System.exit(2);
        }
        database.remove(user);
        modified = true;
    }

    private static String getArg() {
        if (current >= args.length) {
            return "";
        }
        return args[current++];
    }

    private static void list() {
        String role;
        Enumeration roles;
        Enumeration users = database.getUsers();
        while (users.hasMoreElements()) {
            FileRealmUser user = (FileRealmUser)users.nextElement();
            System.out.print("User '" + user.getName() + "', password='" + HexUtils.convert(user.getPassword()) + "'");
            Enumeration groups = user.getGroups();
            while (groups.hasMoreElements()) {
                FileRealmGroup group = (FileRealmGroup)groups.nextElement();
                System.out.print(", group='" + group.getName() + "'");
            }
            roles = user.getRoles();
            while (roles.hasMoreElements()) {
                role = (String)roles.nextElement();
                System.out.print(", role='" + role + "'");
            }
            System.out.println();
        }
        Enumeration groups = database.getGroups();
        while (groups.hasMoreElements()) {
            FileRealmGroup group = (FileRealmGroup)groups.nextElement();
            System.out.print("Group '" + group.getName() + "'");
            roles = group.getRoles();
            while (roles.hasMoreElements()) {
                role = (String)roles.nextElement();
                System.out.print(", role='" + role + "'");
            }
            System.out.println();
        }
        System.out.println("===============================================");
    }

    public static void main(String[] arguments) {
        args = arguments;
        FileRealmTool.open();
        FileRealmTool.process();
        FileRealmTool.close();
    }

    private static void open() {
        filename = FileRealmTool.getArg();
        if (filename.length() < 1) {
            System.err.println(sm.getString("tool.open.missing"));
            System.exit(1);
        }
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException e10) {
            System.err.println(String.valueOf(sm.getString("tool.open.open", filename)) + ": " + e10);
            e10.printStackTrace();
            System.exit(1);
        }
        try {
            database = new FileRealmDatabase(stream);
        }
        catch (IOException e11) {
            System.err.println(String.valueOf(sm.getString("tool.open.read", filename)) + ": " + e11);
            e11.printStackTrace();
            System.exit(1);
        }
        catch (SAXParseException e12) {
            System.err.println(String.valueOf(sm.getString("tool.open.parse", filename)) + ": " + e12);
            e12.printStackTrace();
            System.exit(1);
        }
        catch (SAXException e13) {
            System.err.println(String.valueOf(sm.getString("tool.open.process", filename)) + ": " + e13);
            e13.printStackTrace();
            System.exit(1);
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
    }

    private static void process() {
        String command;
        while ((command = FileRealmTool.getArg()).length() >= 1) {
            if (command.equals("-addGroup")) {
                FileRealmTool.addGroup();
                continue;
            }
            if (command.equals("-addMember")) {
                FileRealmTool.addMember();
                continue;
            }
            if (command.equals("-addRole")) {
                FileRealmTool.addRole();
                continue;
            }
            if (command.equals("-addUser")) {
                FileRealmTool.addUser();
                continue;
            }
            if (command.equals("-dropGroup")) {
                FileRealmTool.dropGroup();
                continue;
            }
            if (command.equals("-dropMember")) {
                FileRealmTool.dropMember();
                continue;
            }
            if (command.equals("-dropRole")) {
                FileRealmTool.dropRole();
                continue;
            }
            if (command.equals("-dropUser")) {
                FileRealmTool.dropUser();
                continue;
            }
            if (command.equals("-list")) {
                FileRealmTool.list();
                continue;
            }
            System.err.println(sm.getString("tool.process.command", command));
            modified = false;
            System.exit(2);
        }
    }
}

