/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.shell;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.server.HttpServer;
import org.apache.tomcat.server.HttpServerException;
import org.apache.tomcat.shell.AdminImpl;
import org.apache.tomcat.shell.Constants;
import org.apache.tomcat.shell.StartupException;
import org.apache.tomcat.shell.deployment.Config;
import org.apache.tomcat.shell.deployment.ConnectorConfig;
import org.apache.tomcat.shell.deployment.ContextConfig;
import org.apache.tomcat.shell.deployment.ContextManagerConfig;
import org.apache.tomcat.shell.deployment.ServerConfig;
import org.apache.tomcat.util.StringManager;

public class Startup {
    protected StringManager sm = StringManager.getManager("org.apache.tomcat.shell");

    static {
        String warPackage = "org.apache.tomcat.protocol";
        String protocolKey = "java.protocol.handler.pkgs";
        String protocolHandlers = System.getProperties().getProperty(protocolKey);
        ((Hashtable)System.getProperties()).put(protocolKey, protocolHandlers == null ? warPackage : String.valueOf(protocolHandlers) + "|" + warPackage);
    }

    public void checkClassDependencies() {
        int i2 = 0;
        while (i2 < Constants.REQUIRED_CLASSES.length) {
            String clazz = Constants.REQUIRED_CLASSES[i2];
            try {
                Class.forName(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String msg = this.sm.getString("startup.classes.cnfe", clazz);
                System.out.println("warning: " + msg);
            }
            ++i2;
        }
    }

    public void configure(String[] args) throws StartupException {
        Config config = this.getConfig(args);
        if (config == null) {
            return;
        }
        this.checkClassDependencies();
        ServerConfig serverConfig = config.getServerConfig();
        Registry registry = this.createRegistry(serverConfig.getAdminPort());
        Enumeration contextManagers = serverConfig.getContextManagers();
        while (contextManagers.hasMoreElements()) {
            String msg;
            ContextManagerConfig contextManagerConfig = (ContextManagerConfig)contextManagers.nextElement();
            ContextManager contextManager = new ContextManager();
            Enumeration contexts = contextManagerConfig.getContextConfigs();
            while (contexts.hasMoreElements()) {
                ContextConfig contextConfig = (ContextConfig)contexts.nextElement();
                Context context = contextManager.addContext(contextConfig.getPath(), contextConfig.getDocumentBase());
                String contextWorkDirPath = this.getContextWorkDirPath(serverConfig, contextManagerConfig, contextConfig.getPath());
                context.setSessionTimeOut(contextConfig.getDefaultSessionTimeOut());
                context.setInvokerEnabled(contextConfig.isInvokerEnabled());
                context.setIsWARExpanded(contextConfig.isWARExpanded());
                context.setIsWARValidated(contextConfig.isWARValidated());
                context.setWorkDir(contextWorkDirPath, contextConfig.isWorkDirPersistent());
                context.setIsWARValidated(contextConfig.isWARValidated());
                if (!contextConfig.getPath().equals("")) continue;
                contextManager.setDefaultContext(context);
                contextManager.setServerInfo(contextManager.getDefaultContext().getEngineHeader());
            }
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(contextManagerConfig.getINet());
            }
            catch (UnknownHostException unknownHostException) {
                String msg2 = this.sm.getString("startup.setinit.uhe1", contextManagerConfig.getINet());
                System.out.println(msg2);
            }
            try {
                HttpServer server = new HttpServer(contextManagerConfig.getPort(), inetAddress, contextManagerConfig.getHostName(), contextManager);
                Enumeration conE = contextManagerConfig.getConnectorConfigs();
                while (conE.hasMoreElements()) {
                    ConnectorConfig conC = (ConnectorConfig)conE.nextElement();
                    String cn2 = conC.getClassName();
                    ServerConnector conn = null;
                    try {
                        Class<?> c10 = Class.forName(cn2);
                        conn = (ServerConnector)c10.newInstance();
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                    Enumeration props = conC.getParameterKeys();
                    while (props.hasMoreElements()) {
                        String k2 = (String)props.nextElement();
                        String v2 = (String)conC.getParameter(k2);
                        conn.setProperty(k2, v2);
                    }
                    server.addConnector(conn);
                }
                if (registry != null) {
                    registry.bind("service:" + server.getPort(), new AdminImpl(server));
                }
                server.start();
            }
            catch (HttpServerException hse) {
                msg = this.sm.getString("startup.server.hse");
                System.out.println(msg);
                hse.printStackTrace();
                throw new StartupException();
            }
            catch (RemoteException re) {
                msg = this.sm.getString("startup.server.re");
                System.out.println(msg);
                re.printStackTrace();
                throw new StartupException();
            }
            catch (AlreadyBoundException abe) {
                msg = this.sm.getString("startup.server.abe");
                System.out.println(msg);
                abe.printStackTrace();
                throw new StartupException();
            }
        }
    }

    protected void createLog(int port) {
        block7: {
            File f2 = null;
            try {
                f2 = new File("serverlog.txt");
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(this.sm.getString("startup.log.npe", "server.xml"));
            }
            if (f2 == null) break block7;
            try {
                if (f2.exists() && f2.isFile()) {
                    f2.delete();
                }
            }
            catch (SecurityException securityException) {
                System.out.println(this.sm.getString("startup.log.se", "server.xml"));
            }
            try {
                BufferedWriter bw2 = new BufferedWriter(new FileWriter(f2));
                bw2.write("admin.port:" + port);
                bw2.newLine();
                bw2.close();
            }
            catch (IOException iOException) {
                System.out.println(this.sm.getString("startup.log.ioe", "server.xml"));
            }
        }
    }

    protected Registry createRegistry(int port) throws StartupException {
        String msg;
        Registry registry = null;
        int numberAttempts = 0;
        if (port == 0) {
            return null;
        }
        if (port < 0) {
            port = this.newPort();
        }
        while (true) {
            msg = null;
            try {
                registry = LocateRegistry.createRegistry(port);
                this.createLog(port);
            }
            catch (Exception exception) {
                msg = this.sm.getString("startup.registry.e");
            }
            if (registry != null || numberAttempts++ >= 5) break;
            port = this.newPort();
        }
        if (registry == null) {
            throw new StartupException(msg);
        }
        return registry;
    }

    private Config getConfig(String[] args) throws StartupException {
        Config config = new Config(args);
        System.out.println(this.sm.getString("startup.banner"));
        if (config.isArg("help")) {
            System.out.println(this.sm.getString("startup.help"));
            System.out.println();
            return null;
        }
        String configFile = "server.xml";
        if (config.isArg("config")) {
            configFile = config.getArg("config");
        }
        config.loadConfig(configFile);
        return config;
    }

    private String getContextWorkDirPath(ServerConfig serverConfig, ContextManagerConfig contextManagerConfig, String path) {
        String s2 = "";
        String baseDir = serverConfig.getWorkDir();
        String hostName = contextManagerConfig.getHostName();
        String iNet = contextManagerConfig.getINet();
        int port = contextManagerConfig.getPort();
        if (hostName.trim().length() > 0) {
            s2 = String.valueOf(s2) + hostName;
        } else if (iNet.trim().length() > 0) {
            s2 = String.valueOf(s2) + iNet;
        }
        if (s2.length() != 0) {
            s2 = String.valueOf(s2) + ":";
        }
        if (port > -1) {
            s2 = String.valueOf(s2) + Integer.toString(port);
        }
        return String.valueOf(baseDir) + File.separator + URLEncoder.encode(String.valueOf(s2) + path);
    }

    public static void main(String[] args) {
        try {
            Startup start = new Startup();
            start.configure(args);
        }
        catch (StartupException startupException) {
            System.exit(1);
        }
    }

    protected int newPort() {
        Random r2 = new Random();
        double mul = r2.nextDouble();
        int min = 2048;
        int max = 8192;
        return (int)Math.round((double)min + mul * (double)(max - min));
    }
}

