/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import com.sun.xml.parser.Parser;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.XMLTree;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParser {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    private XmlDocument doc = null;
    private static final boolean DefaultCheckType = false;
    private static final String DefaultContentType = "text/html;charset=utf-8";
    private static final String DefaultScheme = "file";
    private static final boolean DefaultXMLValidate = true;
    private static final int PCDataType = 3;

    private void addAttributes(XMLTree xmlElement, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                Node attribute = attributes.item(i2);
                xmlElement.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
                ++i2;
            }
        }
    }

    private void addElements(XMLTree xmlElement, Node node) {
        NodeList childNodes = node.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            XMLTree childXMLTree = new XMLTree();
            Node childNode = childNodes.item(i2);
            childXMLTree.setName(childNode.getNodeName());
            this.addAttributes(childXMLTree, childNode);
            if (childNode.getNodeType() != 3) {
                this.addElements(childXMLTree, childNode);
                xmlElement.addElement(childXMLTree);
            } else {
                xmlElement.setValue(childNode.getNodeValue());
            }
            ++i2;
        }
    }

    public void clear() {
        this.doc = null;
    }

    public XmlDocument getXmlDocument() {
        return this.doc;
    }

    private XMLTree parse(InputSource is) throws IOException, SAXParseException, SAXException {
        return this.parse(is, true);
    }

    private XMLTree parse(InputSource is, boolean validate) throws IOException, SAXParseException, SAXException {
        Parser parser = validate ? new ValidatingParser(true) : new Parser();
        Resolver resolver = new Resolver();
        XmlDocumentBuilder builder = new XmlDocumentBuilder();
        URL serverURL = this.getClass().getResource("/org/apache/tomcat/shell/deployment/server.dtd");
        URL webApplicationURL = this.getClass().getResource("/org/apache/tomcat/deployment/web.dtd");
        resolver.registerCatalogEntry("-//Sun Microsystems, Inc.//DTD Servlet Server 1.0//EN", serverURL.toString());
        resolver.registerCatalogEntry("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", webApplicationURL.toString());
        try {
            parser.setEntityResolver(resolver);
            builder.setDisableNamespaces(true);
            builder.setParser(parser);
            parser.parse(is);
            this.doc = builder.getDocument();
        }
        catch (Exception e10) {
            String systemId = "";
            int lineNumber = -1;
            String message = "";
            String publicId = "";
            int columnNumber = -1;
            if (e10 instanceof SAXParseException) {
                systemId = ((SAXParseException)e10).getSystemId();
                lineNumber = ((SAXParseException)e10).getLineNumber();
                message = ((SAXParseException)e10).getMessage();
                publicId = ((SAXParseException)e10).getPublicId();
                columnNumber = ((SAXParseException)e10).getColumnNumber();
            }
            String msg = String.valueOf(this.sm.getString("xml.parse")) + ": " + systemId + " : " + lineNumber + "\n  msg : " + message;
            throw new SAXParseException(msg, publicId, systemId, lineNumber, columnNumber);
        }
        XMLTree xmlElement = new XMLTree();
        Element element = this.doc.getDocumentElement();
        xmlElement.setName(element.getTagName());
        this.addAttributes(xmlElement, element);
        this.addElements(xmlElement, element);
        return xmlElement;
    }

    public XMLTree process(InputStream is) throws IOException, SAXParseException, SAXException {
        return this.process(is, false, DefaultContentType, DefaultScheme);
    }

    public XMLTree process(InputStream is, boolean checkType) throws IOException, SAXParseException, SAXException {
        return this.process(is, checkType, DefaultContentType, DefaultScheme);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType) throws IOException, SAXParseException, SAXException {
        return this.process(is, checkType, contentType, DefaultScheme);
    }

    public XMLTree process(InputStream is, boolean checkType, String contentType, String scheme) throws IOException, SAXParseException, SAXException {
        return this.parse(Resolver.createInputSource(contentType, is, checkType, scheme), checkType);
    }

    public XMLTree process(URL uri) throws IOException, SAXParseException, SAXException {
        return this.process(uri, false);
    }

    public XMLTree process(URL uri, boolean checkType) throws IOException, SAXParseException, SAXException {
        return this.parse(new InputSource(uri.toString()), checkType);
    }

    public void write() throws IOException {
        this.write(null);
    }

    public void write(OutputStream os) throws IOException {
        if (os == null) {
            os = System.out;
        }
        this.doc.getDocumentElement().normalize();
        this.doc.write(os);
    }
}

