/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Vector;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.Type;

public class ArrayType
extends Type {
    private Type type;
    private int arrayDimension;
    private String brackets;
    private String bracketsSig;

    private ArrayType(ContextStack contextStack, Type type, int n2) {
        super(contextStack, 262144);
        this.type = type;
        this.arrayDimension = n2;
        this.brackets = "";
        this.bracketsSig = "";
        int n3 = 0;
        while (n3 < n2) {
            this.brackets = String.valueOf(this.brackets) + "[]";
            this.bracketsSig = String.valueOf(this.bracketsSig) + "[";
            ++n3;
        }
        String string = IDLNames.getArrayName(type, n2);
        String[] stringArray = IDLNames.getArrayModuleNames(type);
        this.setNames(type.getIdentifier(), stringArray, string);
        this.setRepositoryID();
    }

    protected boolean addTypes(int n2, HashSet hashSet, Vector vector) {
        boolean bl2 = super.addTypes(n2, hashSet, vector);
        if (bl2) {
            this.getElementType().addTypes(n2, hashSet, vector);
        }
        return bl2;
    }

    protected void destroy() {
        super.destroy();
        if (this.type != null) {
            this.type.destroy();
            this.type = null;
        }
        this.brackets = null;
        this.bracketsSig = null;
    }

    public static ArrayType forArray(sun.tools.java.Type type, ContextStack contextStack) {
        ArrayType arrayType = null;
        sun.tools.java.Type type2 = type;
        if (type2.getTypeCode() == 9) {
            while (type2.getTypeCode() == 9) {
                type2 = type2.getElementType();
            }
            Type type3 = Type.getType(type, contextStack);
            if (type3 != null) {
                if (!(type3 instanceof ArrayType)) {
                    return null;
                }
                return (ArrayType)type3;
            }
            Type type4 = CompoundType.makeType(type2, null, contextStack);
            if (type4 != null) {
                arrayType = new ArrayType(contextStack, type4, type.getArrayDimension());
                Type.putType(type, (Type)arrayType, contextStack);
                contextStack.push(arrayType);
                contextStack.pop(true);
            }
        }
        return arrayType;
    }

    public String getArrayBrackets() {
        return this.brackets;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    public Type getElementType() {
        return this.type;
    }

    public String getSignature() {
        return String.valueOf(this.bracketsSig) + this.type.getSignature();
    }

    public String getTypeDescription() {
        return "Array of " + this.type.getTypeDescription();
    }

    public String getTypeName(boolean bl2, boolean bl3, boolean bl4) {
        if (bl3) {
            return super.getTypeName(bl2, bl3, bl4);
        }
        return String.valueOf(super.getTypeName(bl2, bl3, bl4)) + this.brackets;
    }

    protected Class loadClass() {
        Class<?> clazz = null;
        Class clazz2 = this.type.getClassInstance();
        if (clazz2 != null) {
            clazz = Array.newInstance(clazz2, new int[this.arrayDimension]).getClass();
        }
        return clazz;
    }

    protected void swapInvalidTypes() {
        if (this.type.getStatus() != 1) {
            this.type = this.getValidType(this.type);
        }
    }

    public String toString() {
        return String.valueOf(this.getQualifiedName()) + this.brackets;
    }
}

