/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;
    private static ImageTypeSpecifier[] BISpecifier;

    private ImageTypeSpecifier() {
    }

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public ImageTypeSpecifier(RenderedImage renderedImage) {
        this.colorModel = renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return new Packed(colorSpace, n, n2, n3, n4, n5, bl);
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = bl ? 3 : 1;
        int[] nArray = new int[n];
        if (n2 == 0) {
            n3 = 8;
        } else if (n2 == 2 || n2 == 1) {
            n3 = 16;
        } else if (n2 == 3) {
            n3 = 32;
        } else {
            throw new IllegalArgumentException("dataType = " + n2);
        }
        int n5 = 0;
        while (n5 < n) {
            nArray[n5] = n3;
            ++n5;
        }
        return new ComponentColorModel(colorSpace, nArray, bl, bl2, n4, n2);
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
        return new Interleaved(colorSpace, nArray, n, bl, bl2);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        return new Banded(colorSpace, nArray, nArray2, n, bl, bl2);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl) {
        return new Grayscale(n, n2, bl, false, false);
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl, boolean bl2) {
        return new Grayscale(n, n2, bl, true, bl2);
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
        return new Indexed(byArray, byArray2, byArray3, byArray4, n, n2);
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n) {
        if (n >= 1 && n <= 13) {
            return BISpecifier[n];
        }
        if (n == 0) {
            throw new IllegalArgumentException("Cannot create from TYPE_CUSTOM!");
        }
        throw new IllegalArgumentException("Invalid BufferedImage type!");
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        int n;
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (renderedImage instanceof BufferedImage && (n = ((BufferedImage)renderedImage).getType()) != 0) {
            return BISpecifier[n];
        }
        return new ImageTypeSpecifier(renderedImage);
    }

    public int getBufferedImageType() {
        BufferedImage bufferedImage = this.createBufferedImage(1, 1);
        return bufferedImage.getType();
    }

    public int getNumComponents() {
        return this.colorModel.getNumComponents();
    }

    public int getNumBands() {
        return this.sampleModel.getNumBands();
    }

    public int getBitsPerBand(int n) {
        return -1;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public SampleModel getSampleModel(int n, int n2) {
        return this.sampleModel.createCompatibleSampleModel(n, n2);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        SampleModel sampleModel = this.getSampleModel(n, n2);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        return new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImageTypeSpecifier)) {
            return false;
        }
        ImageTypeSpecifier imageTypeSpecifier = (ImageTypeSpecifier)object;
        return this.colorModel.equals(imageTypeSpecifier.colorModel) && this.sampleModel.equals(imageTypeSpecifier.sampleModel);
    }

    static {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        BISpecifier = new ImageTypeSpecifier[14];
        ImageTypeSpecifier.BISpecifier[0] = null;
        ImageTypeSpecifier.BISpecifier[1] = ImageTypeSpecifier.createPacked(colorSpace, 0xFF0000, 65280, 255, 0, 3, false);
        ImageTypeSpecifier.BISpecifier[2] = ImageTypeSpecifier.createPacked(colorSpace, 0xFF0000, 65280, 255, -16777216, 3, false);
        ImageTypeSpecifier.BISpecifier[3] = ImageTypeSpecifier.createPacked(colorSpace, 0xFF0000, 65280, 255, -16777216, 3, true);
        ImageTypeSpecifier.BISpecifier[4] = ImageTypeSpecifier.createPacked(colorSpace, 255, 65280, 0xFF0000, 0, 3, false);
        int[] nArray = new int[]{2, 1, 0};
        ImageTypeSpecifier.BISpecifier[5] = ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, false, false);
        int[] nArray2 = new int[]{3, 2, 1, 0};
        ImageTypeSpecifier.BISpecifier[6] = ImageTypeSpecifier.createInterleaved(colorSpace, nArray2, 0, true, false);
        ImageTypeSpecifier.BISpecifier[7] = ImageTypeSpecifier.createInterleaved(colorSpace, nArray2, 0, true, true);
        ImageTypeSpecifier.BISpecifier[8] = ImageTypeSpecifier.createPacked(colorSpace, 63488, 2016, 31, 0, 1, false);
        ImageTypeSpecifier.BISpecifier[9] = ImageTypeSpecifier.createPacked(colorSpace, 31744, 992, 31, 0, 1, false);
        ImageTypeSpecifier.BISpecifier[10] = ImageTypeSpecifier.createGrayscale(8, 0, false);
        ImageTypeSpecifier.BISpecifier[11] = ImageTypeSpecifier.createGrayscale(16, 1, false);
        ImageTypeSpecifier.BISpecifier[12] = ImageTypeSpecifier.createGrayscale(1, 0, false);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 13);
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        indexColorModel.getAlphas(byArray4);
        ImageTypeSpecifier.BISpecifier[13] = ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, 8, 0);
    }

    static class Indexed
    extends ImageTypeSpecifier {
        byte[] redLUT;
        byte[] greenLUT;
        byte[] blueLUT;
        byte[] alphaLUT = null;
        int bits;
        int dataType;

        public Indexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
            this.redLUT = (byte[])byArray.clone();
            this.greenLUT = (byte[])byArray2.clone();
            this.blueLUT = (byte[])byArray3.clone();
            if (byArray4 != null) {
                this.alphaLUT = (byte[])byArray4.clone();
            }
            this.bits = n;
            this.dataType = n2;
            this.colorModel = byArray4 == null ? new IndexColorModel(n, byArray.length, byArray, byArray2, byArray3) : new IndexColorModel(n, byArray.length, byArray, byArray2, byArray3, byArray4);
            if (n == 8 && n2 == 0 || n == 16 && (n2 == 2 || n2 == 1)) {
                int[] nArray = new int[]{0};
                this.sampleModel = new PixelInterleavedSampleModel(n2, 1, 1, 1, 1, nArray);
            } else {
                this.sampleModel = new MultiPixelPackedSampleModel(n2, 1, 1, n);
            }
        }
    }

    static class Grayscale
    extends ImageTypeSpecifier {
        int bits;
        int dataType;
        boolean isSigned;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Grayscale(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.bits = n;
            this.dataType = n2;
            this.isSigned = bl;
            this.hasAlpha = bl2;
            this.isAlphaPremultiplied = bl3;
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            if (n == 8 && n2 == 0 || n == 16 && (n2 == 2 || n2 == 1)) {
                int n3 = bl2 ? 2 : 1;
                int n4 = bl2 ? 3 : 1;
                int[] nArray = new int[n3];
                nArray[0] = n;
                if (n3 == 2) {
                    nArray[1] = n;
                }
                this.colorModel = new ComponentColorModel(colorSpace, nArray, bl2, bl3, n4, n2);
                int[] nArray2 = new int[n3];
                nArray2[0] = 0;
                if (n3 == 2) {
                    nArray2[1] = 1;
                }
                int n5 = 1;
                int n6 = 1;
                this.sampleModel = new PixelInterleavedSampleModel(n2, n5, n6, n3, n5 * n3, nArray2);
            } else {
                int n7 = 1 << n;
                byte[] byArray = new byte[n7];
                int n8 = 0;
                while (n8 < n7) {
                    byArray[n8] = (byte)(n8 * 255 / (n7 - 1));
                    ++n8;
                }
                this.colorModel = new IndexColorModel(n, n7, byArray, byArray, byArray);
                this.sampleModel = new MultiPixelPackedSampleModel(n2, 1, 1, n);
            }
        }
    }

    static class Banded
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bankIndices;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Banded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
            if (nArray == null) {
                throw new IllegalArgumentException();
            }
            if (nArray2 == null) {
                throw new IllegalArgumentException();
            }
            if (nArray.length != nArray2.length) {
                throw new IllegalArgumentException();
            }
            this.colorSpace = colorSpace;
            this.bankIndices = (int[])nArray.clone();
            this.bandOffsets = (int[])nArray2.clone();
            this.dataType = n;
            this.hasAlpha = bl;
            this.isAlphaPremultiplied = bl2;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, nArray.length, n, bl, bl2);
            int n2 = 1;
            int n3 = 1;
            this.sampleModel = new BandedSampleModel(n, n2, n3, n2, nArray, nArray2);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Banded)) {
                return false;
            }
            Banded banded = (Banded)object;
            if (!this.colorSpace.equals(banded.colorSpace) || this.dataType != banded.dataType || this.hasAlpha != banded.hasAlpha || this.isAlphaPremultiplied != banded.isAlphaPremultiplied || this.bankIndices.length != banded.bankIndices.length || this.bandOffsets.length != banded.bandOffsets.length) {
                return false;
            }
            int n = 0;
            while (n < this.bankIndices.length) {
                if (this.bankIndices[n] != banded.bankIndices[n]) {
                    return false;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.bandOffsets.length) {
                if (this.bandOffsets[n2] != banded.bandOffsets[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    static class Interleaved
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Interleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
            this.colorSpace = colorSpace;
            this.bandOffsets = (int[])nArray.clone();
            this.dataType = n;
            this.hasAlpha = bl;
            this.isAlphaPremultiplied = bl2;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, nArray.length, n, bl, bl2);
            int n2 = 1;
            int n3 = 1;
            this.sampleModel = new PixelInterleavedSampleModel(n, n2, n3, nArray.length, n2 * nArray.length, nArray);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Interleaved)) {
                return false;
            }
            Interleaved interleaved = (Interleaved)object;
            if (!this.colorSpace.equals(interleaved.colorSpace) || this.dataType != interleaved.dataType || this.hasAlpha != interleaved.hasAlpha || this.isAlphaPremultiplied != interleaved.isAlphaPremultiplied || this.bandOffsets.length != interleaved.bandOffsets.length) {
                return false;
            }
            int n = 0;
            while (n < this.bandOffsets.length) {
                if (this.bandOffsets[n] != interleaved.bandOffsets[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    static class Packed
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int redMask;
        int greenMask;
        int blueMask;
        int alphaMask;
        int transferType;
        boolean isAlphaPremultiplied;

        public Packed(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.colorSpace = colorSpace;
            this.redMask = n;
            this.greenMask = n2;
            this.blueMask = n3;
            this.alphaMask = n4;
            this.transferType = n5;
            this.isAlphaPremultiplied = bl;
            int n6 = 32;
            this.colorModel = new DirectColorModel(colorSpace, n6, n, n2, n3, n4, bl, n5);
            this.sampleModel = this.colorModel.createCompatibleSampleModel(1, 1);
        }
    }
}

