/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.Field;

public abstract class ResultSet {
    protected Vector Rows;
    protected Field[] Fields;
    protected int currentRow = -1;
    protected byte[][] This_Row;
    protected Connection Conn;
    protected SQLWarning Warnings;
    protected boolean wasNullFlag = false;
    protected boolean reallyResult = false;
    protected long updateID = -1L;
    protected long updateCount;
    private SimpleDateFormat _TSDF;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] radixTenTenths = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] radixTenUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public boolean next() throws SQLException {
        if (!this.reallyResult()) {
            throw new SQLException("ResultSet is from UPDATE. No Data", "S1000");
        }
        if (this.currentRow + 1 >= this.Rows.size()) {
            return false;
        }
        this.clearWarnings();
        ++this.currentRow;
        this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
        return true;
    }

    public boolean prev() throws SQLException {
        if (this.currentRow - 1 >= 0) {
            --this.currentRow;
            this.This_Row = (byte[][])this.Rows.elementAt(this.currentRow);
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.Rows != null) {
            this.Rows.removeAllElements();
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int n) throws SQLException {
        this.checkRowPos();
        if (this.Fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        if (this.Conn != null && this.Conn.useUnicode()) {
            try {
                String string = this.Conn.getEncoding();
                if (string == null) {
                    return new String(this.This_Row[n - 1]);
                }
                return new String(this.This_Row[n - 1], this.Conn.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("Unsupported character encoding '" + this.Conn.getEncoding() + "'.", "0S100");
            }
        }
        return new String(this.This_Row[n - 1]);
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getString(n);
        if (string != null && string.length() > 0) {
            char c = string.toLowerCase().charAt(0);
            return c == 't' || c == 'y' || c == '1';
        }
        return false;
    }

    public byte getByte(int n) throws SQLException {
        this.checkRowPos();
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0;
        }
        Field field = this.Fields[n - 1];
        switch (field.getMysqlType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                try {
                    String string = this.getString(n);
                    if (string.indexOf(".") != -1) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    return Byte.parseByte(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Value '" + this.getString(n) + "' is out of range [-127,127]", "S1009");
                }
            }
        }
        return this.This_Row[n - 1][0];
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getLong(n);
    }

    public int getInt(int n) throws SQLException {
        return (int)this.getLong(n);
    }

    public long getLong(int n) throws SQLException {
        this.checkRowPos();
        if (this.Fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0L;
        }
        try {
            return this.getLong(this.This_Row[n - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad format for number '" + new String(this.This_Row[n - 1]) + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
        }
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public double getDouble(int n) throws SQLException {
        this.checkRowPos();
        if (this.Fields == null) {
            throw new SQLException("Query generated no fields for ResultSet", "S1002");
        }
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0.0;
        }
        try {
            return ResultSet.getDouble(this.This_Row[n - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad format for number '" + new String(this.This_Row[n - 1]) + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string != null) {
            BigDecimal bigDecimal;
            if (string.length() == 0) {
                BigDecimal bigDecimal2 = new BigDecimal(0.0);
                return bigDecimal2.setScale(n2);
            }
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Bad format for BigDecimal '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
            }
            try {
                return bigDecimal.setScale(n2);
            }
            catch (ArithmeticException arithmeticException) {
                throw new SQLException("Bad format for BigDecimal '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
            }
        }
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkRowPos();
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column Index out of range ( " + n + " > " + this.Fields.length + ").", "S1002");
        }
        try {
            this.wasNullFlag = this.This_Row[n - 1] == null;
        }
        catch (NullPointerException nullPointerException) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        return this.This_Row[n - 1];
    }

    public Date getDate(int n) throws SQLException {
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        String string = "";
        try {
            string = this.getString(n);
            if (string == null) {
                return null;
            }
            if (this.Fields[n - 1].getMysqlType() == 7) {
                switch (string.length()) {
                    case 8: 
                    case 14: {
                        n2 = new Integer(string.substring(0, 4));
                        n3 = new Integer(string.substring(4, 6));
                        n4 = new Integer(string.substring(6, 8));
                        return new Date(n2 - 1900, n3 - 1, n4);
                    }
                    case 6: 
                    case 10: 
                    case 12: {
                        n2 = new Integer(string.substring(0, 2));
                        n3 = new Integer(string.substring(2, 4));
                        n4 = new Integer(string.substring(4, 6));
                        return new Date(n2, n3 - 1, n4);
                    }
                    case 4: {
                        n2 = new Integer(string.substring(0, 2));
                        n3 = new Integer(string.substring(2, 4));
                        return new Date(n2, n3 - 1, 1);
                    }
                    case 2: {
                        n2 = new Integer(string.substring(0, 2));
                        return new Date(n2, 0, 1);
                    }
                }
                throw new SQLException("Bad format for Date '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
            }
            if (string.length() < 10) {
                throw new SQLException("Bad format for Date '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
            }
            n2 = new Integer(string.substring(0, 4));
            n3 = new Integer(string.substring(5, 7));
            n4 = new Integer(string.substring(8, 10));
            return new Date(n2 - 1900, n3 - 1, n4);
        }
        catch (Exception exception) {
            throw new SQLException("Cannot convert value '" + string + "' from column " + n + "(" + string + " ) to DATE.", "S1009");
        }
    }

    public Time getTime(int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            String string = this.getString(n);
            if (string == null) {
                return null;
            }
            Field field = this.Fields[n - 1];
            if (field.getMysqlType() == 7) {
                int n5 = string.length();
                switch (n5) {
                    case 12: 
                    case 14: {
                        n2 = Integer.parseInt(string.substring(n5 - 6, n5 - 4));
                        n3 = Integer.parseInt(string.substring(n5 - 4, n5 - 2));
                        n4 = Integer.parseInt(string.substring(n5 - 2, n5));
                        break;
                    }
                    case 10: {
                        n2 = Integer.parseInt(string.substring(6, 8));
                        n3 = Integer.parseInt(string.substring(8, 10));
                        n4 = 0;
                        break;
                    }
                    default: {
                        throw new SQLException("Timestamp too small to convert to Time value in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
                    }
                }
                SQLWarning sQLWarning = new SQLWarning("Precision lost converting TIMESTAMP to Time with getTime() on column " + n + "(" + this.Fields[n - 1] + ").");
                if (this.Warnings == null) {
                    this.Warnings = sQLWarning;
                } else {
                    this.Warnings.setNextWarning(sQLWarning);
                }
            } else if (field.getMysqlType() == 12) {
                n2 = Integer.parseInt(string.substring(11, 13));
                n3 = Integer.parseInt(string.substring(14, 16));
                n4 = Integer.parseInt(string.substring(17, 19));
                SQLWarning sQLWarning = new SQLWarning("Precision lost converting DATETIME to Time with getTime() on column " + n + "(" + this.Fields[n - 1] + ").");
                if (this.Warnings == null) {
                    this.Warnings = sQLWarning;
                } else {
                    this.Warnings.setNextWarning(sQLWarning);
                }
            } else {
                if (string.length() != 5 && string.length() != 8) {
                    throw new SQLException("Bad format for Time '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
                }
                n2 = Integer.parseInt(string.substring(0, 2));
                n3 = Integer.parseInt(string.substring(3, 5));
                n4 = string.length() == 5 ? 0 : Integer.parseInt(string.substring(6));
            }
            return new Time(n2, n3, n4);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getClass().getName(), "S1009");
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            switch (string.length()) {
                case 19: {
                    ResultSet resultSet = this;
                    synchronized (resultSet) {
                        if (this._TSDF == null) {
                            this._TSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        }
                        try {
                            java.util.Date date = this._TSDF.parse(string);
                            Timestamp timestamp = new Timestamp(date.getTime());
                            Object var5_23 = null;
                            return timestamp;
                        }
                        catch (ParseException parseException) {
                            throw new SQLException("Bad format for Timestamp '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
                        }
                    }
                }
                case 14: {
                    Integer n2 = new Integer(string.substring(0, 4));
                    Integer n3 = new Integer(string.substring(4, 6));
                    Integer n4 = new Integer(string.substring(6, 8));
                    Integer n5 = new Integer(string.substring(8, 10));
                    Integer n6 = new Integer(string.substring(10, 12));
                    Integer n7 = new Integer(string.substring(12, 14));
                    return new Timestamp(n2 - 1900, n3 - 1, n4, n5, n6, n7, 0);
                }
                case 12: {
                    Integer n8 = new Integer(string.substring(0, 2));
                    Integer n9 = new Integer(string.substring(2, 4));
                    Integer n10 = new Integer(string.substring(4, 6));
                    Integer n11 = new Integer(string.substring(6, 8));
                    Integer n12 = new Integer(string.substring(8, 10));
                    Integer n13 = new Integer(string.substring(10, 12));
                    return new Timestamp(n8, n9 - 1, n10, n11, n12, n13, 0);
                }
                case 10: {
                    Integer n14 = new Integer(string.substring(0, 2));
                    Integer n15 = new Integer(string.substring(2, 4));
                    Integer n16 = new Integer(string.substring(4, 6));
                    Integer n17 = new Integer(string.substring(6, 8));
                    Integer n18 = new Integer(string.substring(8, 10));
                    return new Timestamp(n14, n15 - 1, n16, n17, n18, 0, 0);
                }
                case 8: {
                    Integer n19 = new Integer(string.substring(0, 4));
                    Integer n20 = new Integer(string.substring(4, 6));
                    Integer n21 = new Integer(string.substring(6, 8));
                    return new Timestamp(n19 - 1900, n20 - 1, n21, 0, 0, 0, 0);
                }
                case 6: {
                    Integer n22 = new Integer(string.substring(0, 2));
                    Integer n23 = new Integer(string.substring(2, 4));
                    Integer n24 = new Integer(string.substring(4, 6));
                    return new Timestamp(n22, n23 - 1, n24, 0, 0, 0, 0);
                }
                case 4: {
                    Integer n25 = new Integer(string.substring(0, 2));
                    Integer n26 = new Integer(string.substring(2, 4));
                    return new Timestamp(n25, n26 - 1, 1, 0, 0, 0, 0);
                }
                case 2: {
                    Integer n27 = new Integer(string.substring(0, 2));
                    return new Timestamp(n27, 0, 1, 0, 0, 0, 0);
                }
            }
            throw new SQLException("Bad format for Timestamp '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
        }
        catch (Exception exception) {
            throw new SQLException(exception.getClass().getName(), "S1009");
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkRowPos();
        byte[] byArray = this.getBytes(n);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.Warnings;
    }

    public void clearWarnings() throws SQLException {
        this.Warnings = null;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned Update not supported.", "S1C00");
    }

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public Object getObject(int n) throws SQLException {
        this.checkRowPos();
        if (n < 1 || n > this.Fields.length) {
            throw new SQLException("Column index out of range (" + n + " > " + this.Fields.length + ").", "S1002");
        }
        Field field = this.Fields[n - 1];
        if (this.This_Row[n - 1] == null) {
            this.wasNullFlag = true;
            return null;
        }
        this.wasNullFlag = false;
        switch (field.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 2: 
            case 3: {
                String string = this.getString(n);
                if (string != null) {
                    BigDecimal bigDecimal;
                    if (string.length() == 0) {
                        BigDecimal bigDecimal2 = new BigDecimal(0.0);
                        return bigDecimal2;
                    }
                    try {
                        bigDecimal = new BigDecimal(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SQLException("Bad format for BigDecimal '" + string + "' in column " + n + "(" + this.Fields[n - 1] + ").", "S1009");
                    }
                    return bigDecimal;
                }
                return null;
            }
            case 6: 
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case -1: 
            case 1: 
            case 12: {
                if (field.isBinary()) {
                    return this.getBytes(n);
                }
                return this.getString(n);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!field.isBlob()) {
                    return this.getString(n);
                }
                if (!field.isBinary()) {
                    return this.getString(n);
                }
                return this.getBytes(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
        }
        return this.getString(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        while (n < this.Fields.length) {
            if (this.Fields[n].Name.equalsIgnoreCase(string)) {
                return n + 1;
            }
            String string2 = String.valueOf(this.Fields[n].TableName) + "." + this.Fields[n].Name;
            if (string2.equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new SQLException("Column '" + string + "' not found.", "S0022");
    }

    public ResultSet(Field[] fieldArray, Vector vector, Connection connection) {
        this(fieldArray, vector);
        this.setConnection(connection);
    }

    public ResultSet(Field[] fieldArray, Vector vector) {
        this.currentRow = -1;
        this.Fields = fieldArray;
        this.Rows = vector;
        this.updateCount = this.Rows.size();
        this.reallyResult = true;
        if (this.Rows.size() > 0) {
            this.This_Row = (byte[][])this.Rows.elementAt(0);
            if (this.updateCount == 1L && this.This_Row == null) {
                this.currentRow = -1;
                this.Rows.removeAllElements();
                this.updateCount = -1L;
                return;
            }
        } else {
            this.This_Row = null;
        }
    }

    public ResultSet(long l, long l2) {
        this.updateCount = l;
        this.updateID = l2;
        this.reallyResult = false;
        this.Fields = new Field[0];
    }

    public void setConnection(Connection connection) {
        this.Conn = connection;
    }

    boolean reallyResult() {
        return this.reallyResult;
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    long getUpdateID() {
        return this.updateID;
    }

    private synchronized void checkRowPos() throws SQLException {
        if (this.currentRow < 0) {
            throw new SQLException("Before start of result set");
        }
        if (this.currentRow == this.Rows.size()) {
            throw new SQLException("After end of result set");
        }
    }

    protected static double getDouble(byte[] byArray) throws NumberFormatException {
        int n;
        double d = 0.0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = byArray.length;
        if (n5 > 0 && (char)byArray[n4] == '-') {
            n3 = -1;
            ++n4;
        }
        while (n4 < n5) {
            n = byArray[n4];
            if (n < 48 || n > 57) break;
            d = 10.0 * d + (double)n - 48.0;
            ++n4;
        }
        if (n4 == n5) {
            return (double)n3 * d;
        }
        if ((char)byArray[n4] == '.') {
            ++n4;
            while (n4 < n5) {
                n = (char)byArray[n4];
                if (n < 48 || n > 57) break;
                d = 10.0 * d + (double)n - 48.0;
                --n2;
                ++n4;
            }
        }
        if (n4 < n5 && ((char)byArray[n4] == 'e' || (char)byArray[n4] == 'E')) {
            n = 1;
            if (++n4 < n5 && (char)byArray[n4] == '-') {
                ++n4;
                n = -1;
            }
            if (n4 < n5 && (char)byArray[n4] == '+') {
                ++n4;
            }
            int n6 = 0;
            while (n4 < n5) {
                char c = (char)byArray[n4];
                if (c < '0' || c > '9') break;
                n6 = 10 * n6 + c - 48;
                ++n4;
            }
            n2 += n * n6;
        }
        if (n4 < n5) {
            throw new NumberFormatException("Bad format for number: " + new String(byArray));
        }
        if (n2 >= 0) {
            return (double)n3 * d * Math.pow(10.0, n2);
        }
        return (double)n3 * d / Math.pow(10.0, -n2);
    }

    public long getLong(byte[] byArray) throws NumberFormatException {
        long l = 0L;
        boolean bl = false;
        int n = 0;
        int n2 = byArray.length;
        if (n2 > 0) {
            int n3;
            long l2;
            if ((char)byArray[0] == '-') {
                bl = true;
                l2 = Long.MIN_VALUE;
                ++n;
            } else {
                l2 = -9223372036854775807L;
            }
            long l3 = l2 / 10L;
            if (n < n2) {
                if ((n3 = Character.digit((char)byArray[n++], 10)) < 0) {
                    throw new NumberFormatException(new String(byArray));
                }
                l = -n3;
            }
            while (n < n2) {
                if ((n3 = Character.digit((char)byArray[n++], 10)) < 0) {
                    throw new NumberFormatException(new String(byArray));
                }
                if (l < l3) {
                    throw new NumberFormatException(new String(byArray));
                }
                if ((l *= 10L) < l2 + (long)n3) {
                    throw new NumberFormatException(new String(byArray));
                }
                l -= (long)n3;
            }
        } else {
            throw new NumberFormatException(new String(byArray));
        }
        if (bl) {
            if (n > 1) {
                return l;
            }
            throw new NumberFormatException(new String(byArray));
        }
        return -l;
    }
}

