/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.sql.RowSet;
import sun.jdbc.rowset.WebRowSet;
import sun.jdbc.rowset.XmlWriter;

public class XmlWriterImpl
implements XmlWriter {
    private Writer writer;
    private Stack stack;

    private void beginSection(String string) throws IOException {
        this.setTag(string);
        this.writeIndent(this.stack.size());
        this.writer.write("<" + string + ">\n");
    }

    private void beginTag(String string) throws IOException {
        this.setTag(string);
        this.writeIndent(this.stack.size());
        this.writer.write("<" + string + ">");
    }

    private void emptyTag(String string) throws IOException {
        this.writer.write("<" + string + "/>");
    }

    private void endSection() throws IOException {
        this.writeIndent(this.stack.size());
        String string = this.getTag();
        this.writer.write("</" + string + ">\n");
        this.writer.flush();
    }

    private void endSection(String string) throws IOException {
        this.writeIndent(this.stack.size());
        String string2 = this.getTag();
        if (string.equals(string2)) {
            this.writer.write("</" + string2 + ">\n");
        }
        this.writer.flush();
    }

    private void endTag(String string) throws IOException {
        String string2 = this.getTag();
        if (string.equals(string2)) {
            this.writer.write("</" + string2 + ">\n");
        }
        this.writer.flush();
    }

    private String getTag() {
        return (String)this.stack.pop();
    }

    private void propBoolean(String string, boolean bl) throws IOException {
        this.beginTag(string);
        this.writeBoolean(bl);
        this.endTag(string);
    }

    private void propInteger(String string, int n) throws IOException {
        this.beginTag(string);
        this.writeInteger(n);
        this.endTag(string);
    }

    private void propString(String string, String string2) throws IOException {
        this.beginTag(string);
        this.writeString(string2);
        this.endTag(string);
    }

    private void setTag(String string) {
        this.stack.push(string);
    }

    private void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal != null) {
            this.writer.write(bigDecimal.toString());
        } else {
            this.emptyTag("null");
        }
    }

    private void writeBoolean(boolean bl) throws IOException {
        this.writer.write(new Boolean(bl).toString());
    }

    private void writeData(WebRowSet webRowSet) throws IOException {
        try {
            ResultSetMetaData resultSetMetaData = webRowSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.beginSection("data");
            webRowSet.beforeFirst();
            webRowSet.setShowDeleted(true);
            while (webRowSet.next()) {
                if (webRowSet.rowDeleted() && webRowSet.rowInserted()) {
                    this.beginSection("insdel");
                } else if (webRowSet.rowDeleted()) {
                    this.beginSection("del");
                } else if (webRowSet.rowInserted()) {
                    this.beginSection("ins");
                } else {
                    this.beginSection("row");
                }
                int n2 = 1;
                while (n2 <= n) {
                    if (webRowSet.columnUpdated(n2)) {
                        ResultSet resultSet = webRowSet.getOriginalRow();
                        resultSet.next();
                        this.beginTag("col");
                        this.writeValue(n2, (RowSet)resultSet);
                        this.endTag("col");
                        this.beginTag("upd");
                        this.writeValue(n2, webRowSet);
                        this.endTag("upd");
                    } else {
                        this.beginTag("col");
                        this.writeValue(n2, webRowSet);
                        this.endTag("col");
                    }
                    ++n2;
                }
                this.endSection();
            }
            this.endSection("data");
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
    }

    private void writeDouble(double d) throws IOException {
        this.writer.write(Double.toString(d));
    }

    private void writeFloat(float f) throws IOException {
        this.writer.write(Float.toString(f));
    }

    private void writeHeader() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<!DOCTYPE RowSet PUBLIC '" + WebRowSet.PUBLIC_DTD_ID + "' '" + WebRowSet.SYSTEM_ID + "'>\n\n");
    }

    private void writeIndent(int n) throws IOException {
        int n2 = 1;
        while (n2 < n) {
            this.writer.write("  ");
            ++n2;
        }
    }

    private void writeInteger(int n) throws IOException {
        this.writer.write(Integer.toString(n));
    }

    private void writeLong(long l) throws IOException {
        this.writer.write(Long.toString(l));
    }

    private void writeMetaData(WebRowSet webRowSet) throws IOException {
        this.beginSection("metadata");
        try {
            ResultSetMetaData resultSetMetaData = webRowSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.propInteger("column-count", n);
            int n2 = 1;
            while (n2 <= n) {
                this.beginSection("column-definition");
                this.propInteger("column-index", n2);
                this.propBoolean("auto-increment", resultSetMetaData.isAutoIncrement(n2));
                this.propBoolean("case-sensitive", resultSetMetaData.isCaseSensitive(n2));
                this.propBoolean("currency", resultSetMetaData.isCurrency(n2));
                this.propInteger("nullable", resultSetMetaData.isNullable(n2));
                this.propBoolean("signed", resultSetMetaData.isSigned(n2));
                this.propBoolean("searchable", resultSetMetaData.isSearchable(n2));
                this.propInteger("column-display-size", resultSetMetaData.getColumnDisplaySize(n2));
                this.propString("column-label", resultSetMetaData.getColumnLabel(n2));
                this.propString("column-name", resultSetMetaData.getColumnName(n2));
                this.propString("schema-name", resultSetMetaData.getSchemaName(n2));
                this.propInteger("column-precision", resultSetMetaData.getPrecision(n2));
                this.propInteger("column-scale", resultSetMetaData.getScale(n2));
                this.propString("table-name", resultSetMetaData.getTableName(n2));
                this.propString("catalog-name", resultSetMetaData.getCatalogName(n2));
                this.propInteger("column-type", resultSetMetaData.getColumnType(n2));
                this.propString("column-type-name", resultSetMetaData.getColumnTypeName(n2));
                this.endSection("column-definition");
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endSection("metadata");
    }

    private void writeNull() throws IOException {
        this.emptyTag("null");
    }

    private void writeProperties(WebRowSet webRowSet) throws IOException {
        this.beginSection("properties");
        try {
            this.propString("command", webRowSet.getCommand());
            this.propInteger("concurrency", webRowSet.getConcurrency());
            this.propString("datasource", webRowSet.getDataSourceName());
            this.propBoolean("escape-processing", webRowSet.getEscapeProcessing());
            this.propInteger("fetch-direction", webRowSet.getFetchDirection());
            this.propInteger("fetch-size", webRowSet.getFetchSize());
            this.propInteger("isolation-level", webRowSet.getTransactionIsolation());
            this.beginSection("key-columns");
            int[] nArray = webRowSet.getKeyColumns();
            int n = 0;
            while (nArray != null && n < nArray.length) {
                this.propInteger("column", nArray[n]);
                ++n;
            }
            this.endSection("key-columns");
            this.beginTag("map");
            Map map = webRowSet.getTypeMap();
            if (map != null) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Class clazz = (Class)map.get(string);
                    this.propString("type", string);
                    this.propString("class", clazz.getName());
                }
            }
            this.endTag("map");
            this.propInteger("max-field-size", webRowSet.getMaxFieldSize());
            this.propInteger("max-rows", webRowSet.getMaxRows());
            this.propInteger("query-timeout", webRowSet.getQueryTimeout());
            this.propBoolean("read-only", webRowSet.isReadOnly());
            this.propInteger("rowset-type", webRowSet.getType());
            this.propBoolean("show-deleted", webRowSet.getShowDeleted());
            this.propString("table-name", webRowSet.getTableName());
            this.propString("url", webRowSet.getUrl());
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endSection("properties");
    }

    private void writeRowSet(WebRowSet webRowSet) throws SQLException {
        try {
            this.writeHeader();
            this.beginSection("RowSet");
            this.writeProperties(webRowSet);
            this.writeMetaData(webRowSet);
            this.writeData(webRowSet);
            this.endSection("RowSet");
        }
        catch (IOException iOException) {
            throw new SQLException("IOException: " + iOException.getMessage());
        }
    }

    private void writeShort(short s) throws IOException {
        this.writer.write(Short.toString(s));
    }

    private void writeString(String string) throws IOException {
        if (string != null) {
            this.writer.write(string);
        } else {
            this.writeNull();
        }
    }

    private void writeValue(int n, RowSet rowSet) throws IOException {
        try {
            int n2 = rowSet.getMetaData().getColumnType(n);
            switch (n2) {
                case -7: {
                    boolean bl = rowSet.getBoolean(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeBoolean(bl);
                    }
                    break;
                }
                case 5: {
                    short s = rowSet.getShort(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeShort(s);
                    }
                    break;
                }
                case 4: {
                    int n3 = rowSet.getInt(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeInteger(rowSet.getInt(n));
                    }
                    break;
                }
                case -5: {
                    long l = rowSet.getLong(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(l);
                    }
                    break;
                }
                case 6: 
                case 7: {
                    float f = rowSet.getFloat(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeFloat(f);
                    }
                    break;
                }
                case 8: {
                    double d = rowSet.getDouble(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeDouble(d);
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.writeBigDecimal(rowSet.getBigDecimal(n));
                    break;
                }
                case 91: {
                    Date date = rowSet.getDate(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(date.getTime());
                    }
                    break;
                }
                case 92: {
                    Time time = rowSet.getTime(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(time.getTime());
                    }
                    break;
                }
                case 93: {
                    Timestamp timestamp = rowSet.getTimestamp(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(((java.util.Date)timestamp).getTime());
                    }
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.writeString(rowSet.getString(n));
                    break;
                }
                default: {
                    System.out.println("Why here? Why now?");
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("Failed to writeValue: " + sQLException.getMessage());
        }
    }

    public void writeXML(WebRowSet webRowSet, Writer writer) throws SQLException {
        this.stack = new Stack();
        this.writer = writer;
        this.writeRowSet(webRowSet);
    }
}

