/*
 * Decompiled with CFR 0.152.
 */
package iDSS;

import iDSS.beans2.GridManagerJBean;
import iDSS.disp.DisplayFrame;
import iDSS.disp.DocumentDisplay;
import iDSS.tables.GeneralTableModel;
import iDSS.utils.DebugWriter;
import iDSS.utils.FileNameDialog;
import iDSS.utils.IDSSAppConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GridManager
extends DisplayFrame
implements ActionListener,
PropertyChangeListener {
    private GridManagerJBean gridManagerJBean = new GridManagerJBean();
    private String currentFileName;
    private JTable gridsTable;
    private JScrollPane gridsTableScrollPane;
    private JButton drawButton;
    private JButton disposeButton;
    private JButton selectButton;
    private JButton pickButton;
    private JButton describeButton;
    private JButton pickServerButton;
    private JButton saveServerButton;
    private boolean ALLOW_ROW_SELECTION = true;
    private String title = "modelSetupDemRemote";

    public GridManager() {
        super("modelSetupDemRemote", false, false, false, true, null);
        this.gridManagerJBean.removePropertyChangeListener(this);
        this.gridManagerJBean.addPropertyChangeListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Grids Fetched So Far"));
        Vector<String> vector = new Vector<String>();
        vector.add("Grid Name");
        vector.add("File Name");
        Vector vector2 = new Vector();
        GeneralTableModel generalTableModel = new GeneralTableModel(vector2, vector);
        this.gridsTable = new JTable(generalTableModel);
        this.gridsTable.setPreferredScrollableViewportSize(new Dimension(300, 50));
        this.gridsTableScrollPane = new JScrollPane(this.gridsTable, 20, 30);
        jPanel.add((Component)this.gridsTableScrollPane, "Center");
        this.drawButton = new JButton("Draw");
        this.drawButton.addActionListener(this);
        this.drawButton.setActionCommand("draw");
        this.drawButton.setEnabled(false);
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(this);
        this.selectButton.setActionCommand("select");
        this.selectButton.setEnabled(false);
        this.disposeButton = new JButton("Dispose");
        this.disposeButton.addActionListener(this);
        this.disposeButton.setActionCommand("dispose");
        this.disposeButton.setEnabled(false);
        this.pickButton = new JButton("From file");
        this.pickButton.addActionListener(this);
        this.pickButton.setActionCommand("pickFromFile");
        this.pickButton.setEnabled(true);
        this.describeButton = new JButton("Describe");
        this.describeButton.addActionListener(this);
        this.describeButton.setActionCommand("describe");
        this.describeButton.setEnabled(false);
        this.pickServerButton = new JButton("From server");
        this.pickServerButton.addActionListener(this);
        this.pickServerButton.setActionCommand("pickFromServer");
        this.pickServerButton.setEnabled(true);
        this.saveServerButton = new JButton("To server");
        this.saveServerButton.addActionListener(this);
        this.saveServerButton.setActionCommand("toServer");
        this.saveServerButton.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel3.add(this.drawButton);
        jPanel3.add(this.selectButton);
        jPanel3.add(this.disposeButton);
        jPanel3.add(this.describeButton);
        jPanel4.add(this.pickButton);
        jPanel4.add(this.pickServerButton);
        jPanel4.add(this.saveServerButton);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel2);
        this.pack();
        this.setVisible(true);
        this.gridsTable.setPreferredScrollableViewportSize(new Dimension(300, 40));
        if (this.ALLOW_ROW_SELECTION) {
            ListSelectionModel listSelectionModel = this.gridsTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No rows are selected.");
                        GridManager.this.drawButton.setEnabled(false);
                        GridManager.this.selectButton.setEnabled(false);
                        GridManager.this.disposeButton.setEnabled(false);
                        GridManager.this.describeButton.setEnabled(false);
                        GridManager.this.saveServerButton.setEnabled(false);
                        GridManager.this.gridManagerJBean.setCurrentFileName(null);
                    } else {
                        int n = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Row " + n + " is now selected.");
                        GridManager.this.drawButton.setEnabled(true);
                        GridManager.this.selectButton.setEnabled(true);
                        GridManager.this.disposeButton.setEnabled(true);
                        GridManager.this.describeButton.setEnabled(true);
                        GridManager.this.saveServerButton.setEnabled(true);
                        GridManager.this.currentFileName = (String)GridManager.this.gridsTable.getValueAt(n, 1);
                        GridManager.this.gridManagerJBean.setCurrentFileName(GridManager.this.currentFileName);
                    }
                }
            });
        } else {
            this.gridsTable.setRowSelectionAllowed(false);
        }
    }

    public void addToGrids(Vector vector) {
        GeneralTableModel generalTableModel = (GeneralTableModel)this.gridsTable.getModel();
        generalTableModel.addRow(vector);
        this.gridsTable.setModel(generalTableModel);
        this.saveServerButton.setEnabled(false);
    }

    private void removeFromGrids(Vector vector) {
        this.drawButton.setEnabled(false);
        this.selectButton.setEnabled(false);
        this.disposeButton.setEnabled(false);
        GeneralTableModel generalTableModel = (GeneralTableModel)this.gridsTable.getModel();
        generalTableModel.removeRow(vector);
        this.gridsTable.setModel(generalTableModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("pickFromFile")) {
            File file;
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("pickFromFile");
            }
            if ((file = FileNameDialog.getInputFileName(this.title, null, null)) != null) {
                String string = this.gridManagerJBean.pickGrid(file.toString());
                System.out.println(string);
            }
        } else if (actionEvent.getActionCommand().equals("draw")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("draw");
            }
            this.gridManagerJBean.drawGrid();
        } else if (actionEvent.getActionCommand().equals("dispose")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("dispose");
            }
            this.gridManagerJBean.removeFromGrids();
        } else if (actionEvent.getActionCommand().equals("select")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("select");
            }
            this.gridManagerJBean.selectGrid();
        } else if (actionEvent.getActionCommand().equals("toServer")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("toServer");
            }
            System.out.println("toServer");
            this.gridManagerJBean.saveToServer();
        } else if (actionEvent.getActionCommand().equals("pickFromServer")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("pickFromServer");
            }
            System.out.println("pickFromServer");
            this.gridManagerJBean.pickFromServer();
        } else if (actionEvent.getActionCommand().equals("describe")) {
            if (IDSSAppConstants.debug) {
                DebugWriter.writeDebug("describe");
            }
            System.out.println("pickFromServer");
            this.gridManagerJBean.describe();
        }
    }

    private void describe(Vector vector) {
        DocumentDisplay documentDisplay = new DocumentDisplay("Describing :", vector, "text/HTML");
        this.firePropertyChange("addToModelView", null, documentDisplay);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("GridManagerRemoveFromGrids")) {
            this.removeFromGrids((Vector)propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("GridManagerAddToGrids")) {
            this.addToGrids((Vector)propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("GridManagerGridDisp")) {
            this.firePropertyChange("addToModelView", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("GridManagerImgDisp")) {
            this.firePropertyChange("addToModelView", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("addGridToModel")) {
            this.firePropertyChange("addGridToModel", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("GridManagerGridDesc")) {
            this.describe((Vector)propertyChangeEvent.getNewValue());
        }
    }

    public String toString() {
        return "DisplayFrame: " + this.title;
    }
}

