/*
 * Decompiled with CFR 0.152.
 */
package iDSS.beans2;

import iDSS.beans2.SimulationJBean;
import iDSS.beans2.StatusJBean;
import iDSS.grids.Grid;
import iDSS.grids.LCGrid2;
import iDSS.tidalData.ClientDataSet;
import iDSS.tidalData.TidalModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Vector;

public class ModelSetupControllerJBean
implements PropertyChangeListener {
    private Hashtable modelDataHashtable = new Hashtable();
    private Hashtable tidalModelsHashtable = new Hashtable();
    private PropertyChangeSupport pcs;
    private StatusJBean statusJBean;

    public ModelSetupControllerJBean() {
        this.modelDataHashtable.put("tidalModelsHashtableName", this.tidalModelsHashtable);
        this.pcs = new PropertyChangeSupport(this);
        this.statusJBean = new StatusJBean();
    }

    public StatusJBean getStatusBean() {
        return this.statusJBean;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Vector<Object> vector;
        if (propertyChangeEvent.getPropertyName().equals("addGridToModel")) {
            vector = (Vector)propertyChangeEvent.getNewValue();
            this.addGridToModel(vector);
        }
        if (propertyChangeEvent.getPropertyName().equals("setTidalModel")) {
            vector = (Vector)propertyChangeEvent.getNewValue();
            this.setTidalModel(vector);
        }
        if (propertyChangeEvent.getPropertyName().equals("setAllTidalModels")) {
            vector = (Hashtable)propertyChangeEvent.getNewValue();
            this.setAllTidalModels((Hashtable)((Object)vector));
        }
        if (propertyChangeEvent.getPropertyName().equals("setIsostaticMovement")) {
            vector = (Integer)propertyChangeEvent.getNewValue();
            this.setIsostaticMovement((Integer)((Object)vector));
        }
        if (propertyChangeEvent.getPropertyName().equals("setSLRScenario")) {
            vector = (ClientDataSet)propertyChangeEvent.getNewValue();
            this.setSLRScenario((ClientDataSet)((Object)vector));
        }
        if (propertyChangeEvent.getPropertyName().equals("setAllSurvivalModels")) {
            vector = (Hashtable)propertyChangeEvent.getNewValue();
            this.setAllSurvivalModels((Hashtable)((Object)vector));
        }
        if (propertyChangeEvent.getPropertyName().equals("proceedWithSimulation")) {
            vector = new Vector<Object>();
            vector.add("Simulation status message");
            vector.add("ModelSetupControllerJBean.propertyChange(), proceedWithSimulation");
            vector.add(new Integer(1));
            this.pcs.firePropertyChange("showMessage", null, vector);
            this.proceedWithSimulation();
        }
    }

    public void addGridToModel(Vector vector) {
        if (vector != null) {
            String string = (String)vector.elementAt(0);
            Grid grid = (Grid)vector.elementAt(1);
            if (grid != null) {
                if (string.equals("lcGridName")) {
                    if (!grid.isRead()) {
                        grid.read();
                    }
                    Vector vector2 = grid.getClasses();
                    this.pcs.firePropertyChange("setClassTypes", null, vector2);
                    this.statusJBean.setLcGrid(grid.getGridVector().toString());
                } else if (string.equals("demGridName")) {
                    this.statusJBean.setDem(grid.getGridVector().toString());
                }
                this.modelDataHashtable.put(string, grid);
                System.out.println("ModelSetupControllerJBaen.addGridToModel(), hashCode : " + string + ", name : " + grid.getName());
            }
        }
    }

    public void setTidalModel(Vector vector) {
        String string = (String)vector.elementAt(0);
        TidalModel tidalModel = (TidalModel)vector.elementAt(1);
        this.tidalModelsHashtable.put(string, tidalModel);
    }

    public void setAllTidalModels(Hashtable hashtable) {
        this.tidalModelsHashtable = hashtable;
        if (this.modelDataHashtable.containsKey("tidalModelsHashtableName")) {
            this.modelDataHashtable.remove("tidalModelsHashtableName");
        }
        this.modelDataHashtable.put("tidalModelsHashtableName", this.tidalModelsHashtable);
        System.out.println("ModelSetupControllerJBean.setAllTidalModels(), tidalModelsHashtable.size() : " + this.tidalModelsHashtable.size());
    }

    public void setIsostaticMovement(Integer n) {
        this.modelDataHashtable.put("isostaticMovementHashCode", n);
    }

    public int getIsostaticMovement() {
        int n = 0;
        if (this.modelDataHashtable.containsKey("isostaticMovementHashCode")) {
            n = (Integer)this.modelDataHashtable.get("isostaticMovementHashCode");
        }
        return n;
    }

    public void setSLRScenario(ClientDataSet clientDataSet) {
        this.modelDataHashtable.put("slrDataHashCode", clientDataSet);
        System.out.println("ModelSetupControllerJBean.propertyChangeEvent(), SLRScenario = setSLRScenario done");
        System.out.println("ModelSetupControllerJBean.propertuChange(), slrDataSet.getStationName() : " + clientDataSet.getStationName());
        if (clientDataSet == null) {
            System.out.println("slr is null");
        } else {
            System.out.println("slr is not null");
        }
    }

    public void setAllSurvivalModels(Hashtable hashtable) {
        this.modelDataHashtable.put("smHashCode", hashtable);
        System.out.println("ModelSetupControllerJBean.propertyChangeEvent(), survivalModels = smHashCode done");
    }

    public void proceedWithSimulation() {
        Grid grid = (Grid)this.modelDataHashtable.get("demGridName");
        Grid grid2 = (Grid)this.modelDataHashtable.get("lcGridName");
        Hashtable hashtable = (Hashtable)this.modelDataHashtable.get("smHashCode");
        int n = (Integer)this.modelDataHashtable.get("isostaticMovementHashCode");
        ClientDataSet clientDataSet = (ClientDataSet)this.modelDataHashtable.get("slrDataHashCode");
        System.out.println("ModelSetupControllerJBean.propertyChange(), Checking contents of modelDataHashtable");
        if (grid == null) {
            System.out.println("demGrid is null");
        }
        if (grid2 == null) {
            System.out.println("lcGrid is null");
        }
        if (hashtable == null) {
            System.out.println("smHashtable is null");
        }
        System.out.println("isostatic = " + n);
        if (clientDataSet == null) {
            System.out.println("slr is null");
        }
        LCGrid2 lCGrid2 = new LCGrid2("Land Cover Details", null, grid2, hashtable);
        Vector<Object> vector = new Vector<Object>();
        vector.add(grid);
        vector.add(lCGrid2);
        vector.add(this.tidalModelsHashtable);
        vector.add(new Integer(n));
        vector.add(clientDataSet);
        this.pcs.firePropertyChange("createSimNode", null, vector);
    }

    public Vector getLandClasses() {
        Vector vector = new Vector();
        Grid grid = (Grid)this.modelDataHashtable.get("lcGridName");
        if (grid != null) {
            vector = grid.getClasses();
        }
        return vector;
    }

    public Hashtable getSurvivalModels() {
        Hashtable hashtable = (Hashtable)this.modelDataHashtable.get("smHashCode");
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        return hashtable;
    }

    public Hashtable getModelSetup() {
        return this.modelDataHashtable;
    }

    public SimulationJBean getSimulationJBean() {
        SimulationJBean simulationJBean = new SimulationJBean();
        Grid grid = (Grid)this.modelDataHashtable.get("demGridName");
        Grid grid2 = (Grid)this.modelDataHashtable.get("lcGridName");
        Hashtable hashtable = (Hashtable)this.modelDataHashtable.get("smHashCode");
        int n = (Integer)this.modelDataHashtable.get("isostaticMovementHashCode");
        ClientDataSet clientDataSet = (ClientDataSet)this.modelDataHashtable.get("slrDataHashCode");
        LCGrid2 lCGrid2 = new LCGrid2("Land Cover Details", null, grid2, hashtable);
        simulationJBean.setDem(grid);
        simulationJBean.setLcGrid2(lCGrid2);
        simulationJBean.setTidalModelHashtable(this.tidalModelsHashtable);
        simulationJBean.setIsostaticMovement(n);
        simulationJBean.setSlrDataSet(clientDataSet);
        return simulationJBean;
    }
}

