/*
 * Decompiled with CFR 0.152.
 */
package iDSS.beans2;

import iDSS.beans.TidalDataJBean;
import iDSS.beans.TidalStationsJBean;
import iDSS.database.DatabaseAccess;
import iDSS.tidalData.ClientDataSet;
import iDSS.utils.ConfigData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Timestamp;
import java.util.Vector;

public class TidalStationsLocalJBean {
    private String dataCategory;
    private String dataType;
    private String dataSet;
    private String dataTable;
    private String dataLocation;
    private Timestamp startDate;
    private Timestamp endDate;
    private Vector history = new Vector();
    private String userName;
    private String password;
    private String databaseDriver;
    private String dsn;
    private Vector remoteStations = this.getTidalStations();
    private Vector databaseDrivers = ConfigData.readURLProperties("config", "databaseDrivers.prop", this.getClass());
    private Vector dataSourceNames = ConfigData.readURLProperties("config", "dataSourceNames.prop", this.getClass());
    private PropertyChangeSupport pcs;

    public TidalStationsLocalJBean() {
        Vector vector;
        Vector vector2 = ConfigData.readProperties("config", "databaseDrivers.prop");
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                String string = (String)vector2.elementAt(n);
                this.databaseDrivers.add(string);
                ++n;
            }
        }
        if ((vector = ConfigData.readProperties("config", "dataSourceNames.prop")) != null) {
            int n = 0;
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                this.dataSourceNames.add(string);
                ++n;
            }
        }
        this.pcs = new PropertyChangeSupport(this);
        this.userName = "";
        this.password = "";
        this.databaseDriver = "";
        this.dsn = "";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public Vector getTidalStations() {
        TidalStationsJBean tidalStationsJBean = new TidalStationsJBean();
        tidalStationsJBean.setEjbName("TidalStationsEJB");
        Vector vector = tidalStationsJBean.findAll();
        Vector vector2 = this.setLocation(vector, "Remote");
        return vector2;
    }

    private Vector setLocation(Vector vector, String string) {
        Vector<Vector> vector2 = new Vector<Vector>();
        int n = 0;
        while (n < vector.size()) {
            Vector vector3 = (Vector)vector.elementAt(n);
            vector3.add(string);
            vector2.add(vector3);
            ++n;
        }
        return vector2;
    }

    public Vector getRemoteStations() {
        return this.remoteStations;
    }

    public Vector getDataSourceNames() {
        return this.dataSourceNames;
    }

    public Vector getDatabaseDrivers() {
        return this.databaseDrivers;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDatabaseDriver(String string) {
        this.databaseDriver = string;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDsn(String string) {
        this.dsn = string;
    }

    public String getDsn() {
        return this.dsn;
    }

    public Vector getLocalStations(String string, String string2, String string3, String string4, String string5) {
        Vector vector = new Vector();
        String string6 = "select * from " + string3;
        DatabaseAccess databaseAccess = new DatabaseAccess(string6, string2, string5, string4, string);
        vector = databaseAccess.getRowDataVector();
        databaseAccess.shutDown();
        Vector vector2 = this.setLocation(vector, "Local");
        return vector2;
    }

    private boolean checkHistory(String string, Timestamp timestamp, Timestamp timestamp2) {
        boolean bl = true;
        int n = 0;
        while (n < this.history.size()) {
            Vector vector = (Vector)this.history.elementAt(n);
            String string2 = (String)vector.elementAt(0);
            Timestamp timestamp3 = (Timestamp)vector.elementAt(1);
            Timestamp timestamp4 = (Timestamp)vector.elementAt(2);
            if (string.equals(string2) && (timestamp.after(timestamp3) || timestamp.equals(timestamp3)) && (timestamp2.before(timestamp4) || timestamp2.equals(timestamp4))) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public void fetchData(String string, Timestamp timestamp, Timestamp timestamp2, String string2, String string3) {
        if (!timestamp.after(timestamp2)) {
            boolean bl = this.checkHistory(string, timestamp, timestamp2);
            if (!bl) {
                String string4 = "You already have a superset of this data.";
                String string5 = "Warning";
                Vector<Object> vector = new Vector<Object>();
                vector.add(string5);
                vector.add(string4);
                vector.add(new Integer(2));
                this.pcs.firePropertyChange("showMessage", new Boolean(false), vector);
                return;
            }
            ClientDataSet clientDataSet = new ClientDataSet();
            clientDataSet = string3.equals("Remote") ? this.fetchRemoteData(string2, timestamp, timestamp2) : this.fetchLocalData(string2, timestamp, timestamp2);
            if (clientDataSet != null) {
                clientDataSet.setStationName(string);
                this.pcs.firePropertyChange("tidalData", new Boolean(false), clientDataSet);
                Vector<Object> vector = new Vector<Object>();
                vector.add(string);
                vector.add(timestamp);
                vector.add(timestamp2);
                this.history.add(vector);
            }
        }
    }

    public void disposeData(Vector vector) {
        if (this.history.contains(vector)) {
            this.history.removeElement(vector);
        }
    }

    private ClientDataSet fetchRemoteData(String string, Timestamp timestamp, Timestamp timestamp2) {
        TidalDataJBean tidalDataJBean = new TidalDataJBean();
        tidalDataJBean.setEjbName("TidalDataEJB");
        String string2 = "java:comp/env/jdbc/idss";
        ClientDataSet clientDataSet = tidalDataJBean.select(string, timestamp, timestamp2, string2);
        return clientDataSet;
    }

    private ClientDataSet fetchLocalData(String string, Timestamp timestamp, Timestamp timestamp2) {
        ClientDataSet clientDataSet = null;
        if (this.databaseDriver.length() == 0 || this.dsn.length() == 0 || this.password.length() == 0 || this.userName.length() == 0) {
            clientDataSet = null;
            String string2 = "Missing atleast one of userName, password, databaseDriver or dsn";
            String string3 = "Incomplete information";
            Vector<Object> vector = new Vector<Object>();
            vector.add(string3);
            vector.add(string2);
            vector.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", new Boolean(false), vector);
        } else {
            String string4 = "select * from " + string + " where " + "observ_date>='" + timestamp.toString() + "' and " + "observ_date<='" + timestamp2.toString() + "'";
            DatabaseAccess databaseAccess = new DatabaseAccess(string4, this.dsn, this.userName, this.password, this.databaseDriver);
            Vector vector = databaseAccess.getRowDataVector();
            Vector vector2 = databaseAccess.getColumnNamesVector();
            clientDataSet = new ClientDataSet(string4, string, timestamp, timestamp2, vector2, vector);
            databaseAccess.shutDown();
        }
        return clientDataSet;
    }
}

