/*
 * Decompiled with CFR 0.152.
 */
package iDSS.sim;

import iDSS.beans2.SimulationJBean;
import iDSS.grids.Grid;
import iDSS.grids.Grid2;
import iDSS.grids.LCGrid2;
import iDSS.math.Fourier;
import iDSS.tidalData.ClientDataSet;
import iDSS.tidalData.TidalModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SimulationRun
implements Runnable {
    private String simulationName;
    private Grid demGrid;
    private LCGrid2 lcGrid2;
    private Hashtable tidalModelHashtable;
    private ClientDataSet slrScenarioDataSet;
    private int simulateUntil;
    private int resultsTimeStep;
    private String simulationTimeStepUnits;
    private String resultsTimeStepUnits;
    private File saveLocation;
    private boolean viewFloodGrid;
    private boolean saveFloodGrid;
    private boolean viewDDGraph;
    private boolean saveDDGraph;
    private long simulationTimeStep;
    private long simulationStartTime;
    private int isostaticMovement;
    private ClientDataSet computedTidalDataSet;
    private int startYear;
    private File fdGridsSavePath;
    private File summaryGridsSavePath;
    private Thread simThread;
    PropertyChangeSupport pcs;
    private Vector floodStartVector;

    public SimulationRun() {
        System.out.println("In SimulationRun constructor");
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void xxSimData(SimulationJBean simulationJBean) {
        this.setSimulationData(simulationJBean);
    }

    public void setSimulationData(SimulationJBean simulationJBean) {
        System.out.println("SimulationRun.setSimulationData()");
        this.simulationName = simulationJBean.getSimulationName();
        this.demGrid = simulationJBean.getDem();
        this.lcGrid2 = simulationJBean.getLcGrid2();
        this.tidalModelHashtable = simulationJBean.getTidalModelHashtable();
        this.slrScenarioDataSet = simulationJBean.getSlrDataSet();
        this.simulateUntil = simulationJBean.getSimulateUntil();
        long l = 60000L;
        this.simulationTimeStep = (long)simulationJBean.getTimestepMinutes() * l;
        this.resultsTimeStep = simulationJBean.getResultsTimestepYears();
        this.saveLocation = simulationJBean.getSaveLocationDir();
        this.viewFloodGrid = simulationJBean.getViewFG();
        this.saveFloodGrid = simulationJBean.getSaveFG();
        this.viewDDGraph = simulationJBean.getViewDD();
        this.saveDDGraph = simulationJBean.getSaveDD();
        this.isostaticMovement = simulationJBean.getIsostaticMovement();
        this.floodStartVector = simulationJBean.getFloodStartVector();
        System.out.println("Simulation name : " + this.simulationName);
        System.out.println("DEM grid        : " + this.demGrid.getName());
        System.out.println("Landcover grid2 : " + this.lcGrid2.getName());
        System.out.println("# tidal models  : " + this.tidalModelHashtable.size());
        System.out.println("SLR scenario    : " + this.slrScenarioDataSet.getSqlString());
        System.out.println("Simulate until  : " + this.simulateUntil);
        System.out.println("Simulation step : " + this.simulationTimeStep + " millisec");
        System.out.println("Results step    : " + this.resultsTimeStep + " year");
        System.out.println("Simulation name : " + this.simulationName);
        System.out.println("View Flood Grid : " + this.viewFloodGrid);
        System.out.println("Save Flood Grid : " + this.saveFloodGrid);
        System.out.println("View Depth Dur  : " + this.viewDDGraph);
        System.out.println("Save Depth Dur  : " + this.saveDDGraph);
        this.fdGridsSavePath = new File(this.saveLocation, this.simulationName + "\\fdGrids");
        if (!this.fdGridsSavePath.exists()) {
            this.fdGridsSavePath.mkdirs();
        }
        this.summaryGridsSavePath = new File(this.saveLocation, this.simulationName + "\\summaryGrids");
        if (!this.summaryGridsSavePath.exists()) {
            this.summaryGridsSavePath.mkdirs();
        }
        File file = new File(this.saveLocation, this.simulationName + "\\summaryGrids\\landCoverHistory");
        this.lcGrid2.setFile(file);
    }

    public void run() {
        this.startSimulation();
    }

    private void startSimulation() {
        System.out.println("In SimulationRun startSimulation()");
        this.startYear = this.getStartYear();
        this.computedTidalDataSet = this.computeTidalDataSet();
        System.out.println("For the computed tidal dataSet:");
        System.out.println("sqlString   : " + this.computedTidalDataSet.getSqlString());
        System.out.println("stationName : " + this.computedTidalDataSet.getStationName());
        System.out.println("timeMin     : " + this.computedTidalDataSet.getTimeMin());
        System.out.println("timeMax     : " + this.computedTidalDataSet.getTimeMax());
        System.out.println("valueMin    : " + this.computedTidalDataSet.getValueMin());
        System.out.println("valueMax    : " + this.computedTidalDataSet.getValueMax());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string = "0.00";
        DecimalFormat decimalFormat = new DecimalFormat(string);
        int n = this.startYear;
        while (n <= this.simulateUntil) {
            System.out.print("Present year : " + n);
            File file = new File(this.summaryGridsSavePath, "SUM" + String.valueOf(n));
            Grid2 grid2 = new Grid2(String.valueOf(n), this.demGrid.getUnits(), file, this.demGrid.getNRows(), this.demGrid.getNColumns(), this.demGrid.getCellSize(), this.demGrid.getxLLCorner(), this.demGrid.getyLLCorner());
            Calendar calendar = Calendar.getInstance();
            calendar.set(n, 0, 1, 0, 0, 0);
            Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
            double d = this.slrScenarioDataSet.getDataAt(timestamp);
            if (Math.abs(d - -9999.0) > 1.0) {
                Cloneable cloneable;
                Object object;
                System.out.println("  slr = " + d);
                Vector vector = this.computedTidalDataSet.getColumnsOfDataVector();
                Vector vector2 = (Vector)vector.elementAt(0);
                Vector vector3 = (Vector)vector.elementAt(1);
                double d2 = 0.0;
                Timestamp timestamp2 = null;
                int n2 = 0;
                while (n2 < vector3.size()) {
                    object = (Double)vector3.elementAt(n2);
                    d2 = (Double)object + d / 100.0 - (double)this.isostaticMovement * (double)(n - this.startYear) / 1000.0;
                    timestamp2 = (Timestamp)vector2.elementAt(n2);
                    cloneable = Calendar.getInstance();
                    ((Calendar)cloneable).setTime(timestamp2);
                    ((Calendar)cloneable).set(1, n);
                    timestamp2 = new Timestamp(((Calendar)cloneable).getTime().getTime());
                    String string2 = "FD" + simpleDateFormat.format(timestamp2);
                    File file2 = new File(this.fdGridsSavePath, string2);
                    string2 = "FD:" + simpleDateFormat2.format(timestamp2) + ":" + decimalFormat.format(d2);
                    this.setStatus(timestamp2);
                    this.simThread = Thread.currentThread();
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("In SimulationRun.startSimulation(), " + interruptedException);
                    }
                    double d3 = 0.0;
                    double d4 = 0.0;
                    Grid grid = this.demGrid.createFloodGrid(d2, string2, this.floodStartVector, file2);
                    grid.setOutFile(file2);
                    grid.writeGridObject();
                    grid2.buildUp(grid, this.lcGrid2, this.simulationTimeStep, timestamp2);
                    ++n2;
                }
                if (timestamp2 != null) {
                    grid2.roundUp(this.lcGrid2, this.simulationTimeStep, d2, timestamp2);
                } else {
                    object = "SimulationRun.startSimulation(), computedTidalDataSet is empty!";
                    System.out.println((String)object);
                    cloneable = new Vector<Object>();
                    ((Vector)cloneable).add("Error");
                    ((Vector)cloneable).add(object);
                    ((Vector)cloneable).add(new Integer(0));
                    this.pcs.firePropertyChange("showMessage", null, cloneable);
                }
                grid2.writeGrid2Object();
            }
            ++n;
        }
        this.pcs.firePropertyChange("notifySimulationEnd", new Boolean(false), new Boolean(true));
    }

    private ClientDataSet computeTidalDataSet() {
        Enumeration enumeration;
        System.out.println("Computing tidalDataSet...");
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        vector.add("Time");
        vector.add("Computed Tide");
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.startYear, 0, 1, 0, 0, 0);
        this.simulationStartTime = calendar.getTime().getTime() / 1000L * 1000L;
        Timestamp timestamp = new Timestamp(this.simulationStartTime);
        calendar.set(this.startYear + 1, 0, 1, 0, 0, 0);
        long l = calendar.getTime().getTime() / 1000L * 1000L;
        Timestamp timestamp2 = new Timestamp(l);
        boolean bl = true;
        long l2 = this.simulationStartTime;
        int n = 0;
        while (bl) {
            Serializable serializable;
            Object object;
            enumeration = this.tidalModelHashtable.keys();
            double d = 0.0;
            double d2 = 0.0;
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                serializable = (TidalModel)this.tidalModelHashtable.get(object);
                timestamp = ((TidalModel)serializable).getBasisStart();
                l2 = ((Date)timestamp).getTime() + (long)n * this.simulationTimeStep;
                if (l2 > ((Date)(timestamp2 = ((TidalModel)serializable).getBasisEnd())).getTime()) {
                    bl = false;
                    continue;
                }
                double d3 = Fourier.computeY(l2, ((TidalModel)serializable).getFourierA(), ((TidalModel)serializable).getFourierB(), ((TidalModel)serializable).getFourierC(), ((TidalModel)serializable).getFourierPeriod());
                Timestamp timestamp3 = new Timestamp(l2);
                d += (d3 *= (double)((TidalModel)serializable).getWeightage());
                d2 += (double)((TidalModel)serializable).getWeightage();
            }
            if (!bl) continue;
            object = new Vector();
            serializable = new Timestamp(l2);
            ((Vector)object).add(serializable);
            ((Vector)object).add(new Double(d /= d2));
            vector2.add(object);
            ++n;
        }
        enumeration = this.tidalModelHashtable.keys();
        String string = "";
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            TidalModel tidalModel = (TidalModel)this.tidalModelHashtable.get(string3);
            int n2 = tidalModel.getWeightage();
            string = string + string3 + "," + n2 + ":";
            string2 = string2 + string3 + ":";
        }
        ClientDataSet clientDataSet = new ClientDataSet(string, string2, timestamp, timestamp2, vector, vector2);
        return clientDataSet;
    }

    private int getStartYear() {
        System.out.println("In SimulationRun getStartYear()");
        int n = 2000;
        Enumeration enumeration = this.tidalModelHashtable.elements();
        while (enumeration.hasMoreElements()) {
            TidalModel tidalModel = (TidalModel)enumeration.nextElement();
            Timestamp timestamp = tidalModel.getBasisStart();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            int n2 = calendar.get(1);
            if (n2 <= n) continue;
            n = n2;
        }
        System.out.println("Start year = : " + n);
        return n;
    }

    private void setStatus(Timestamp timestamp) {
        this.pcs.firePropertyChange("setSimulationStatus", null, timestamp);
    }
}

