/*
 * Decompiled with CFR 0.152.
 */
package iDSS.slr;

import iDSS.beans2.ScenarioDetailJBean;
import iDSS.disp.DisplayFrame;
import iDSS.tables.GeneralTableModel;
import iDSS.tidalData.ClientDataSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScenarioDetail
extends DisplayFrame
implements ActionListener {
    private JButton selectButton;
    private boolean ALLOW_ROW_SELECTION = false;
    private boolean ALLOW_COLUMN_SELECTION = true;
    private int selectedCol;
    private JTable aTable;
    private String scenarioName;
    private final int yearCol = 1;
    private ScenarioDetailJBean scenarioDetailJBean;

    public ScenarioDetail(String string) {
        super(string + ":Detail", false, true, false, true, null);
        Serializable serializable;
        this.scenarioName = string;
        this.scenarioDetailJBean = new ScenarioDetailJBean();
        this.scenarioDetailJBean.setScenarioName(this.scenarioName);
        Vector vector = this.scenarioDetailJBean.getScenarioDetail();
        if (vector != null) {
            serializable = new Vector<String>();
            serializable = new Vector();
            serializable.add("Scenario");
            serializable.add("Year");
            serializable.add("1.5C Sensitivity");
            serializable.add("4.5C Sensitivity");
            serializable.add("2.5C Sensitivity");
            serializable.add("2.5C w/o Sulphate Forcing");
            GeneralTableModel generalTableModel = new GeneralTableModel(vector, (Vector)serializable);
            this.aTable = new JTable(generalTableModel);
        } else {
            JOptionPane.showMessageDialog(null, "No SLR scenario found in database");
            Object var3_5 = null;
            this.aTable = new JTable(5, 5);
        }
        this.aTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.aTable.setSelectionMode(0);
        serializable = new JScrollPane(this.aTable);
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(this);
        this.selectButton.setActionCommand("select");
        this.selectButton.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.selectButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add((Component)serializable);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setVisible(true);
        if (this.ALLOW_COLUMN_SELECTION) {
            if (this.ALLOW_ROW_SELECTION) {
                this.aTable.setCellSelectionEnabled(true);
            }
            this.aTable.setColumnSelectionAllowed(true);
            ListSelectionModel listSelectionModel = this.aTable.getColumnModel().getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        System.out.println("No columns are selected.");
                        ScenarioDetail.this.selectButton.setEnabled(false);
                    } else {
                        ScenarioDetail.this.selectedCol = listSelectionModel.getMinSelectionIndex();
                        System.out.println("Column " + ScenarioDetail.this.selectedCol + " is now selected.");
                        if (ScenarioDetail.this.selectedCol > 1) {
                            ScenarioDetail.this.selectButton.setEnabled(true);
                        } else {
                            ScenarioDetail.this.selectButton.setEnabled(false);
                        }
                    }
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("select")) {
            ClientDataSet clientDataSet = this.scenarioDetailJBean.makeSLRDataSet(this.selectedCol, 1);
            clientDataSet.setStationName(this.scenarioName + ":" + this.aTable.getColumnName(this.selectedCol));
            this.setSLRScenario(clientDataSet);
        }
    }

    private void setSLRScenario(ClientDataSet clientDataSet) {
        this.firePropertyChange("setSLRScenario", null, clientDataSet);
    }
}

