/*
 * Decompiled with CFR 0.152.
 */
package iDSS.tidalData;

import iDSS.beans2.TidalStationsLocalJBean;
import iDSS.disp.DisplayFrame;
import iDSS.tables.ScrollingTable;
import iDSS.tidalData.ClientDataSet;
import iDSS.tidalData.DataManager;
import iDSS.tidalData.TimestampPanel;
import iDSS.utils.ConfigData;
import iDSS.utils.FileNameDialog;
import iDSS.utils.MessageHandler;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class TidalStationsLocal
extends DisplayFrame
implements ActionListener,
PropertyChangeListener {
    private ScrollingTable aTable;
    private JScrollPane scrollPane;
    private JButton fetchDataButton;
    private TimestampPanel startTimestamp;
    private TimestampPanel endTimestamp;
    private JPanel timesPanel;
    private JPanel bottomPanel;
    private boolean ALLOW_ROW_SELECTION = true;
    private String dataCategory;
    private String dataType;
    private String dataSet;
    private String stationName;
    private String dataTable;
    private String dataLocation;
    private Timestamp startDate;
    private Timestamp endDate;
    private String title;
    private JComboBox databaseDriverCombo;
    private JComboBox dsnCombo;
    private JButton getStationsButton;
    private JTextField userNameTextField;
    private JPasswordField passwordField;
    private JTextField tableNameTextField;
    private DataManager dm;
    private TidalStationsLocalJBean tidalStationsLocalJBean = new TidalStationsLocalJBean();
    private JButton getDsnButton;
    private JButton getDatabaseDriversButton;

    public TidalStationsLocal(String string) {
        super(string, false, false, false, true, null);
        this.tidalStationsLocalJBean.addPropertyChangeListener(this);
        this.title = string;
        Vector vector = this.tidalStationsLocalJBean.getTidalStations();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Station Name");
        vector2.add("Start Date");
        vector2.add("End Date");
        vector2.add("Data Table");
        vector2.add("Location");
        this.aTable = new ScrollingTable(vector2, vector, 500, 100, true, false);
        this.aTable.removePropertyChangeListener(this);
        this.aTable.addPropertyChangeListener(this);
        this.scrollPane = this.aTable.getScrollPane();
        this.databaseDriverCombo = new JComboBox(this.tidalStationsLocalJBean.getDatabaseDrivers());
        this.dsnCombo = new JComboBox(this.tidalStationsLocalJBean.getDataSourceNames());
        this.userNameTextField = new JTextField(12);
        this.passwordField = new JPasswordField(12);
        JLabel jLabel = new JLabel("User name:");
        JLabel jLabel2 = new JLabel("Password:");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel2.add(this.userNameTextField);
        jPanel2.add(this.passwordField);
        this.tableNameTextField = new JTextField(5);
        JLabel jLabel3 = new JLabel("Table name:");
        this.getStationsButton = new JButton("Get Stations");
        this.getStationsButton.setActionCommand("getStationsButtonCommand");
        this.getStationsButton.addActionListener(this);
        this.getDsnButton = new JButton("Get DSN");
        this.getDsnButton.setActionCommand("getDsnButtonCommand");
        this.getDsnButton.addActionListener(this);
        this.getDatabaseDriversButton = new JButton("Get Drivers");
        this.getDatabaseDriversButton.setActionCommand("getDatabaseDriversButtonCommand");
        this.getDatabaseDriversButton.addActionListener(this);
        JLabel jLabel4 = new JLabel("Database driver:");
        JLabel jLabel5 = new JLabel("Data source:");
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel4.add(jLabel4);
        jPanel4.add(jLabel5);
        jPanel5.setLayout(new GridLayout(2, 1));
        jPanel5.add(this.databaseDriverCombo);
        jPanel5.add(this.dsnCombo);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalStrut(2));
        jPanel3.add(jPanel);
        jPanel3.add(Box.createHorizontalStrut(2));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createHorizontalStrut(2));
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createHorizontalStrut(2));
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(this.getStationsButton);
        jPanel6.add(Box.createHorizontalStrut(2));
        jPanel6.add(this.getDsnButton);
        jPanel6.add(Box.createHorizontalStrut(2));
        jPanel6.add(this.getDatabaseDriversButton);
        jPanel6.add(Box.createHorizontalStrut(2));
        jPanel6.add(jLabel3);
        jPanel3.add(Box.createHorizontalStrut(2));
        jPanel6.add(this.tableNameTextField);
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel6);
        jPanel7.setBorder(BorderFactory.createEtchedBorder());
        this.fetchDataButton = new JButton("Fetch Data");
        this.fetchDataButton.addActionListener(this);
        this.fetchDataButton.setActionCommand("fetchDataButtonCommand");
        this.fetchDataButton.setEnabled(false);
        this.startTimestamp = new TimestampPanel("Start:", 1900, 2050);
        this.endTimestamp = new TimestampPanel("End:", 1900, 2050);
        this.timesPanel = new JPanel();
        this.timesPanel.setLayout(new GridLayout(2, 1));
        this.timesPanel.add(this.startTimestamp);
        this.timesPanel.add(this.endTimestamp);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.bottomPanel.add(this.fetchDataButton);
        this.bottomPanel.add(this.timesPanel);
        this.bottomPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.scrollPane);
        this.getContentPane().add(jPanel7);
        this.getContentPane().add(this.bottomPanel);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("getStationsButtonCommand")) {
            String string = (String)this.databaseDriverCombo.getSelectedItem();
            String string2 = (String)this.dsnCombo.getSelectedItem();
            String string3 = this.tableNameTextField.getText();
            String string4 = new String(this.passwordField.getPassword());
            String string5 = this.userNameTextField.getText();
            if (string.length() == 0 || string2.length() == 0 || string3.length() == 0 || string4.length() == 0 || string5.length() == 0) {
                JOptionPane.showMessageDialog(null, "Fill up all input boxes", "Incomplete information", 0);
            } else {
                Vector vector = this.tidalStationsLocalJBean.getLocalStations(string, string2, string3, string4, string5);
                if (vector != null) {
                    this.aTable.addRows(vector);
                }
            }
        } else if (actionEvent.getActionCommand().equals("fetchDataButtonCommand")) {
            this.startDate = this.startTimestamp.getTimestamp();
            this.endDate = this.endTimestamp.getTimestamp();
            String string = this.userNameTextField.getText();
            String string6 = new String(this.passwordField.getPassword());
            String string7 = (String)this.databaseDriverCombo.getSelectedItem();
            String string8 = (String)this.dsnCombo.getSelectedItem();
            this.tidalStationsLocalJBean.setUserName(string);
            this.tidalStationsLocalJBean.setPassword(string6);
            this.tidalStationsLocalJBean.setDatabaseDriver(string7);
            this.tidalStationsLocalJBean.setDsn(string8);
            this.tidalStationsLocalJBean.fetchData(this.stationName, this.startDate, this.endDate, this.dataTable, this.dataLocation);
        } else if (actionEvent.getActionCommand().equals("getDsnButtonCommand")) {
            File file = FileNameDialog.getInputFileName("Select a DSN file", null, null);
            Vector vector = new Vector();
            if (file != null && (vector = ConfigData.readProperties(file)) != null) {
                int n = 0;
                while (n < vector.size()) {
                    String string = (String)vector.elementAt(n);
                    this.dsnCombo.addItem(string);
                    ++n;
                }
            }
        } else if (actionEvent.getActionCommand().equals("getDatabaseDriversButtonCommand")) {
            File file = FileNameDialog.getInputFileName("Select a database drivers file", null, null);
            Vector vector = new Vector();
            if (file != null && (vector = ConfigData.readProperties(file)) != null) {
                String string;
                int n = 0;
                while (n < vector.size()) {
                    string = (String)vector.elementAt(n);
                    this.databaseDriverCombo.addItem(string);
                    ++n;
                }
                string = ".";
                File file2 = file.getParentFile();
                if (file2 != null) {
                    string = file2.toString();
                }
                System.out.println("TidalStationsLocal.actionPerformed(), driverPath: " + string);
                ConfigData.addToClassPath(string);
            }
        }
    }

    private void addToModelView(DisplayFrame displayFrame) {
        this.firePropertyChange("addToModelView", null, displayFrame);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Vector vector;
        ClientDataSet clientDataSet;
        Vector vector2;
        if (propertyChangeEvent.getPropertyName().equals("setTidalModel")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("addToModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("showMessage")) {
            vector2 = (Vector)propertyChangeEvent.getNewValue();
            MessageHandler.showMessage(vector2);
        }
        if (propertyChangeEvent.getPropertyName().equals("noRowsSelected")) {
            this.fetchDataButton.setEnabled(false);
        }
        if (propertyChangeEvent.getPropertyName().equals("noColsSelected")) {
            System.out.println("TidalStationsLocal.propertyChange(), " + propertyChangeEvent.getPropertyName());
        }
        if (propertyChangeEvent.getPropertyName().equals("oneRowSelected")) {
            vector2 = (Vector)propertyChangeEvent.getNewValue();
            this.selectOneRow(vector2);
        }
        if (propertyChangeEvent.getPropertyName().equals("oneColSelected")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            String string = this.aTable.getColumnName(n);
        }
        if (propertyChangeEvent.getPropertyName().equals("tidalData") && (clientDataSet = (ClientDataSet)propertyChangeEvent.getNewValue()) != null) {
            this.receiveData(clientDataSet);
        }
        if (propertyChangeEvent.getPropertyName().equals("disposeData") && (vector = (Vector)propertyChangeEvent.getNewValue()) != null) {
            this.tidalStationsLocalJBean.disposeData(vector);
        }
    }

    private void selectOneRow(Vector vector) {
        this.fetchDataButton.setEnabled(true);
        this.stationName = (String)vector.elementAt(0);
        Timestamp timestamp = (Timestamp)vector.elementAt(1);
        Timestamp timestamp2 = (Timestamp)vector.elementAt(2);
        this.dataTable = (String)vector.elementAt(3);
        this.dataLocation = (String)vector.elementAt(4);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n = calendar.get(1);
        calendar.setTime(timestamp2);
        int n2 = calendar.get(1);
        this.startTimestamp.resetYearCombo(n, n2);
        this.endTimestamp.resetYearCombo(n, n2);
        this.startTimestamp.setTime(timestamp);
        this.endTimestamp.setTime(timestamp2);
        int n3 = 0;
        while (n3 < vector.size()) {
            String string = vector.elementAt(n3).toString();
            System.out.println(string);
            ++n3;
        }
    }

    private void receiveData(ClientDataSet clientDataSet) {
        if (this.dm == null) {
            this.dm = new DataManager(clientDataSet);
            this.dm.addPropertyChangeListener(this);
            this.addToModelView(this.dm);
        } else {
            this.dm.addToDataSet(clientDataSet);
        }
    }

    public String toString() {
        return "TidalStationsLocal: " + this.title;
    }
}

