/*
 * Decompiled with CFR 0.152.
 */
package iDSS.xyGraph;

import iDSS.tidalData.ClientDataSet;
import iDSS.xyGraph.GraphAxis;
import iDSS.xyGraph.GraphicalDisplay2;
import iDSS.xyGraph.Legend;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Graph
implements PropertyChangeListener {
    private GraphAxis xAxis;
    private GraphAxis yAxis;
    private Hashtable dataSets;
    private Legend legend;
    private GraphicalDisplay2 graphDisplay;
    private long timeMin;
    private long timeMax;
    private double valueMin;
    private double valueMax;
    int legX1;
    int legY1;
    private String valueFormatPattern;
    private String xAxisName = "Time";
    private String yAxisName = "Value";
    private Vector colorsVector;
    private final int MAX_NUMBER_OF_GRAPHS = 5;
    private int currentColorIndex;
    private String key;

    public Graph(GraphicalDisplay2 graphicalDisplay2, ClientDataSet clientDataSet, Timestamp timestamp, Timestamp timestamp2, Color color) {
        this.graphDisplay = graphicalDisplay2;
        this.colorsVector = new Vector();
        this.colorsVector.add(Color.black);
        this.colorsVector.add(Color.blue);
        this.colorsVector.add(Color.cyan);
        this.colorsVector.add(Color.green);
        this.colorsVector.add(Color.magenta);
        this.colorsVector.add(Color.orange);
        this.colorsVector.add(Color.pink);
        this.colorsVector.add(Color.red);
        this.colorsVector.add(Color.yellow);
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.add(clientDataSet);
        vector.add(timestamp);
        vector.add(timestamp2);
        this.currentColorIndex = this.currentColorIndex < this.colorsVector.size() - 1 ? ++this.currentColorIndex : 0;
        Color color2 = (Color)this.colorsVector.elementAt(this.currentColorIndex);
        vector.add(color2);
        this.dataSets = new Hashtable();
        this.dataSets.put(clientDataSet.getSqlString() + timestamp.toString() + timestamp2.toString(), vector);
        this.timeMin = ((Date)timestamp).getTime();
        this.timeMax = ((Date)timestamp2).getTime();
        this.valueMin = clientDataSet.getValueMin();
        this.valueMax = clientDataSet.getValueMax();
        this.roundValues();
        this.legend = new Legend(clientDataSet.getSqlString() + timestamp.toString() + timestamp2.toString(), clientDataSet.getStationName(), color2, 0, 0);
        this.drawGraph();
    }

    public GraphicalDisplay2 getDisplay() {
        return this.graphDisplay;
    }

    public void roundValues() {
        double d = (this.valueMax - this.valueMin) / 10.0;
        int n = 0;
        while (d < 1.0) {
            d *= 10.0;
            ++n;
        }
        String string = "0.";
        int n2 = 0;
        while (n2 < n) {
            string = string.concat("0");
            ++n2;
        }
        this.valueFormatPattern = string;
        DecimalFormat decimalFormat = new DecimalFormat(string);
        System.out.println("valueMin with formatting,  " + decimalFormat.format(this.valueMin));
        d = (this.valueMax - this.valueMin) / 10.0;
        d = (double)((int)(d * Math.pow(10.0, n))) / Math.pow(10.0, n);
        double d2 = (double)((int)(this.valueMin / d)) * d;
        this.valueMin = d2 < this.valueMin ? d2 : d2 - d;
        d2 = (double)((int)(this.valueMax / d) + 1) * d;
        this.valueMax = d2 > this.valueMax ? d2 : d2 + d;
    }

    public void drawGraph() {
        int n = this.graphDisplay.getCanvasX();
        int n2 = this.graphDisplay.getCanvasY();
        BufferedImage bufferedImage = this.graphDisplay.getCanvas();
        if (bufferedImage == null) {
            System.out.println("image is null");
        }
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.black);
        int n3 = Math.min(n / 10, 50);
        int n4 = Math.min(n2 / 10, 50);
        int n5 = n - n3;
        int n6 = n2 - n4;
        int n7 = n5 - n3;
        int n8 = n6 - n4;
        graphics2D.drawRect(n3, n4, n7, n8);
        int n9 = Math.max(n / 200, 2);
        int n10 = Math.max(n2 / 100, 2);
        Vector<String> vector = new Vector<String>();
        long l = (this.timeMax - this.timeMin) / (long)(n9 - 1);
        int n11 = 0;
        while (n11 < n9) {
            long l2 = this.timeMin + (long)n11 * l;
            Timestamp timestamp = new Timestamp(l2);
            vector.add(timestamp.toString());
            ++n11;
        }
        Vector<String> vector2 = new Vector<String>();
        double d = (this.valueMax - this.valueMin) / (double)(n10 - 1);
        DecimalFormat decimalFormat = new DecimalFormat(this.valueFormatPattern);
        int n12 = 0;
        while (n12 < n10) {
            double d2 = this.valueMin + (double)n12 * d;
            String string = decimalFormat.format(d2);
            vector2.add(string);
            ++n12;
        }
        this.xAxis = new GraphAxis(this.xAxisName, vector, n3, n6, n5, n6, Color.black);
        this.xAxis.drawXAxis(graphics2D);
        this.yAxis = new GraphAxis(this.yAxisName, vector2, n3, n6, n3, n4, Color.black);
        this.yAxis.drawYAxis(graphics2D);
        this.legend.setX(n3 + 10);
        this.legend.setY(n6 - 10);
        this.drawEachGraph(graphics2D, n3, n4, n5, n6);
        this.legend.drawLegend(graphics2D);
        this.graphDisplay.refreshCanvas(bufferedImage);
    }

    public void drawEachGraph(Graphics graphics, int n, int n2, int n3, int n4) {
        Enumeration enumeration = this.dataSets.elements();
        Enumeration enumeration2 = this.colorsVector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            ClientDataSet clientDataSet = (ClientDataSet)vector.elementAt(0);
            Timestamp timestamp = (Timestamp)vector.elementAt(1);
            Timestamp timestamp2 = (Timestamp)vector.elementAt(2);
            Color color = (Color)vector.elementAt(3);
            Vector vector2 = clientDataSet.getRowsOfDataVector(timestamp, timestamp2);
            int[] nArray = new int[vector2.size()];
            int[] nArray2 = new int[vector2.size()];
            int n5 = 0;
            while (n5 < vector2.size()) {
                Vector vector3 = (Vector)vector2.elementAt(n5);
                Timestamp timestamp3 = (Timestamp)vector3.elementAt(0);
                double d = Double.parseDouble(vector3.elementAt(1).toString());
                long l = ((Date)timestamp3).getTime();
                long l2 = (l - this.timeMin) * (long)(n3 - n) / (this.timeMax - this.timeMin) + (long)n;
                nArray[n5] = (int)l2;
                nArray2[n5] = (int)((double)(n4 - n2) * (this.valueMax - d) / (this.valueMax - this.valueMin) + (double)n2);
                ++n5;
            }
            graphics.setColor(color);
            graphics.drawPolyline(nArray, nArray2, nArray.length);
        }
    }

    public void addToGraph(ClientDataSet clientDataSet, Timestamp timestamp, Timestamp timestamp2, Color color) {
        if (this.dataSets.size() < 5) {
            Vector<Serializable> vector = new Vector<Serializable>();
            vector.add(clientDataSet);
            vector.add(timestamp);
            vector.add(timestamp2);
            this.currentColorIndex = this.currentColorIndex < this.colorsVector.size() - 1 ? ++this.currentColorIndex : 0;
            color = (Color)this.colorsVector.elementAt(this.currentColorIndex);
            vector.add(color);
            this.dataSets.put(clientDataSet.getSqlString() + timestamp.toString() + timestamp2.toString(), vector);
            this.timeMin = Math.min(((Date)timestamp).getTime(), this.timeMin);
            this.timeMax = Math.max(((Date)timestamp2).getTime(), this.timeMax);
            this.valueMin = Math.min(clientDataSet.getValueMin(), this.valueMin);
            this.valueMax = Math.max(clientDataSet.getValueMax(), this.valueMax);
            this.roundValues();
            this.legend.addToLegend(clientDataSet.getSqlString() + timestamp.toString() + timestamp2.toString(), clientDataSet.getStationName(), color);
            this.graphDisplay.clearBuffer();
            this.drawGraph();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("drawGraph")) {
            this.drawGraph();
        }
    }
}

