/*
 * Decompiled with CFR 0.152.
 */
package iDSS.beans2;

import iDSS.disp.TabularDisplay;
import iDSS.math.Fourier;
import iDSS.tidalData.ClientDataSet;
import iDSS.tidalData.TidalModel;
import iDSS.utils.ImageRW;
import iDSS.xyGraph.Graph;
import iDSS.xyGraph.GraphicalDisplay2;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class DataManagerJBean
implements PropertyChangeListener {
    private Hashtable dataSetHashtable = new Hashtable();
    private Hashtable tidalModelsHashtable;
    private Hashtable xyGraphsHashtable = new Hashtable();
    private String currentDataSet;
    private Vector superimposeVector;
    private Vector currentRow;
    private String tidalModelKey;
    private PropertyChangeSupport pcs;

    public DataManagerJBean() {
        this.tidalModelsHashtable = new Hashtable();
        this.pcs = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setCurrentRow(Vector vector) {
        this.currentRow = vector;
    }

    public Vector getCurrentRow() {
        return this.currentRow;
    }

    public boolean addToDataSet(ClientDataSet clientDataSet) {
        boolean bl = false;
        if (!this.dataSetHashtable.containsKey(clientDataSet.getSqlString())) {
            this.dataSetHashtable.put(clientDataSet.getSqlString(), clientDataSet);
            bl = true;
        }
        return bl;
    }

    public void removeFromDataSet(String string) {
        if (this.dataSetHashtable.containsKey(string)) {
            this.dataSetHashtable.remove(string);
        }
    }

    public Hashtable getDataSets() {
        return this.dataSetHashtable;
    }

    public Hashtable getXyGraphsHashtable() {
        return this.xyGraphsHashtable;
    }

    public Hashtable getTidalModelsHashtable() {
        return this.tidalModelsHashtable;
    }

    public void setTidalModel(String string) {
        TidalModel tidalModel = (TidalModel)this.tidalModelsHashtable.get(string);
        if (tidalModel != null) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(string);
            vector.add(tidalModel);
            this.pcs.firePropertyChange("setTidalModel", null, vector);
        }
    }

    public Vector makeTidalModel(String string, Timestamp timestamp, Timestamp timestamp2, int n) {
        Vector vector = null;
        ClientDataSet clientDataSet = (ClientDataSet)this.dataSetHashtable.get(string);
        if (clientDataSet != null) {
            Serializable serializable;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            String string2 = calendar.get(1) + "/" + String.valueOf(calendar.get(2) + 1) + "/" + calendar.get(5);
            calendar.setTime(timestamp2);
            String string3 = calendar.get(1) + "/" + String.valueOf(calendar.get(2) + 1) + "/" + calendar.get(5);
            String string4 = clientDataSet.getStationName() + "," + string2 + "-" + string3 + "," + n;
            Vector vector2 = clientDataSet.getColumnsOfDataVector(timestamp, timestamp2);
            Vector vector3 = (Vector)vector2.elementAt(0);
            Fourier fourier = new Fourier(vector2, n);
            Vector<String> vector4 = new Vector<String>();
            vector4.add("Date/Time");
            vector4.add("Computed Observation");
            Vector vector5 = new Vector();
            int n2 = 0;
            while (n2 < vector3.size()) {
                serializable = (Timestamp)vector3.elementAt(n2);
                long l = ((Date)serializable).getTime();
                double d = l;
                double d2 = fourier.getComputedY(d);
                Vector<Comparable<Date>> vector6 = new Vector<Comparable<Date>>();
                vector6.add((Comparable<Date>)((Object)serializable));
                vector6.add(new Double(d2));
                vector5.add(vector6);
                ++n2;
            }
            serializable = new ClientDataSet(string4, "x:" + clientDataSet.getStationName() + ":" + n, timestamp, timestamp2, vector4, vector5);
            this.addToDataSet((ClientDataSet)serializable);
            TidalModel tidalModel = new TidalModel(fourier.getFourierA(), fourier.getFourierB(), fourier.getFourierC(), fourier.getFourierIterations(), clientDataSet.getStationName(), timestamp, timestamp2, fourier.getFourierPeriod());
            this.tidalModelsHashtable.put(string4, tidalModel);
            vector = ((ClientDataSet)serializable).getDataSetVector();
        }
        return vector;
    }

    public TidalModel getTidalModel(String string) {
        TidalModel tidalModel = (TidalModel)this.tidalModelsHashtable.get(string);
        return tidalModel;
    }

    public TabularDisplay getTable(String string, Timestamp timestamp, Timestamp timestamp2) {
        ClientDataSet clientDataSet = (ClientDataSet)this.dataSetHashtable.get(string);
        TabularDisplay tabularDisplay = null;
        if (clientDataSet != null) {
            tabularDisplay = clientDataSet.makeTable(timestamp, timestamp2);
        }
        return tabularDisplay;
    }

    public Vector getTableRowsVector(String string, Timestamp timestamp, Timestamp timestamp2) {
        ClientDataSet clientDataSet = (ClientDataSet)this.dataSetHashtable.get(string);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (clientDataSet != null) {
            vector = clientDataSet.getRowsOfDataVector(timestamp, timestamp2);
            vector2 = clientDataSet.getColumnNamesVector();
        }
        Vector<Vector> vector3 = new Vector<Vector>();
        vector3.add(vector2);
        vector3.add(vector);
        return vector3;
    }

    public GraphicalDisplay2 drawXYGraph(String string, String string2, Timestamp timestamp, Timestamp timestamp2, String string3) {
        ClientDataSet clientDataSet = (ClientDataSet)this.dataSetHashtable.get(string);
        Graph graph = null;
        GraphicalDisplay2 graphicalDisplay2 = null;
        Graph graph2 = (Graph)this.xyGraphsHashtable.get(string3);
        if (clientDataSet != null && (graph = clientDataSet.drawXYGraph(string2, timestamp, timestamp2, graph2)) != null) {
            this.xyGraphsHashtable.put(string2, graph);
            graphicalDisplay2 = graph.getDisplay();
        }
        return graphicalDisplay2;
    }

    public Vector getXYGraphImg(String string, String string2, Timestamp timestamp, Timestamp timestamp2, String string3) {
        Object object;
        Vector vector = new Vector();
        ClientDataSet clientDataSet = (ClientDataSet)this.dataSetHashtable.get(string);
        Graph graph = null;
        GraphicalDisplay2 graphicalDisplay2 = null;
        Graph graph2 = null;
        if (string3 != null && string3 != "None" && (object = this.xyGraphsHashtable.get(string3)) instanceof Graph) {
            graph2 = (Graph)object;
        }
        if (clientDataSet != null) {
            graph = clientDataSet.drawXYGraph(string2, timestamp, timestamp2, graph2);
            if (graph != null) {
                this.xyGraphsHashtable.put(string2, graph);
                graphicalDisplay2 = graph.getDisplay();
                object = graphicalDisplay2.getCanvas();
                vector = ImageRW.writeImgFile(object);
                vector.add(string2);
            } else if (graph2 != null) {
                graphicalDisplay2 = graph2.getDisplay();
                object = graphicalDisplay2.getCanvas();
                vector = ImageRW.writeImgFile(object);
                vector.add(string2);
            }
        }
        return vector;
    }

    public BufferedImage getXYGraphImg2(String string, String string2, Timestamp timestamp, Timestamp timestamp2, String string3) {
        Object v;
        BufferedImage bufferedImage = null;
        ClientDataSet clientDataSet = (ClientDataSet)this.dataSetHashtable.get(string);
        Graph graph = null;
        GraphicalDisplay2 graphicalDisplay2 = null;
        Graph graph2 = null;
        if (string3 != null && string3 != "None" && (v = this.xyGraphsHashtable.get(string3)) instanceof Graph) {
            graph2 = (Graph)v;
        }
        if (clientDataSet != null) {
            graph = clientDataSet.drawXYGraph(string2, timestamp, timestamp2, graph2);
            if (graph != null) {
                this.xyGraphsHashtable.put(string2, graph);
                graphicalDisplay2 = graph.getDisplay();
                bufferedImage = graphicalDisplay2.getCanvas();
            } else if (graph2 != null) {
                graphicalDisplay2 = graph2.getDisplay();
                bufferedImage = graphicalDisplay2.getCanvas();
            }
        }
        return bufferedImage;
    }

    public boolean containsSql(String string) {
        boolean bl = this.dataSetHashtable.containsKey(string);
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ClientDataSet clientDataSet;
        if (propertyChangeEvent.getPropertyName().equals("tidalData") && (clientDataSet = (ClientDataSet)propertyChangeEvent.getNewValue()) != null) {
            this.addToDataSet(clientDataSet);
        }
    }
}

