/*
 * Decompiled with CFR 0.152.
 */
package iDSS.beans2;

import iDSS.beans.GridsJBean;
import iDSS.disp.ImageDisplay;
import iDSS.gridDisp.GridDisplay;
import iDSS.gridDisp.SurfaceColor;
import iDSS.grids.Grid;
import iDSS.utils.DebugWriter;
import iDSS.utils.FileNameDialog;
import iDSS.utils.IDSSAppConstants;
import iDSS.utils.ImageRW;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GridManagerJBean {
    private Hashtable gridsHashtable;
    private String currentFileName;
    private String currentName;
    private File currentFile;
    private Grid currentGrid;
    private Vector currentRow;
    private PropertyChangeSupport pcs;
    private String title = "modelSetupDemRemote";
    private int gridType = 1;
    private String serverGridTable = "userGridsTable";
    private String hashCode = "demGridName";
    private String ejbName = "GridsEJB";

    public GridManagerJBean() {
        if (IDSSAppConstants.debug) {
            System.out.println("GridManagerJBean.GridManagerJBean(), serverGridTable : " + this.serverGridTable);
        }
        this.pcs = new PropertyChangeSupport(this);
        this.gridsHashtable = new Hashtable();
    }

    public Hashtable getGrids() {
        return this.gridsHashtable;
    }

    public void setCurrentFileName(String string) {
        if (string != null) {
            this.currentFileName = string;
            this.currentFile = new File(this.currentFileName);
            this.currentGrid = (Grid)this.gridsHashtable.get(this.currentFileName);
            this.currentName = this.currentGrid.getName();
            this.currentRow = new Vector();
            this.currentRow.add(this.currentName);
            this.currentRow.add(this.currentFileName);
        } else {
            this.currentFileName = null;
            this.currentFile = null;
            this.currentGrid = null;
            this.currentName = null;
            this.currentRow = null;
        }
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public void addToGrids(Grid grid) {
        if (grid != null) {
            if (this.gridsHashtable.containsKey(grid.getFileName())) {
                this.currentFileName = grid.getFileName();
                this.removeFromGrids();
            }
            this.gridsHashtable.put(grid.getFileName(), grid);
            Vector<String> vector = new Vector<String>();
            vector.add(grid.getName());
            vector.add(grid.getFileName());
            this.pcs.firePropertyChange("GridManagerAddToGrids", null, vector);
        }
    }

    public void removeFromGrids() {
        this.gridsHashtable.remove(this.currentFileName);
        Vector<String> vector = new Vector<String>();
        vector.add(this.currentGrid.getName());
        vector.add(this.currentGrid.getFileName());
        this.pcs.firePropertyChange("GridManagerRemoveFromGrids", null, vector);
    }

    public void pickGrid() {
        File file = FileNameDialog.getInputFileName(this.title, null, null);
        if (file != null) {
            Grid grid = new Grid(file.toString(), this.gridType, 0, file);
            if (!grid.isRead()) {
                grid.read();
            }
            this.addToGrids(grid);
        }
    }

    public void pickGrid(File file) {
        if (file != null) {
            Grid grid = new Grid(file.toString(), this.gridType, 0, file);
            if (!grid.isRead()) {
                grid.read();
            }
            this.addToGrids(grid);
        }
    }

    public String pickGrid(String string) {
        String string2 = "Failed to read from " + string;
        try {
            File file;
            if (string != null && (file = new File(string)) != null) {
                Grid grid = new Grid(file.toString(), this.gridType, 0, file);
                if (!grid.isRead()) {
                    grid.read();
                }
                this.addToGrids(grid);
                string2 = "Read successfully from " + string;
            }
        }
        catch (NullPointerException nullPointerException) {
            String string3 = "GridManagerJBean.pickGrid(String), fileName : " + string + ", " + nullPointerException.toString();
            Vector<Object> vector = new Vector<Object>();
            vector.add("Can't read grid from file");
            vector.add(string3);
            vector.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector);
        }
        return string2;
    }

    public void describe() {
        this.currentGrid = (Grid)this.gridsHashtable.get(this.currentFileName);
        if (!this.currentGrid.isRead()) {
            this.currentGrid.read();
        }
        Vector vector = this.currentGrid.showdescription();
        this.pcs.firePropertyChange("GridManagerGridDesc", null, vector);
    }

    public void saveToServer() {
        GridsJBean gridsJBean = new GridsJBean();
        gridsJBean.setEjbName(this.ejbName, this.serverGridTable);
        this.currentGrid = (Grid)this.gridsHashtable.get(this.currentFileName);
        if (this.currentGrid != null) {
            gridsJBean.saveOnServer(this.currentGrid, "130.159.78.177", this.currentFileName);
        }
    }

    public void pickFromServer() {
        GridsJBean gridsJBean = new GridsJBean();
        gridsJBean.setEjbName(this.ejbName, this.serverGridTable);
        Collection collection = gridsJBean.findAll();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Grid grid = (Grid)iterator.next();
                grid.setType(this.gridType);
                this.addToGrids(grid);
            }
        }
    }

    public void selectGrid() {
        this.currentGrid = (Grid)this.gridsHashtable.get(this.currentFileName);
        if (this.currentGrid != null) {
            System.out.println("GridManagerJBean.selectGrid(), currentGrid not null");
            System.out.println("currentGrid.getName() : " + this.currentGrid.getName());
            Vector<Object> vector = new Vector<Object>();
            vector.add(this.hashCode);
            vector.add(this.currentGrid);
            this.pcs.firePropertyChange("addGridToModel", null, vector);
        } else if (IDSSAppConstants.debug) {
            DebugWriter.writeDebug("GridManagerJBean.selectGrid(), currentGrid = null");
            System.out.println("GridManagerJBean.selectGrid(), currentGrid = null");
        }
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        this.currentGrid = (Grid)this.gridsHashtable.get(this.currentFileName);
        if (this.currentGrid != null) {
            if (!this.currentGrid.isRead()) {
                this.currentGrid.read();
            }
            SurfaceColor surfaceColor = new SurfaceColor(this.currentGrid.getName(), this.currentGrid.getZMin(), this.currentGrid.getZMax(), SurfaceColor.DEM);
            bufferedImage = this.currentGrid.getImage(surfaceColor);
        }
        return bufferedImage;
    }

    public void drawGrid() {
        if (IDSSAppConstants.debug) {
            System.out.println("GridManagerJBean.drawGrid(), file : " + this.currentFileName);
        }
        this.currentGrid = (Grid)this.gridsHashtable.get(this.currentFileName);
        if (!this.currentGrid.isRead()) {
            this.currentGrid.read();
        }
        SurfaceColor surfaceColor = new SurfaceColor(this.currentGrid.getName(), this.currentGrid.getZMin(), this.currentGrid.getZMax(), SurfaceColor.DEM);
        GridDisplay gridDisplay = new GridDisplay(this.currentGrid.getName());
        this.currentGrid.draw(gridDisplay, surfaceColor);
        this.pcs.firePropertyChange("GridManagerGridDisp", null, gridDisplay);
        ImageDisplay imageDisplay = new ImageDisplay(this.currentGrid.getName() + ":Legend", surfaceColor.getLegendWidth(), surfaceColor.getLegendHeight());
        this.pcs.firePropertyChange("GridManagerImgDisp", null, imageDisplay);
        surfaceColor.drawLegend(imageDisplay);
    }

    private Vector makeImageAndLegend() {
        this.currentGrid = (Grid)this.gridsHashtable.get(this.currentFileName);
        Vector<BufferedImage> vector = new Vector<BufferedImage>();
        if (this.currentGrid != null) {
            if (!this.currentGrid.isRead()) {
                this.currentGrid.read();
            }
            SurfaceColor surfaceColor = new SurfaceColor(this.currentGrid.getName(), this.currentGrid.getZMin(), this.currentGrid.getZMax(), SurfaceColor.DEM);
            BufferedImage bufferedImage = this.currentGrid.getImage(surfaceColor);
            ImageDisplay imageDisplay = new ImageDisplay(this.currentGrid.getName() + ":Legend", surfaceColor.getLegendWidth(), surfaceColor.getLegendHeight());
            BufferedImage bufferedImage2 = surfaceColor.getImage(imageDisplay);
            vector.add(bufferedImage);
            vector.add(bufferedImage2);
        }
        return vector;
    }

    public Vector drawGridImg() {
        Vector vector = this.makeImageAndLegend();
        Vector<Vector> vector2 = new Vector<Vector>();
        if (vector != null) {
            Vector vector3;
            BufferedImage bufferedImage;
            if (vector.size() > 0) {
                bufferedImage = (BufferedImage)vector.elementAt(0);
                bufferedImage = ImageRW.scaleImage(bufferedImage);
                vector3 = ImageRW.writeImgFile(bufferedImage);
                vector3.add(this.currentGrid.getName());
                vector2.add(vector3);
            }
            if (vector.size() > 1) {
                bufferedImage = (BufferedImage)vector.elementAt(1);
                vector3 = ImageRW.writeImgFile(bufferedImage);
                vector3.add(this.currentGrid.getName() + ":Legend");
                vector2.add(vector3);
            }
        }
        return vector2;
    }

    public BufferedImage getImageAndLegend() {
        int n = 50;
        BufferedImage bufferedImage = null;
        Vector vector = this.makeImageAndLegend();
        BufferedImage bufferedImage2 = null;
        BufferedImage bufferedImage3 = null;
        if (vector != null) {
            int n2 = 0;
            int n3 = 0;
            if (vector.size() > 0) {
                bufferedImage2 = (BufferedImage)vector.elementAt(0);
                bufferedImage2 = ImageRW.scaleImage(bufferedImage2);
                n2 += bufferedImage2.getWidth();
                n3 = Math.max(n3, bufferedImage2.getHeight() + n);
            }
            if (vector.size() > 1) {
                bufferedImage3 = (BufferedImage)vector.elementAt(1);
                n2 = n2 + bufferedImage3.getWidth() + 5;
                n3 = Math.max(n3, bufferedImage3.getHeight());
            }
            bufferedImage = new BufferedImage(n2, n3, 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n2, n3);
            graphics.setColor(Color.black);
            graphics.drawImage(bufferedImage2, 0, n, null);
            graphics.drawImage(bufferedImage3, bufferedImage2.getWidth() + 5, 0, null);
        }
        return bufferedImage;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return "GridManagerJBean";
    }
}

