/*
 * Decompiled with CFR 0.152.
 */
package iDSS.beans2;

import iDSS.grids.Grid;
import iDSS.grids.LCGrid2;
import iDSS.tidalData.ClientDataSet;
import iDSS.tidalData.TidalModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimulationJBean
implements PropertyChangeListener {
    private Thread simulationThread;
    private Grid demGrid;
    private LCGrid2 lcGrid2;
    private Hashtable tidalModelHashtable;
    private String simulationName;
    private File saveLocationDir;
    private int simulateUntil;
    private int timestepMinutes;
    private int resultsTimestepYears;
    private int isostaticMovement;
    private ClientDataSet slrDataSet;
    private boolean viewFG;
    private boolean saveFG;
    private boolean viewDD;
    private boolean saveDD;
    private Vector floodStartVector;
    private int currentYear;
    private int currentMonth;
    private int currentDate;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setDem(Grid grid) {
        if (grid != null) {
            this.demGrid = grid;
        }
    }

    public Grid getDem() {
        return this.demGrid;
    }

    public void setLcGrid2(LCGrid2 lCGrid2) {
        if (lCGrid2 != null) {
            this.lcGrid2 = lCGrid2;
        }
    }

    public LCGrid2 getLcGrid2() {
        return this.lcGrid2;
    }

    public void setTidalModelHashtable(Hashtable hashtable) {
        if (hashtable != null) {
            this.tidalModelHashtable = hashtable;
            Enumeration enumeration = this.tidalModelHashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                TidalModel tidalModel = (TidalModel)this.tidalModelHashtable.get(string);
                int n = tidalModel.getWeightage();
                System.out.println("In SimulationJBean.run()");
                System.out.println(string + ", " + n);
            }
        }
    }

    public Hashtable getTidalModelHashtable() {
        return this.tidalModelHashtable;
    }

    public Vector getSimUntilYears() {
        Vector<Integer> vector = new Vector<Integer>();
        if (this.tidalModelHashtable != null) {
            int n = 1999;
            int n2 = 1900;
            Enumeration enumeration = this.tidalModelHashtable.elements();
            while (enumeration.hasMoreElements()) {
                TidalModel tidalModel = (TidalModel)enumeration.nextElement();
                Timestamp timestamp = tidalModel.getBasisStart();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timestamp);
                int n3 = calendar.get(1);
                if (n3 >= n2) continue;
                n2 = n3;
            }
            if (n < n2) {
                n = n2;
            }
            while (n < 2100) {
                vector.add(new Integer(++n));
            }
        } else {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add("Error");
            vector2.add("No tidalModelHashtable defined in SimulationJBean");
            vector2.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector2);
        }
        return vector;
    }

    public void setIsostaticMovement(int n) {
        this.isostaticMovement = n;
    }

    public int getIsostaticMovement() {
        return this.isostaticMovement;
    }

    public void setSlrDataSet(ClientDataSet clientDataSet) {
        this.slrDataSet = clientDataSet;
    }

    public ClientDataSet getSlrDataSet() {
        return this.slrDataSet;
    }

    public void setViewFG(boolean bl) {
        this.viewFG = bl;
    }

    public boolean getViewFG() {
        return this.viewFG;
    }

    public void setSaveFG(boolean bl) {
        this.saveFG = bl;
    }

    public boolean getSaveFG() {
        return this.saveFG;
    }

    public void setViewDD(boolean bl) {
        this.viewDD = bl;
    }

    public boolean getViewDD() {
        return this.viewDD;
    }

    public void setSaveDD(boolean bl) {
        this.saveDD = bl;
    }

    public boolean getSaveDD() {
        return this.saveDD;
    }

    public void setSaveLocationDir(File file) {
        if (file != null) {
            this.saveLocationDir = file;
        }
    }

    public File getSaveLocationDir() {
        return this.saveLocationDir;
    }

    public void setSimulationName(String string) {
        System.out.println("SimulationJBean.setSimulationName(), simulationName : " + string);
        if (string != null) {
            this.simulationName = string.trim();
        }
    }

    public String getSimulationName() {
        return this.simulationName;
    }

    public void setTimestepMinutes(int n) {
        this.timestepMinutes = n;
    }

    public int getTimestepMinutes() {
        return this.timestepMinutes;
    }

    public void setResultsTimestepYears(int n) {
        this.resultsTimestepYears = n;
    }

    public int getResultsTimestepYears() {
        return this.resultsTimestepYears;
    }

    public void setFloodStartVector(Vector vector) {
        if (vector != null) {
            this.floodStartVector = vector;
        }
    }

    public void setFloodStartVector(String string) {
        this.floodStartVector = this.getCoords(string);
        if (this.floodStartVector.size() == 0) {
            Vector<Object> vector = new Vector<Object>();
            vector.add("Missing flood start points");
            vector.add("Flood start points not specified");
            vector.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector);
        }
    }

    public Vector getFloodStartVector() {
        return this.floodStartVector;
    }

    public void setSimulateUntil(int n) {
        this.simulateUntil = n;
    }

    public int getSimulateUntil() {
        return this.simulateUntil;
    }

    public boolean validateInput() {
        Vector<String> vector;
        System.out.println("SimulationJBean.validateInput(), Validating input for simulation");
        boolean bl = true;
        if (this.simulationName.length() < 1) {
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add("Missing simulation name");
            vector2.add("Simulation name is not defined");
            vector2.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector2);
            bl = false;
            return bl;
        }
        if (this.timestepMinutes <= 0) {
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add("Time step error");
            vector3.add("Time step must be a positive non-zero integer");
            vector3.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector3);
            bl = false;
            return bl;
        }
        if (this.resultsTimestepYears <= 0) {
            Vector<Object> vector4 = new Vector<Object>();
            vector4.add("Results time step error");
            vector4.add("Results time step must be a positive non-zero integer");
            vector4.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector4);
            bl = false;
            return bl;
        }
        if (this.tidalModelHashtable.size() <= 0) {
            Vector<Object> vector5 = new Vector<Object>();
            vector5.add("No tidal model error");
            vector5.add("No tidal model selected");
            vector5.add(new Integer(0));
            this.pcs.firePropertyChange("showMessage", null, vector5);
            bl = false;
            return bl;
        }
        System.out.println("TidalModelHashtable : " + this.tidalModelHashtable.size());
        Enumeration enumeration = this.tidalModelHashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector = (String)enumeration.nextElement();
            TidalModel tidalModel = (TidalModel)this.tidalModelHashtable.get(vector);
            int n = tidalModel.getWeightage();
            System.out.println(vector + ", " + n);
        }
        if (this.slrDataSet == null) {
            vector = new Vector();
            vector.add("SLR scenario error");
            vector.add("No sea level rise scenario selected");
            vector.add((String)((Object)new Integer(0)));
            this.pcs.firePropertyChange("showMessage", null, vector);
            bl = false;
            return bl;
        }
        if (this.floodStartVector.size() <= 0) {
            vector = new Vector<String>();
            vector.add("Flood start point error");
            vector.add("No flood start point specified");
            vector.add((String)((Object)new Integer(0)));
            this.pcs.firePropertyChange("showMessage", null, vector);
            bl = false;
            return bl;
        }
        System.out.println("SimulationJBean.validateInput()");
        System.out.println("Simulation name      : " + this.simulationName);
        System.out.println("Simulate until       : " + this.simulateUntil);
        System.out.println("Simulation time step : " + this.timestepMinutes);
        System.out.println("Results time step    : " + this.resultsTimestepYears);
        System.out.println("View Flood Grid      : " + this.viewFG);
        System.out.println("Save Flood Grid      : " + this.saveFG);
        System.out.println("View Depth Duration  : " + this.viewDD);
        System.out.println("Save Depth Duration  : " + this.saveDD);
        return bl;
    }

    private Vector getCoords(String string) {
        Vector vector = new Vector();
        if (string != null) {
            if (string.length() <= 0) {
                return vector;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,");
            Vector<Double> vector2 = new Vector<Double>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                double d = 0.0;
                try {
                    d = Double.parseDouble(string2);
                    vector2.add(new Double(d));
                }
                catch (NumberFormatException numberFormatException) {
                    Vector<Object> vector3 = new Vector<Object>();
                    vector3.add("Flood start coords error");
                    vector3.add("Flood coord not a number" + numberFormatException.toString());
                    vector3.add(new Integer(0));
                    this.pcs.firePropertyChange("showMessage", null, vector3);
                }
            }
            int n = vector2.size() / 2;
            int n2 = 0;
            while (n2 < n) {
                Vector vector4 = new Vector();
                vector4.add(vector2.elementAt(n2 * 2));
                vector4.add(vector2.elementAt(n2 * 2 + 1));
                vector.add(vector4);
                ++n2;
            }
        }
        return vector;
    }

    public void setStatus(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        this.currentYear = calendar.get(1);
        this.currentMonth = calendar.get(2);
        this.currentDate = calendar.get(5);
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public int getCurrentMonth() {
        return this.currentMonth;
    }

    public int getCurrentDate() {
        return this.currentDate;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("setSimulationStatus")) {
            Timestamp timestamp = (Timestamp)propertyChangeEvent.getNewValue();
            this.setStatus(timestamp);
        }
    }
}

