/*
 * Decompiled with CFR 0.152.
 */
package iDSS.sim;

import iDSS.beans2.SimulationJBean;
import iDSS.disp.DisplayFrame;
import iDSS.gView.GridViewControl;
import iDSS.grids.Grid;
import iDSS.grids.LCGrid2;
import iDSS.sim.SimulationRun;
import iDSS.tidalData.ClientDataSet;
import iDSS.utils.FileNameDialog;
import iDSS.utils.MessageHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Simulation
extends DisplayFrame
implements ActionListener,
Runnable,
PropertyChangeListener {
    private JTextField nameTextField;
    private JTextField simulateUntilTextField;
    private JTextField timestepTextField;
    private JTextField resultsTimestepTextField;
    private JComboBox simulateUntilCombo;
    private JComboBox timestepUnitsCombo;
    private JComboBox resultsTimestepUnitCombo;
    private JButton seawallButton;
    private JButton startSimulationButton;
    private JLabel nameLabel;
    private JLabel simulateUntilLabel;
    private JLabel timestepLabel;
    private JLabel resultsTimestepLabel;
    private Thread simulationThread;
    private JLabel viewFloodGridLabel;
    private JLabel saveFloodGridLabel;
    private JLabel viewDDGraphLabel;
    private JLabel saveDDGraphLabel;
    private JLabel currentYearLabel;
    private JLabel currentMonthLabel;
    private JLabel currentDayLabel;
    private JLabel percentProgressLabel;
    private JTextField currentYearTextField;
    private JTextField currentMonthTextField;
    private JTextField currentDayTextField;
    private JTextField percentProgressTextField;
    private JTextField coordsTextField;
    private JCheckBox viewFloodGridCB;
    private JCheckBox saveFloodGridCB;
    private JCheckBox viewDDGraphCB;
    private JCheckBox saveDDGraphCB;
    private JPanel namePanel;
    private JPanel simulateUntilPanel;
    private JPanel timestepPanel;
    private JPanel statusTimestepPanel;
    private JPanel statusPanel;
    private JPanel forEachTimestepPanel;
    private JPanel startButtonpanel;
    private JPanel coordsPanel;
    private String simulationName;
    private String saveLocationName;
    private JButton viewSummaryGridsButton;
    private JButton viewFloodGridsButton;
    private SimulationJBean simulationJBean = new SimulationJBean();

    public Simulation(Grid grid, LCGrid2 lCGrid2, Hashtable hashtable, int n, ClientDataSet clientDataSet) {
        super("Simulation Panel", false, false, false, true, null);
        this.simulationJBean.addPropertyChangeListener(this);
        this.simulationJBean.setDem(grid);
        this.simulationJBean.setLcGrid2(lCGrid2);
        this.simulationJBean.setTidalModelHashtable(hashtable);
        this.simulationJBean.setIsostaticMovement(n);
        this.simulationJBean.setSlrDataSet(clientDataSet);
    }

    public void run() {
        this.nameLabel = new JLabel("Name of simulation:");
        this.nameTextField = new JTextField(20);
        this.namePanel = new JPanel();
        this.namePanel.setLayout(new FlowLayout(0));
        this.namePanel.add(this.nameLabel);
        this.namePanel.add(this.nameTextField);
        this.simulateUntilLabel = new JLabel("Simulate until: ");
        this.simulateUntilCombo = new JComboBox(this.simulationJBean.getSimUntilYears());
        this.simulateUntilCombo.setPreferredSize(new Dimension(5, 5));
        this.seawallButton = new JButton("Add/Edit Seawall");
        this.simulateUntilPanel = new JPanel();
        this.simulateUntilPanel.setLayout(new BoxLayout(this.simulateUntilPanel, 0));
        this.simulateUntilPanel.add(this.simulateUntilLabel);
        this.simulateUntilPanel.add(this.simulateUntilCombo);
        this.simulateUntilPanel.add(Box.createHorizontalGlue());
        this.simulateUntilPanel.add(this.seawallButton);
        this.timestepLabel = new JLabel("Time step: ");
        this.timestepTextField = new JTextField(3);
        String[] stringArray = new String[]{"Hours", "Minutes"};
        this.timestepUnitsCombo = new JComboBox<String>(stringArray);
        this.resultsTimestepLabel = new JLabel("Results every ");
        this.resultsTimestepTextField = new JTextField(3);
        String[] stringArray2 = new String[]{"Years"};
        this.resultsTimestepUnitCombo = new JComboBox<String>(stringArray2);
        this.timestepPanel = new JPanel();
        this.timestepPanel.setLayout(new BoxLayout(this.timestepPanel, 0));
        this.timestepPanel.add(this.timestepLabel);
        this.timestepPanel.add(this.timestepTextField);
        this.timestepPanel.add(this.timestepUnitsCombo);
        this.timestepPanel.add(Box.createHorizontalStrut(10));
        this.timestepPanel.add(this.resultsTimestepLabel);
        this.timestepPanel.add(this.resultsTimestepTextField);
        this.timestepPanel.add(this.resultsTimestepUnitCombo);
        this.currentYearLabel = new JLabel("Current Year");
        this.currentMonthLabel = new JLabel("Current Month");
        this.currentDayLabel = new JLabel("Current Day");
        this.percentProgressLabel = new JLabel("% Progress");
        this.currentYearTextField = new JTextField();
        this.currentMonthTextField = new JTextField();
        this.currentDayTextField = new JTextField();
        this.percentProgressTextField = new JTextField();
        this.currentYearTextField.setEditable(false);
        this.currentMonthTextField.setEditable(false);
        this.currentDayTextField.setEditable(false);
        this.percentProgressTextField.setEditable(false);
        this.statusPanel = new JPanel();
        this.statusPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Simulation status"));
        this.statusPanel.setLayout(new GridLayout(4, 2));
        this.statusPanel.add(this.currentYearLabel);
        this.statusPanel.add(this.currentYearTextField);
        this.statusPanel.add(this.currentMonthLabel);
        this.statusPanel.add(this.currentMonthTextField);
        this.statusPanel.add(this.currentDayLabel);
        this.statusPanel.add(this.currentDayTextField);
        this.statusPanel.add(this.percentProgressLabel);
        this.statusPanel.add(this.percentProgressTextField);
        this.viewFloodGridLabel = new JLabel("View flood grid:");
        this.saveFloodGridLabel = new JLabel("Save flood grid:");
        this.viewDDGraphLabel = new JLabel("View depth-duration graph:");
        this.saveDDGraphLabel = new JLabel("Save depth-duration graph:");
        this.viewFloodGridCB = new JCheckBox();
        this.saveFloodGridCB = new JCheckBox();
        this.viewDDGraphCB = new JCheckBox();
        this.saveDDGraphCB = new JCheckBox();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel.add(this.viewFloodGridLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.viewFloodGridCB);
        jPanel2.add(this.saveFloodGridLabel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.saveFloodGridCB);
        jPanel3.add(this.viewDDGraphLabel);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.viewDDGraphCB);
        jPanel4.add(this.saveDDGraphLabel);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.saveDDGraphCB);
        this.forEachTimestepPanel = new JPanel();
        this.forEachTimestepPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "For each result"));
        this.forEachTimestepPanel.setLayout(new GridLayout(4, 1));
        this.forEachTimestepPanel.add(jPanel);
        this.forEachTimestepPanel.add(jPanel2);
        this.forEachTimestepPanel.add(jPanel3);
        this.forEachTimestepPanel.add(jPanel4);
        this.statusTimestepPanel = new JPanel();
        this.statusTimestepPanel.setLayout(new BoxLayout(this.statusTimestepPanel, 0));
        this.statusTimestepPanel.add(this.statusPanel);
        this.statusTimestepPanel.add(Box.createHorizontalGlue());
        this.statusTimestepPanel.add(this.forEachTimestepPanel);
        this.coordsPanel = new JPanel();
        this.coordsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Flood start point(s), x,y,x,y..."));
        this.coordsTextField = new JTextField(40);
        this.coordsPanel.add(this.coordsTextField);
        this.viewSummaryGridsButton = new JButton("Summary Grids");
        this.viewFloodGridsButton = new JButton("Flood Grids");
        this.startSimulationButton = new JButton("Start Sim");
        this.viewSummaryGridsButton.setActionCommand("viewSummaryGridsButtonCommand");
        this.viewFloodGridsButton.setActionCommand("viewFloodGridsButtonCommand");
        this.startSimulationButton.setActionCommand("startSimulationButtonCommand");
        this.viewSummaryGridsButton.addActionListener(this);
        this.viewFloodGridsButton.addActionListener(this);
        this.startSimulationButton.addActionListener(this);
        this.viewSummaryGridsButton.setEnabled(true);
        this.viewFloodGridsButton.setEnabled(true);
        this.startSimulationButton.setEnabled(true);
        this.startButtonpanel = new JPanel();
        this.startButtonpanel.setLayout(new BoxLayout(this.startButtonpanel, 0));
        this.startButtonpanel.add(Box.createHorizontalGlue());
        this.startButtonpanel.add(this.viewSummaryGridsButton);
        this.startButtonpanel.add(this.viewFloodGridsButton);
        this.startButtonpanel.add(this.startSimulationButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.namePanel);
        this.getContentPane().add(this.simulateUntilPanel);
        this.getContentPane().add(this.timestepPanel);
        this.getContentPane().add(this.statusTimestepPanel);
        this.getContentPane().add(this.coordsPanel);
        this.getContentPane().add(this.startButtonpanel);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (actionEvent.getActionCommand().equals("startSimulationButtonCommand") && this.validateInput()) {
            serializable = this.getSaveLoc("Choose directory", "Choose  location for saving results");
            this.simulationJBean.setSaveLocationDir((File)serializable);
            if (this.simulationJBean.validateInput() && serializable != null) {
                SimulationRun simulationRun = new SimulationRun();
                simulationRun.setSimulationData(this.simulationJBean);
                simulationRun.removePropertyChangeListener(this);
                simulationRun.addPropertyChangeListener(this);
                this.simulationThread = new Thread(simulationRun);
                this.simulationThread.start();
            }
        }
        if (actionEvent.getActionCommand().equals("viewSummaryGridsButtonCommand")) {
            serializable = new GridViewControl(2, "Summary Grids");
            ((Component)serializable).removePropertyChangeListener(this);
            ((Container)serializable).addPropertyChangeListener(this);
            this.firePropertyChange("addToModelView", null, serializable);
            ((Component)serializable).removePropertyChangeListener(this);
            ((Container)serializable).addPropertyChangeListener(this);
        }
        if (actionEvent.getActionCommand().equals("viewFloodGridsButtonCommand")) {
            serializable = new GridViewControl(1, "Flood Grids");
            ((Component)serializable).removePropertyChangeListener(this);
            ((Container)serializable).addPropertyChangeListener(this);
            this.firePropertyChange("addToModelView", null, serializable);
            ((Component)serializable).removePropertyChangeListener(this);
            ((Container)serializable).addPropertyChangeListener(this);
        }
    }

    private boolean validateInput() {
        System.out.println("Validating input for simulation");
        boolean bl = true;
        if (this.nameTextField.getText().length() < 1) {
            JOptionPane.showMessageDialog(null, "Missing simulation name", "Simulation name error", 0);
            bl = false;
            return bl;
        }
        this.simulationJBean.setSimulationName(this.nameTextField.getText());
        String string = this.timestepTextField.getText();
        try {
            int n = Integer.parseInt(string);
            if (((String)this.timestepUnitsCombo.getSelectedItem()).equals("Hours")) {
                n *= 60;
            }
            this.simulationJBean.setTimestepMinutes(n);
            System.out.println("timestepMinutes = " + n);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException);
            JOptionPane.showMessageDialog(null, "Time step must be a positive non-zero integer", "Time step error", 0);
            bl = false;
            return bl;
        }
        String string2 = this.resultsTimestepTextField.getText();
        try {
            int n = Integer.parseInt(string2);
            this.simulationJBean.setResultsTimestepYears(n);
            System.out.println("resultsTimestepYears = " + n);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException);
            JOptionPane.showMessageDialog(null, "Results time step must be a positive non-zero integer", "Results time step error", 0);
            bl = false;
            return bl;
        }
        if (this.coordsTextField.getText().length() < 1) {
            JOptionPane.showMessageDialog(null, "Missing flood start points", "Flood start error", 0);
            bl = false;
            return bl;
        }
        this.simulationJBean.setFloodStartVector(this.coordsTextField.getText());
        this.simulationJBean.setViewFG(this.viewFloodGridCB.isSelected());
        this.simulationJBean.setSaveFG(this.saveFloodGridCB.isSelected());
        this.simulationJBean.setViewDD(this.viewDDGraphCB.isSelected());
        this.simulationJBean.setSaveDD(this.saveDDGraphCB.isSelected());
        this.simulationJBean.setSimulateUntil((Integer)this.simulateUntilCombo.getSelectedItem());
        return bl;
    }

    private File getSaveLoc(String string, String string2) {
        File file = FileNameDialog.getOutputDirectory(string, string2, null, null);
        return file;
    }

    public void setStatus(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        this.currentYearTextField.setText(String.valueOf(n));
        this.currentMonthTextField.setText(String.valueOf(n2 + 1));
        this.currentDayTextField.setText(String.valueOf(n3));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("setSimulationStatus")) {
            Timestamp timestamp = (Timestamp)propertyChangeEvent.getNewValue();
            this.setStatus(timestamp);
            this.simulationJBean.setStatus(timestamp);
        }
        if (propertyChangeEvent.getPropertyName().equals("addToModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("removeFromModelView")) {
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("notifySimulationEnd")) {
            this.viewSummaryGridsButton.setEnabled(true);
            this.viewFloodGridsButton.setEnabled(true);
        }
        if (propertyChangeEvent.getPropertyName().equals("showMessage")) {
            MessageHandler.showMessage((Vector)propertyChangeEvent.getNewValue());
        }
    }

    public String toString() {
        return "Simulation Panel window";
    }
}

