/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.ee.ActivationIDL.Server;
import com.sun.corba.ee.ActivationIDL.ServerHeldDown;
import com.sun.corba.ee.internal.Activation.ServerMain;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;

public class ServerTableEntry {
    private static final int DE_ACTIVATED = 0;
    private static final int ACTIVATING = 1;
    private static final int ACTIVATED = 2;
    private static final int RUNNING = 3;
    private static final int HELD_DOWN = 4;
    private static final long waitTime = 2000L;
    private static final int ActivationRetryMax = 5;
    private int state;
    private int serverId;
    private short serverPort;
    private Server serverObj;
    private ServerDef serverDef;
    private Process process;
    private int activateRetryCount = 0;
    private String activationCmd;
    private static String javaHome = System.getProperty("java.home");
    private static String classPath = System.getProperty("java.class.path");
    private static String fileSep = System.getProperty("file.separator");
    private static String pathSep = System.getProperty("path.separator");
    private boolean debug = false;

    ServerTableEntry(int n2, ServerDef serverDef, short s2, String string, boolean bl2, boolean bl3) {
        this.serverId = n2;
        this.serverDef = serverDef;
        this.debug = bl3;
        this.activateRetryCount = 0;
        this.state = 1;
        this.activationCmd = String.valueOf(javaHome) + fileSep + "bin" + fileSep + "java " + serverDef.serverVmArgs + " " + "-Dioser=" + System.getProperty("ioser") + " " + "-Dorg.omg.CORBA.ORBInitialPort=" + s2 + " " + "-Dcom.sun.corba.ee.internal.Activation.DbDir=" + string + " " + "-Dcom.sun.corba.ee.internal.POA.ORBActivated=true " + "-Dcom.sun.corba.ee.internal.POA.ORBServerId=" + n2 + " " + "-Dcom.sun.corba.ee.internal.POA.ORBServerName=" + serverDef.serverName + " " + (bl2 ? "-Dcom.sun.corba.ee.internal.Activation.ORBServerVerify=true " : "") + "-classpath " + classPath + (serverDef.serverClassPath.equals("") ? "" : pathSep) + serverDef.serverClassPath + " com.sun.corba.ee.internal.Activation.ServerMain " + serverDef.serverArgs + (bl3 ? " -debug" : "");
        if (bl3) {
            System.out.println("ServerTableEntry constructed with activation command " + this.activationCmd);
        }
    }

    synchronized void activate() throws SystemException {
        this.state = 2;
        try {
            if (this.debug) {
                this.printDebug("activate", "activating server");
            }
            this.process = Runtime.getRuntime().exec(this.activationCmd);
        }
        catch (Exception exception) {
            this.deActivate();
            if (this.debug) {
                this.printDebug("activate", "throwing premature process exit");
            }
            throw new INTERNAL(1398082492, CompletionStatus.COMPLETED_NO);
        }
    }

    synchronized void deActivate() {
        this.state = 0;
        if (this.debug) {
            this.printDebug("deActivate", "server deactivated");
        }
        this.notifyAll();
    }

    void destroy() {
        this.deActivate();
        try {
            if (this.serverObj != null) {
                this.serverObj.shutdown();
            }
            if (this.debug) {
                this.printDebug("destroy", "server shutdown successfully");
            }
        }
        catch (Exception exception) {
            if (this.debug) {
                this.printDebug("destroy", "server shutdown threw exception" + exception);
            }
            exception.printStackTrace();
        }
        try {
            if (this.process != null) {
                this.process.destroy();
            }
            if (this.debug) {
                this.printDebug("destroy", "process destroyed successfully");
            }
        }
        catch (Exception exception) {
            if (this.debug) {
                this.printDebug("destroy", "process destroy threw exception" + exception);
            }
            exception.printStackTrace();
        }
    }

    int getPort() {
        return this.serverPort;
    }

    int getServerId() {
        return this.serverId;
    }

    synchronized void holdDown() {
        this.state = 4;
        if (this.debug) {
            this.printDebug("holdDown", "server held down");
        }
        this.notifyAll();
    }

    synchronized void install() {
        if (this.state != 3) {
            throw new INTERNAL(1398082494, CompletionStatus.COMPLETED_NO);
        }
        this.serverObj.install();
    }

    boolean isActive() {
        return this.state == 3 || this.state == 2;
    }

    synchronized boolean isValid() {
        if (this.state == 1 || this.state == 4) {
            if (this.debug) {
                this.printDebug("isValid", "returns true");
            }
            return true;
        }
        try {
            int n2 = this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        if (this.state == 2) {
            if (this.activateRetryCount < 5) {
                if (this.debug) {
                    this.printDebug("isValid", "reactivating server");
                }
                ++this.activateRetryCount;
                this.activate();
                return true;
            }
            if (this.debug) {
                this.printDebug("isValid", "holding server down");
            }
            this.holdDown();
            return true;
        }
        this.deActivate();
        return false;
    }

    synchronized short lookup() throws ServerHeldDown {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception exception) {}
        }
        if (this.state == 3) {
            if (this.debug) {
                this.printDebug("lookup", "returning serverPort" + this.serverPort);
            }
            return this.serverPort;
        }
        if (this.debug) {
            this.printDebug("lookup", "throwing server held down error");
        }
        throw new ServerHeldDown(this.serverId);
    }

    private void printDebug(String string, String string2) {
        System.out.println("ServerTableEntry: method  =" + string);
        System.out.println("ServerTableEntry: server  =" + this.serverId);
        System.out.println("ServerTableEntry: state   =" + this.printState());
        System.out.println("ServerTableEntry: message =" + string2);
        System.out.println();
    }

    private String printState() {
        String string = "UNKNOWN";
        switch (this.state) {
            case 0: {
                string = "DE_ACTIVATED";
                break;
            }
            case 1: {
                string = "ACTIVATING  ";
                break;
            }
            case 2: {
                string = "ACTIVATED   ";
                break;
            }
            case 3: {
                string = "RUNNING     ";
                break;
            }
            case 4: {
                string = "HELD_DOWN   ";
                break;
            }
        }
        return string;
    }

    synchronized void register(Server server) {
        if (this.state == 2) {
            this.serverObj = server;
            try {
                this.serverPort = server.getEndpoint(0);
            }
            catch (Exception exception) {}
            this.state = 3;
            this.notifyAll();
            if (this.debug) {
                this.printDebug("register", "process registered back");
            }
        } else {
            if (this.debug) {
                this.printDebug("register", "throwing premature process exit");
            }
            throw new INTERNAL(1398082491, CompletionStatus.COMPLETED_NO);
        }
    }

    public String toString() {
        return "ServerTableEntry[state=" + this.printState() + " serverId=" + this.serverId + " serverPort=" + this.serverPort + " activateRetryCount=" + this.activateRetryCount + "]";
    }

    synchronized void uninstall() {
        if (this.state != 3) {
            throw new INTERNAL(1398082494, CompletionStatus.COMPLETED_NO);
        }
        this.serverObj.uninstall();
    }

    public int verify() {
        try {
            this.process = Runtime.getRuntime().exec(this.activationCmd);
            int n2 = this.process.waitFor();
            if (this.debug) {
                this.printDebug("verify", "returns " + ServerMain.printResult(n2));
            }
            return n2;
        }
        catch (Exception exception) {
            if (this.debug) {
                this.printDebug("verify", "returns unknown error because of exception " + exception);
            }
            return 4;
        }
    }
}

