/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.sun.corba.ee.internal.core.ClientSubcontract;
import com.sun.corba.ee.internal.core.ServerSubcontract;

public class SubcontractRegistry {
    protected int size;
    protected ServerSubcontract[] serverRegistry;
    protected Class[] clientFactory;
    protected int defaultId;
    protected ServerSubcontract bootstrapServer = null;

    public SubcontractRegistry(int n2) {
        this(n2, 256);
    }

    public SubcontractRegistry(int n2, int n3) {
        this.size = n3;
        this.defaultId = n2;
        this.serverRegistry = new ServerSubcontract[n3];
        this.clientFactory = new Class[n3];
    }

    private static int bytesToInt(byte[] byArray, int n2) {
        int n3 = byArray[n2++] << 24 & 0xFF000000;
        int n4 = byArray[n2++] << 16 & 0xFF0000;
        int n5 = byArray[n2++] << 8 & 0xFF00;
        int n6 = byArray[n2++] & 0xFF;
        return n3 | n4 | n5 | n6;
    }

    public ClientSubcontract getClientSubcontract(byte[] byArray) {
        Class clazz = null;
        int n2 = this.defaultId;
        try {
            int n3;
            if (byArray.length >= 8 && (n3 = this.getMagic(byArray)) == -1347695874 && (n2 = this.getId(byArray)) < this.size) {
                clazz = this.clientFactory[n2];
            }
            if (clazz == null) {
                clazz = this.clientFactory[this.defaultId];
            }
            ClientSubcontract clientSubcontract = (ClientSubcontract)clazz.newInstance();
            clientSubcontract.setId(n2);
            return clientSubcontract;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getId(byte[] byArray) {
        if (byArray.length > 4) {
            return SubcontractRegistry.bytesToInt(byArray, 4);
        }
        return -1;
    }

    public int getMagic(byte[] byArray) {
        return SubcontractRegistry.bytesToInt(byArray, 0);
    }

    public int getServerId(byte[] byArray) {
        if (byArray.length > 8) {
            return SubcontractRegistry.bytesToInt(byArray, 8);
        }
        return -1;
    }

    public ServerSubcontract getServerSubcontract(int n2) {
        ServerSubcontract serverSubcontract = null;
        if (n2 < this.size) {
            serverSubcontract = this.serverRegistry[n2];
        }
        if (serverSubcontract == null) {
            return this.serverRegistry[this.defaultId];
        }
        return serverSubcontract;
    }

    public ServerSubcontract getServerSubcontract(byte[] byArray) {
        int n2;
        int n3;
        ServerSubcontract serverSubcontract = null;
        if (byArray.length == 4) {
            int n4 = this.getMagic(byArray);
            if (n4 == 1229867348 || n4 == 1414090313) {
                return this.bootstrapServer;
            }
        } else if (byArray.length >= 8 && (n3 = this.getMagic(byArray)) == -1347695874 && (n2 = this.getId(byArray)) < this.size) {
            serverSubcontract = this.serverRegistry[n2];
        }
        if (serverSubcontract == null) {
            return this.serverRegistry[this.defaultId];
        }
        return serverSubcontract;
    }

    public void registerBootstrapServer(ServerSubcontract serverSubcontract) {
        this.bootstrapServer = serverSubcontract;
    }

    public synchronized boolean registerClient(Class clazz, int n2) {
        if (n2 < this.size) {
            this.clientFactory[n2] = clazz;
            return true;
        }
        return false;
    }

    public synchronized boolean registerServer(ServerSubcontract serverSubcontract, int n2) {
        if (n2 < this.size) {
            this.serverRegistry[n2] = serverSubcontract;
            serverSubcontract.setId(n2);
            Class clazz = serverSubcontract.getClientSubcontractClass();
            if (clazz != null) {
                this.registerClient(clazz, n2);
            }
            return true;
        }
        return false;
    }
}

