/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.ServiceContexts;
import com.sun.corba.ee.internal.iiop.Message;
import com.sun.corba.ee.internal.util.Utility;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class RequestMessage
extends Message {
    protected ServiceContexts ctx;
    protected boolean responseExpected;
    protected byte[] objectKey;
    protected String operation;
    protected Principal principal;

    public RequestMessage(int n2, boolean bl2, byte[] byArray, String string, boolean bl3) {
        this(null, n2, bl2, byArray, string, null, bl3);
    }

    public RequestMessage(ServiceContexts serviceContexts, int n2, boolean bl2, byte[] byArray, String string, Principal principal, boolean bl3) {
        super(bl3);
        this.setType(0);
        this.ctx = serviceContexts;
        this.requestId = n2;
        this.responseExpected = bl2;
        this.objectKey = byArray;
        this.operation = string;
        this.principal = principal;
        if (bl3) {
            System.out.println("RequestMessage constructor completed");
        }
    }

    public RequestMessage(boolean bl2) {
        super(bl2);
        if (bl2) {
            this.dprint("RequestMessage constructor completed");
        }
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public byte[] getObjectKey() {
        return this.objectKey;
    }

    public String getOperation() {
        return this.operation;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public ServiceContexts getServiceContexts() {
        return this.ctx;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }

    public void read(org.omg.CORBA.portable.InputStream inputStream) throws SystemException {
        InputStream inputStream2;
        block9: {
            if (this.debug) {
                this.dprint("Reading service contexts from inputstream");
            }
            inputStream2 = null;
            try {
                inputStream2 = (InputStream)inputStream;
                if (this.debug) {
                    this.dprint("Stream class cast successful");
                }
            }
            catch (ClassCastException classCastException) {
                if (!this.debug) break block9;
                this.dprint("Error: could not cast input stream: it is a " + inputStream.getClass().getName());
            }
        }
        try {
            this.ctx = new ServiceContexts(inputStream2);
        }
        catch (SystemException systemException) {
            if (this.debug) {
                this.dprint("Error caught in constructing ServiceContexts: " + systemException);
                systemException.printStackTrace();
            }
            throw systemException;
        }
        if (this.debug) {
            this.dprint("Reading rest of message");
        }
        this.requestId = inputStream.read_long();
        this.responseExpected = inputStream.read_boolean();
        int n2 = inputStream.read_long();
        this.objectKey = new byte[n2];
        inputStream.read_octet_array(this.objectKey, 0, n2);
        this.operation = inputStream.read_string();
        this.principal = inputStream.read_Principal();
        if (this.debug) {
            this.dprint("Read of RequestMessage complete");
        }
    }

    public void realignAndWrite(org.omg.CORBA.portable.OutputStream outputStream, byte[] byArray, boolean bl2) {
        if (byArray.length != this.objectKey.length && bl2) {
            boolean bl3;
            boolean bl4 = (this.objectKey.length - 1) % 8 >= 4;
            boolean bl5 = bl3 = (byArray.length - 1) % 8 >= 4;
            if (bl4 != bl3) {
                this.ctx.addAlignmentPadding();
            }
        }
        this.objectKey = byArray;
        this.write(outputStream);
    }

    public void write(org.omg.CORBA.portable.OutputStream outputStream) throws SystemException {
        super.write(outputStream);
        if (this.ctx != null) {
            this.ctx.write((OutputStream)outputStream);
        } else {
            ServiceContexts.writeNullServiceContext((OutputStream)outputStream);
        }
        outputStream.write_long(this.requestId);
        outputStream.write_boolean(this.responseExpected);
        outputStream.write_long(this.objectKey.length);
        outputStream.write_octet_array(this.objectKey, 0, this.objectKey.length);
        outputStream.write_string(this.operation);
        if (this.principal != null) {
            outputStream.write_Principal(this.principal);
        } else {
            outputStream.write_long(0);
        }
    }
}

