/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.security.acl.Role;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public abstract class BundleDescriptor
extends Descriptor
implements Roles {
    private Application application;
    private transient Archivist archivist;
    private Set roles;

    void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.getRoles().addAll(bundleDescriptor.getRoles());
        this.changed();
    }

    public void addRole(Role role) {
        this.getRoles().add(role);
        this.changed();
    }

    public Application getApplication() {
        return this.application;
    }

    public Archivist getArchivist() {
        if (this.archivist == null) {
            this.archivist = this.getDefaultArchivist();
        }
        return this.archivist;
    }

    protected abstract Archivist getDefaultArchivist();

    protected Set getNamedDescriptorsFrom(JndiNameEnvironment nameEnvironment) {
        HashSet<EnvironmentProperty> namedDescriptors = new HashSet<EnvironmentProperty>();
        Iterator itr = nameEnvironment.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor resourceReference = (ResourceReferenceDescriptor)itr.next();
            namedDescriptors.add(resourceReference);
        }
        Iterator itr2 = nameEnvironment.getEjbReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)itr2.next();
            namedDescriptors.add(ejbReference);
        }
        return namedDescriptors;
    }

    protected Vector getNamedReferencePairsFrom(JndiNameEnvironment nameEnvironment) {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        Iterator itr = nameEnvironment.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor resourceReference = (ResourceReferenceDescriptor)itr.next();
            pairs.add(new NamedReferencePair((Descriptor)((Object)nameEnvironment), resourceReference));
        }
        Iterator itr2 = nameEnvironment.getEjbReferenceDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)itr2.next();
            pairs.add(new NamedReferencePair((Descriptor)((Object)nameEnvironment), ejbReference));
        }
        return pairs;
    }

    public Set getRoles() {
        if (this.roles == null) {
            this.roles = new OrderedSet();
        }
        return this.roles;
    }

    public void removeRole(Role role) {
        this.getRoles().remove(role);
        this.changed();
    }

    public void setApplication(Application a) {
        this.application = a;
    }

    public void setArchivist(Archivist archivist) {
        this.archivist = archivist;
    }

    public String toString() {
        String s2 = "Bundle Descriptor";
        s2 = String.valueOf(s2) + "\n" + super.toString();
        s2 = String.valueOf(s2) + "\n " + this.roles;
        return s2;
    }
}

