/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.Switch;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.PoolManager;
import com.sun.enterprise.resource.PoolManagerImpl;
import com.sun.enterprise.resource.ResourceException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.jts.jta.TransactionManagerImpl;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.SingleThreadModel;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class J2EETransactionManagerImpl
implements J2EETransactionManager {
    private TransactionManager tm;
    private InvocationManager invMgr;
    private PoolManager poolmgr;
    public static boolean debug = false;
    private String TX_TIMEOUT = "transaction.timeout";
    private int transactionTimeout;
    private Hashtable resourceTable;

    public J2EETransactionManagerImpl() {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: Initializing distributed TM...");
        }
        this.tm = TransactionManagerImpl.getTransactionManagerImpl();
        this.poolmgr = new PoolManagerImpl();
        this.resourceTable = new Hashtable();
        this.invMgr = Switch.getSwitch().getInvocationManager();
        ServerConfiguration sc = ServerConfiguration.getConfiguration();
        try {
            this.transactionTimeout = Integer.parseInt(sc.getProperty(this.TX_TIMEOUT));
        }
        catch (NumberFormatException numberFormatException) {}
        if (debug) {
            J2EETransactionManagerImpl.print("TM: Tx Timeout = " + this.transactionTimeout);
        }
    }

    private static void assert(boolean value) {
        if (!value) {
            Exception e10 = new Exception();
            e10.printStackTrace();
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: begin");
        }
        TransactionManager transactionManager = this.tm;
        synchronized (transactionManager) {
            this.tm.setTransactionTimeout(this.transactionTimeout);
            this.tm.begin();
        }
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        TransactionManager transactionManager = this.tm;
        synchronized (transactionManager) {
            this.tm.setTransactionTimeout(timeout);
            this.tm.begin();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: commit");
        }
        this.tm.commit();
    }

    public void componentDestroyed(Object instance) {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: componentDestroyed" + instance);
        }
        Vector v2 = this.getResourceList(instance);
        Enumeration e10 = v2.elements();
        while (e10.hasMoreElements()) {
            ResourceHandle h2 = (ResourceHandle)e10.nextElement();
            try {
                h2.getResourceAllocator().closeUserConnection(h2);
            }
            catch (ResourceException ex2) {
                if (!debug) continue;
                ex2.printStackTrace();
            }
        }
        this.resourceTable.remove(this.getInstanceKey(instance));
    }

    private void delistComponentResources(ComponentInvocation inv, boolean suspend) throws InvocationException {
        try {
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                Vector v2 = this.getResourceList(inv.getInstance());
                Enumeration e10 = v2.elements();
                int flag = 0x4000000;
                if (suspend) {
                    flag = 0x2000000;
                }
                while (e10.hasMoreElements()) {
                    ResourceHandle h2 = (ResourceHandle)e10.nextElement();
                    try {
                        this.delistResource(tran, h2, flag);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (Exception ex2) {
                        this.handleResourceError(h2, ex2, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
            ex3.printStackTrace(Log.err);
        }
    }

    public void delistComponentResources(boolean suspend) throws RemoteException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: delistComponentResources");
        }
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        try {
            this.delistComponentResources(inv, suspend);
        }
        catch (InvocationException ex2) {
            ex2.printStackTrace();
            ex2.printStackTrace(Log.err);
            throw new RemoteException("", ex2.getNestedException());
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
            ex3.printStackTrace(Log.err);
            throw new RemoteException("", ex3);
        }
    }

    public boolean delistResource(Transaction tran, ResourceHandle h2, int flag) throws IllegalStateException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: delistResource");
        }
        return tran.delistResource(h2.getXAResource(), flag);
    }

    public void enlistComponentResources() throws RemoteException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: enlistComponentResources");
        }
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        try {
            Transaction tran = this.getTransaction();
            inv.setTransaction(tran);
            this.enlistComponentResources(inv);
        }
        catch (InvocationException ex2) {
            ex2.printStackTrace();
            ex2.printStackTrace(Log.err);
            throw new RemoteException("", ex2.getNestedException());
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
            ex3.printStackTrace(Log.err);
            throw new RemoteException("", ex3);
        }
    }

    private void enlistComponentResources(ComponentInvocation inv) throws InvocationException {
        try {
            Transaction tran = inv.getTransaction();
            if (this.isTransactionActive(tran)) {
                Vector v2 = this.getResourceList(inv.getInstance());
                Enumeration e10 = v2.elements();
                while (e10.hasMoreElements()) {
                    ResourceHandle h2 = (ResourceHandle)e10.nextElement();
                    try {
                        this.enlistResource(tran, h2);
                    }
                    catch (Exception ex2) {
                        this.handleResourceError(h2, ex2, tran, inv);
                    }
                }
            }
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
            ex3.printStackTrace(Log.err);
        }
    }

    public boolean enlistResource(Transaction tran, ResourceHandle h2) throws RollbackException, IllegalStateException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: enlistResource");
        }
        XAResource res = h2.getXAResource();
        boolean result = tran.enlistResource(h2.getXAResource());
        if (result) {
            this.poolmgr.resourceEnlisted(tran, h2);
        }
        return result;
    }

    private Object getInstanceKey(Object instance) {
        Vector<Object> key = null;
        if (instance instanceof Servlet) {
            if (instance instanceof SingleThreadModel) {
                key = instance;
            } else {
                Vector<Object> pair = new Vector<Object>(2);
                pair.addElement(instance);
                pair.addElement(Thread.currentThread());
                key = pair;
            }
        } else {
            key = instance;
        }
        return key;
    }

    public PoolManager getPoolManager() {
        return this.poolmgr;
    }

    private Vector getResourceList(Object instance) {
        Object key = this.getInstanceKey(instance);
        Vector v2 = (Vector)this.resourceTable.get(key);
        if (v2 == null) {
            v2 = new Vector();
            this.resourceTable.put(key, v2);
        }
        return v2;
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }

    private void handleResourceError(ResourceHandle h2, Exception ex2, Transaction tran, ComponentInvocation inv) {
        Object instance;
        if (debug) {
            System.err.println("TM: HandleResourceError " + h2.getXAResource() + "," + ex2);
        }
        if ((instance = inv.getInstance()) == null) {
            return;
        }
        Vector v2 = this.getResourceList(instance);
        v2.removeElement(h2);
        try {
            if (tran != null) {
                tran.delistResource(h2.getXAResource(), 0x4000000);
            }
        }
        catch (Exception exception) {}
        if (ex2 instanceof RollbackException) {
            return;
        }
        if (ex2 instanceof IllegalStateException) {
            try {
                h2.getResourceAllocator().closeUserConnection(h2);
            }
            catch (Exception exception) {}
        } else {
            try {
                h2.getResourceAllocator().destroyResource(h2);
            }
            catch (Exception exception) {}
        }
    }

    private boolean isTransactionActive(Transaction tran) {
        return tran != null;
    }

    public void postInvoke() throws InvocationException {
        ComponentInvocation curr = this.invMgr.getCurrentInvocation();
        ComponentInvocation prev = this.invMgr.getPreviousInvocation();
        this.delistComponentResources(curr, false);
        if (prev != null) {
            this.enlistComponentResources(prev);
        }
    }

    public void preInvoke() throws InvocationException {
        ComponentInvocation inv = this.invMgr.getPreviousInvocation();
        if (inv != null) {
            this.delistComponentResources(inv, true);
        }
    }

    private static void print(String s2) {
        System.err.println(s2);
    }

    public void recover(XAResource[] resourceList) {
        int size = resourceList.length;
        Vector<XAResource> v2 = new Vector<XAResource>();
        int i2 = 0;
        while (i2 < size) {
            v2.addElement(resourceList[i2]);
            ++i2;
        }
        TransactionManagerImpl cfr_ignored_0 = (TransactionManagerImpl)this.tm;
        TransactionManagerImpl.recover(v2.elements());
    }

    public void registerComponentResource(ResourceHandle h2) {
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        Object instance = inv.getInstance();
        if (instance == null) {
            return;
        }
        h2.setComponentInstance(instance);
        Vector v2 = this.getResourceList(instance);
        v2.addElement(h2);
    }

    public void registerSynchronization(Synchronization sync) throws IllegalStateException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: registerSynchronization");
        }
        try {
            Transaction tran = this.getTransaction();
            if (tran != null) {
                tran.registerSynchronization(sync);
            }
        }
        catch (RollbackException ex2) {
            ex2.printStackTrace();
            ex2.printStackTrace(Log.err);
            throw new IllegalStateException();
        }
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: resume");
        }
        this.tm.resume(tobj);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: rollback");
        }
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: setRollbackOnly");
        }
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            seconds = 0;
        }
        this.transactionTimeout = seconds;
    }

    public Transaction suspend() throws SystemException {
        if (debug) {
            J2EETransactionManagerImpl.print("TM: suspend");
        }
        return this.tm.suspend();
    }

    public void unregisterComponentResource(ResourceHandle h2) {
        Object instance = h2.getComponentInstance();
        if (instance == null) {
            return;
        }
        h2.setComponentInstance(null);
        Vector v2 = this.getResourceList(instance);
        v2.removeElement(h2);
    }
}

