/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.distributedtx.J2EETransactionManagerImpl;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.JdbcConnectionAllocator;
import com.sun.enterprise.resource.PoolManager;
import com.sun.enterprise.resource.ResourceException;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import javax.sql.DataSource;

public class JdbcDataSource
implements DataSource,
Serializable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$resource$JdbcDataSource != null ? class$com$sun$enterprise$resource$JdbcDataSource : (class$com$sun$enterprise$resource$JdbcDataSource = JdbcDataSource.class$("com.sun.enterprise.resource.JdbcDataSource")));
    private transient PoolManager poolMgr;
    private static final boolean debug = false;
    private String dataSourceName;
    private String desc;
    private String jndiName;
    private int jdbcMajorVersion;
    static /* synthetic */ Class class$com$sun$enterprise$resource$JdbcDataSource;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Connection getConnection() throws SQLException {
        InvocationManager i2 = Switch.getSwitch().getInvocationManager();
        if (i2 == null) {
            String msg = localStrings.getLocalString("datasource.wrongclient", "");
            throw new SQLException(msg);
        }
        ComponentInvocation inv = null;
        inv = i2.getCurrentInvocation();
        int invType = inv.getInvocationType();
        Set refs = null;
        Object container = inv.getContainerContext();
        JndiNameEnvironment env = (JndiNameEnvironment)Switch.getSwitch().getDescriptorFor(container);
        refs = env.getResourceReferenceDescriptors();
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)iter.next();
            if (!ref.getJndiName().equals(this.jndiName)) continue;
            ResourcePrincipal prin = ref.getResourcePrincipal();
            if (prin == null) break;
            return this.getConnection(prin.getName(), prin.getPassword());
        }
        Object[] args = new Object[]{this.jndiName};
        String msg = localStrings.getLocalString("datasource.principalmappernotfound", "Cannot find principal mapping information for data source with JNDI name {0}", args);
        Log.err.println(msg);
        System.err.println(msg);
        return this.getConnection("", "");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        InvocationManager i2 = Switch.getSwitch().getInvocationManager();
        if (i2 == null) {
            String msg = localStrings.getLocalString("datasource.wrongclient", "");
            throw new SQLException(msg);
        }
        this.initPoolManager();
        ResourceSpec spec = new ResourceSpec(this.dataSourceName, "javax.sql.XAConnection");
        JdbcConnectionAllocator alloc = null;
        alloc = this.jdbcMajorVersion == 1 ? new JdbcConnectionAllocator(this.poolMgr, false) : new JdbcConnectionAllocator(this.poolMgr, true);
        try {
            return (Connection)this.poolMgr.getResource(spec, alloc, username, password);
        }
        catch (ResourceException ex2) {
            Exception nex = ex2.getNestedException();
            if (nex instanceof SQLException) {
                throw (SQLException)nex;
            }
            if (nex instanceof RuntimeException) {
                throw (RuntimeException)nex;
            }
            nex.printStackTrace();
            nex.printStackTrace(Log.err);
            throw new SQLException(nex.toString());
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDescription() {
        return this.desc;
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public int getLoginTimeout() throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    private void initPoolManager() {
        if (this.poolMgr == null) {
            J2EETransactionManagerImpl tm = (J2EETransactionManagerImpl)Switch.getSwitch().getTransactionManager();
            this.poolMgr = tm.getPoolManager();
        }
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setJdbcMajorVersion(int version) {
        this.jdbcMajorVersion = version;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException(localStrings.getLocalString("datasource.notsupported", "Operation not supported"));
    }
}

