/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.sharedpassword;

import com.sun.enterprise.security.auth.AuthenticationInfoImpl;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.CredentialsImpl;
import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordUser;

class SharedPasswordAuthHandler
implements AuthenticationHandler {
    private SharedPasswordRealm realm;

    public SharedPasswordAuthHandler(SharedPasswordRealm realm) throws IllegalArgumentException {
        this.realm = realm;
    }

    public AuthenticationStatus doAuthentication(Credentials creds, String principalName, byte[] authData) {
        int status = 1;
        AuthenticationInfoImpl ainfo = null;
        try {
            try {
                SharedPasswordUser user = (SharedPasswordUser)this.realm.getUser(principalName);
                String passwd = new String(authData);
                if (user.authenticate(passwd)) {
                    status = 0;
                    ainfo = new AuthenticationInfoImpl(user.getName(), this.realm.getName(), true);
                    ainfo.setAttribute("Groups", user.getGroups());
                }
            }
            catch (NoSuchUserException nsue) {
                System.out.println(nsue);
            }
            catch (Exception e10) {
                e10.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {}
        AuthenticationStatusImpl as2 = new AuthenticationStatusImpl(principalName, this.realm.getName(), this.realm.getAuthType(), status);
        if (creds instanceof CredentialsImpl) {
            CredentialsImpl cimpl = (CredentialsImpl)creds;
            cimpl.setAuthenticationStatus(as2);
            if (ainfo != null) {
                cimpl.addAuthenticationInfo(ainfo);
            }
        }
        return as2;
    }

    public Realm getRealm() {
        return this.realm;
    }
}

