/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.IconChanger;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class IconInspector
extends JPanel
implements Inspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$IconInspector != null ? class$com$sun$enterprise$tools$deployment$ui$IconInspector : (class$com$sun$enterprise$tools$deployment$ui$IconInspector = IconInspector.class$("com.sun.enterprise.tools.deployment.ui.IconInspector")));
    private Descriptor descriptor;
    private IconChanger changer;
    private JButton smallButton;
    private JTextField smallIconTextField;
    private JButton largeButton;
    private JTextField largeIconTextField;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$IconInspector;

    public IconInspector(IconChanger changer) {
        this.changer = changer;
        this.smallIconTextField = new JTextField();
        this.largeIconTextField = new JTextField();
        this.smallIconTextField.setEnabled(false);
        this.largeIconTextField.setEnabled(false);
        this.smallButton = new JButton("...");
        this.smallButton.setMargin(new Insets(0, 4, 0, 4));
        this.smallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                IconInspector.this.addSmallAction();
            }
        });
        this.largeButton = new JButton("...");
        this.largeButton.setMargin(new Insets(0, 4, 0, 4));
        this.largeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                IconInspector.this.addLargeAction();
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.makePanel(this.smallIconTextField, this.smallButton, localStrings.getLocalString("iconinspector.small_icon", "Small Icon (16x16)")));
        this.add(this.makePanel(this.largeIconTextField, this.largeButton, localStrings.getLocalString("iconinspector.large_icon", "Large Icon (32x32)")));
        this.setBorder(new TitledBorder(localStrings.getLocalString("iconinspector.icons", "Icons")));
    }

    public void addLargeAction() {
        JFileChooser jfc;
        int returnValue;
        if (this.descriptor != null && (returnValue = (jfc = UIUtils.getFileChooser()).showDialog(this, localStrings.getLocalString("iconinspector.choose_icon", "Choose Icon"))) == 0) {
            File iconFile = jfc.getSelectedFile();
            this.changer.addLargeIcon(iconFile);
        }
    }

    public void addSmallAction() {
        JFileChooser jfc;
        int returnValue;
        if (this.descriptor != null && (returnValue = (jfc = UIUtils.getFileChooser()).showDialog(this, localStrings.getLocalString("iconinspector.choose_icon", "Choose Icon"))) == 0) {
            File iconFile = jfc.getSelectedFile();
            this.changer.addSmallIcon(iconFile);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel makePanel(JTextField tf, JButton btn, String label) {
        JPanel insetPanel = new JPanel(new BorderLayout());
        insetPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        insetPanel.add((Component)btn, "Center");
        JPanel p2 = new JPanel();
        p2.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), label));
        p2.setLayout(new BorderLayout());
        p2.add("Center", tf);
        p2.add("East", insetPanel);
        UIUtils.limitVertically(p2);
        tf.setMinimumSize(new Dimension(120, (int)tf.getPreferredSize().getHeight()));
        return p2;
    }

    public void refresh() {
        this.smallIconTextField.setText(this.descriptor.getSmallIconUri());
        this.largeIconTextField.setText(this.descriptor.getLargeIconUri());
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.smallButton.setEnabled(state);
        this.smallIconTextField.setEnabled(state);
        this.largeButton.setEnabled(state);
        this.largeIconTextField.setEnabled(state);
    }

    public void setObject(Object o2) {
        if (o2 instanceof Descriptor) {
            this.descriptor = (Descriptor)o2;
        }
        this.refresh();
    }
}

