/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.deployment.xml.WebBundleNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.HelpPanel;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wizard;
import com.sun.enterprise.tools.deployment.ui.descriptor.EjbRefsInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.EnvironmentInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.ResourceRefsInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebAppContextParametersInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebAppFileRefsInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebAppGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebAppSecurityInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentAliasesInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentParametersInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentSecurityInspector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.xml.tree.XmlDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NewWebComponentWizard
extends Wizard {
    static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$NewWebComponentWizard != null ? class$com$sun$enterprise$tools$deployment$ui$NewWebComponentWizard : (class$com$sun$enterprise$tools$deployment$ui$NewWebComponentWizard = NewWebComponentWizard.class$("com.sun.enterprise.tools.deployment.ui.NewWebComponentWizard")));
    private static String help = localStrings.getLocalString("newwebcomponentwizard.help", "<HTML><BODY><P>This wizard will help you to create a new web component. You must begin with a servlet class or JSP file. The wizard will then package the selected files into a Web ARchive (.WAR) file and will create the deployment descriptor required.<P>Creating this web component requires the following steps:<UL><LI>Select the WAR file to contain the component.<LI>Identify the servlet class or JSP file.</UL><P>Optionally, you can also:<UL><LI>Provide the description and icons for the component.<LI>Provide the initialization parameters for the component.<LI>Provide the aliases to be used by the component.<LI>Provide the security settings for the component.<LI>Provide the context and environment parameters for the WAR file.<LI>Identify any enterprise beans and resources that are referenced by components in this WAR file.<LI>Identify files referenced by components in the WAR file.<LI>Provide the required security information for the WAR file.</UL></BODY></HTML>");
    private HelpPanel helpPanel = new HelpPanel(help, localStrings.getLocalString("newwebcomponentwizard.web_component_title", "New Web Component Wizard"), "WWIntro");
    private ServletOrJspPanel servletOrJspPanel = new ServletOrJspPanel();
    private WebAppGeneralInspector webAppGeneralInspector;
    private WebComponentGeneralInspector webComponentGeneralInspector;
    private WebBundleDescriptor webBundleDescriptor;
    private WebBundleDescriptor targetWebBundleDescriptor;
    private WebComponentDescriptorImpl webComponentDescriptor;
    private EnvironmentInspector environmentInspector;
    private EjbRefsInspector ejbRefsInspector;
    private ResourceRefsInspector resourceRefsInspector;
    private WebComponentSecurityInspector webComponentSecurityInspector;
    private WebAppContextParametersInspector webAppContextParametersInspector;
    private WebComponentParametersInspector webComponentParametersInspector;
    private boolean debug = false;
    private File descriptorFile = null;
    private JTextArea xmlTextArea = new JTextArea();
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$NewWebComponentWizard;

    public NewWebComponentWizard(Frame owner, JComponent targetChooser) {
        super(owner);
        this.createWands(targetChooser);
        super.setBounds(100, 100, 700, 580);
        super.setTitle(localStrings.getLocalString("newwebcomponentwizard.web_component_title", "New Web Component Wizard"));
        if (((TreeCombo)targetChooser).getSelectedDescriptor() instanceof WebBundleDescriptor) {
            this.targetWebBundleDescriptor = (WebBundleDescriptor)((TreeCombo)targetChooser).getSelectedDescriptor();
        }
        super.show();
    }

    private void addAndCreateNewWebComponent() {
        if (this.getCurrentWebComponentDescriptor() == null || this.getCurrentWebComponentDescriptor() instanceof ServletDescriptorImpl && !this.servletOrJspPanel.isServletChoice() || this.getCurrentWebComponentDescriptor() instanceof JspDescriptorImpl && this.servletOrJspPanel.isServletChoice()) {
            WebComponentDescriptorImpl newWebComponentDescriptor = null;
            if (this.getCurrentWebComponentDescriptor() != null) {
                this.getWebBundleDescriptor().removeWebComponentDescriptor(this.getCurrentWebComponentDescriptor());
            }
            newWebComponentDescriptor = this.servletOrJspPanel.isServletChoice() ? new ServletDescriptorImpl() : new JspDescriptorImpl();
            this.setCurrentWebComponentDescriptor(newWebComponentDescriptor);
            this.getWebBundleDescriptor().addWebComponentDescriptor(this.getCurrentWebComponentDescriptor());
        }
    }

    private boolean checkLoadWebComponentFile(Vector classFiles) {
        if (this.servletOrJspPanel.isServletChoice()) {
            Object servletClassname = null;
            if (classFiles.isEmpty()) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("newwebcomponentwizard.servlet_not_added", "No servlet class was not added to the .war. Go back to add the needed class file."));
                return false;
            }
            String nextClass = "";
            try {
                ClassLoader cl2 = this.webAppGeneralInspector.getClassDescriptor().getClassLoader();
                Iterator itr = ((AbstractList)classFiles).iterator();
                while (itr.hasNext()) {
                    nextClass = (String)itr.next();
                    cl2.loadClass(nextClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                JOptionPane.showMessageDialog(this, String.valueOf(localStrings.getLocalString("newwebcomponentwizard.the_servlet_class", "The servlet class (")) + nextClass + localStrings.getLocalString("newwebcomponentwizard.not_loaded_from", ") could not be loaded from the class files added to the archive.\n") + localStrings.getLocalString("wizard.adding_classes_help", "\nPlease consult online help for assistance in setting up the class root directory and choosing class files."));
                return false;
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("newwebcomponentwizard.development_error", "Development error"));
                return false;
            }
        } else if (classFiles.isEmpty()) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("newwebcomponentwizard.jsp_not_found", "No jsp files could be found in the content files. Go back to add the needed file."));
            return false;
        }
        return true;
    }

    private boolean checkNameNotEmpty() {
        if (this.webComponentGeneralInspector.getJspFileOrServerClassname() == null || "".equals(this.webComponentGeneralInspector.getJspFileOrServerClassname())) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("newwebcomponentwizard.supply_class_name", "Please supply the class/file name of the web component"));
            return false;
        }
        if (this.getCurrentWebComponentDescriptor() instanceof ServletDescriptorImpl) {
            ((ServletDescriptorImpl)this.getCurrentWebComponentDescriptor()).setClassName(this.webComponentGeneralInspector.getJspFileOrServerClassname());
        } else {
            ((JspDescriptorImpl)this.getCurrentWebComponentDescriptor()).setJspFileName(this.webComponentGeneralInspector.getJspFileOrServerClassname());
        }
        if ("".equals(this.getCurrentWebComponentDescriptor().getName())) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("newwebcomponentwizard.supply_display_name", "Please supply a display name for this web component"));
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private String convertToFilename(String classname) {
        return String.valueOf(classname.replace('.', '/')) + ".class";
    }

    private void createWands(JComponent targetChooser) {
        Vector inspectors = new Vector();
        this.webAppGeneralInspector = new WebAppGeneralInspector("DeveloperMode", targetChooser);
        this.webComponentGeneralInspector = new WebComponentGeneralInspector("DeveloperMode");
        super.addComponent(this.helpPanel, localStrings.getLocalString("newwebcomponentwizard.introduction", "Introduction"), "");
        super.addComponent(this.webAppGeneralInspector, localStrings.getLocalString("newwebcomponentwizard.general_props", "WAR File General Properties"), localStrings.getLocalString("newwebcomponentwizard.set_general_props", "Set general properties"));
        CSH.setHelpIDString((Component)this.webAppGeneralInspector, (String)"WWGeneral");
        super.addComponent(this.servletOrJspPanel, "Choose Component Type", localStrings.getLocalString("newwebcomponentwizard.describe", "Describe a Jsp or Servlet"));
        CSH.setHelpIDString((Component)this.servletOrJspPanel, (String)"WWChooseComp");
        super.addComponent(this.webComponentGeneralInspector, localStrings.getLocalString("newwebcomponentwizard.component_general_props", "Component General Properties"), localStrings.getLocalString("newwebcomponentwizard.set_component_general_props", "Set Web component general properties"));
        CSH.setHelpIDString((Component)this.webComponentGeneralInspector, (String)"WWProp");
        this.webComponentParametersInspector = new WebComponentParametersInspector();
        super.addComponent(this.webComponentParametersInspector, localStrings.getLocalString("newwebcomponentwizard.params", "Parameters"), localStrings.getLocalString("newwebcomponentwizard.set_params", "Set Web component parameters"));
        CSH.setHelpIDString((Component)this.webComponentParametersInspector, (String)"WWInitParam");
        WebComponentAliasesInspector webComponentAliasesInspector = new WebComponentAliasesInspector();
        super.addComponent(webComponentAliasesInspector, localStrings.getLocalString("newwebcomponentwizard.aliases", "Aliases"), localStrings.getLocalString("newwebcomponentwizard.set_aliases", "Please provide the aliases for this web component. Calls to these aliases will be redirected to an instance of the web component."));
        CSH.setHelpIDString((Component)webComponentAliasesInspector, (String)"WWAlias");
        this.webComponentSecurityInspector = new WebComponentSecurityInspector("DeveloperMode");
        super.addComponent(this.webComponentSecurityInspector, localStrings.getLocalString("newwebcomponentwizard.security", "Component Security"), localStrings.getLocalString("newwebcomponentwizard.declare_role_refs", "Declare Role References"));
        CSH.setHelpIDString((Component)this.webComponentSecurityInspector, (String)"WWRoleRef");
        this.environmentInspector = new EnvironmentInspector("DeveloperMode");
        super.addComponent(this.environmentInspector, localStrings.getLocalString("newwebcomponentwizard.environment", "WAR File Environment"), localStrings.getLocalString("newwebcomponentwizard.set_environment", "Set environment properties"));
        CSH.setHelpIDString((Component)this.environmentInspector, (String)"WWEnv");
        this.ejbRefsInspector = new EjbRefsInspector("DeveloperMode");
        super.addComponent(this.ejbRefsInspector, localStrings.getLocalString("newwebcomponentwizard.ejb_refs", "Enterprise Bean References"), localStrings.getLocalString("newwebcomponentwizard.set_ejb_refs", "Please list any enterprise beans that are referenced in the code of the components in this WAR file. For each of these, provide the type of bean required (session or entity), and the class names (including package) of the Home and Remote interfaces expected. Also, please provide a description of each bean referenced."));
        CSH.setHelpIDString((Component)this.ejbRefsInspector, (String)"WWEJBRef");
        this.resourceRefsInspector = new ResourceRefsInspector("DeveloperMode");
        super.addComponent(this.resourceRefsInspector, localStrings.getLocalString("newwebcomponentwizard.res_refs", "Resource References"), localStrings.getLocalString("newwebcomponentwizard.set_res_refs", "Set Resource references"));
        CSH.setHelpIDString((Component)this.resourceRefsInspector, (String)"WWResourceRef");
        this.webAppContextParametersInspector = new WebAppContextParametersInspector();
        super.addComponent(this.webAppContextParametersInspector, "Context Parameters", localStrings.getLocalString("newwebcomponentwizard.servlet_context_params", "Add servlet context parameters"));
        CSH.setHelpIDString((Component)this.webAppContextParametersInspector, (String)"WWContextParam");
        WebAppFileRefsInspector webAppFileRefsInspector = new WebAppFileRefsInspector();
        super.addComponent(webAppFileRefsInspector, localStrings.getLocalString("newwebcomponentwizard.file_refs", "File References"), localStrings.getLocalString("newwebcomponentwizard.set_file_refs", "Set File references"));
        CSH.setHelpIDString((Component)webAppFileRefsInspector, (String)"WWFileRef");
        WebAppSecurityInspector webAppSecurityInspector = new WebAppSecurityInspector();
        super.addComponent(webAppSecurityInspector, localStrings.getLocalString("newwebcomponentwizard.app_security", "Security"), localStrings.getLocalString("newwebcomponentwizard.set_app_security", "Set security"));
        CSH.setHelpIDString((Component)webAppSecurityInspector, (String)"WWSecurity");
        super.addComponent(new XMLDisplay(this.xmlTextArea), localStrings.getLocalString("newwebcomponentwizard.review_settings", "Review Settings"), localStrings.getLocalString("newwebcomponentwizard.inspect_xml", "Inspect XML descriptor"));
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)this.helpPanel));
    }

    void delegateNotification(Object maybeInspector) {
        if (maybeInspector instanceof Inspector) {
            if (maybeInspector instanceof WebComponentGeneralInspector || maybeInspector instanceof WebComponentParametersInspector || maybeInspector instanceof WebComponentSecurityInspector || maybeInspector instanceof WebComponentAliasesInspector) {
                ((Inspector)maybeInspector).setObject(this.getCurrentWebComponentDescriptor());
            } else {
                ((Inspector)maybeInspector).setObject(this.getWebBundleDescriptor());
            }
        }
    }

    private void descriptorChanged() {
        this.environmentInspector.setObject(this.getWebBundleDescriptor());
        this.ejbRefsInspector.setObject(this.getWebBundleDescriptor());
        this.resourceRefsInspector.setObject(this.getWebBundleDescriptor());
        this.webComponentSecurityInspector.setObject(this.getCurrentWebComponentDescriptor());
        this.webComponentParametersInspector.setObject(this.getCurrentWebComponentDescriptor());
    }

    public void finishAction() {
        super.finishAction();
    }

    public FileContentsDescriptor getClassDescriptor() {
        return this.webAppGeneralInspector.getClassDescriptor();
    }

    public FileContentsDescriptor getContentsDescriptor() {
        return this.webAppGeneralInspector.getContentsDescriptor();
    }

    private WebComponentDescriptorImpl getCurrentWebComponentDescriptor() {
        return this.webComponentDescriptor;
    }

    public WebBundleDescriptor getWebBundleDescriptor() {
        if (this.webBundleDescriptor == null) {
            this.webBundleDescriptor = new WebBundleDescriptor();
            this.webBundleDescriptor.addNotificationListener(new NotificationListener(){

                public void notification(NotificationEvent ne) {
                    NewWebComponentWizard.this.descriptorChanged();
                    NewWebComponentWizard.this.notifyCurrentComponentAction();
                }
            });
            if (this.targetWebBundleDescriptor != null) {
                this.webBundleDescriptor.setName(this.targetWebBundleDescriptor.getName());
                this.webBundleDescriptor.getArchivist().setArchiveUri(this.targetWebBundleDescriptor.getArchivist().getArchiveUri());
                this.webBundleDescriptor.setDistributable(this.targetWebBundleDescriptor.isDistributable());
                this.webBundleDescriptor.setSessionTimeout(this.targetWebBundleDescriptor.getSessionTimeout());
                this.webAppGeneralInspector.setBundleInfoEnabled(false);
            }
        }
        return this.webBundleDescriptor;
    }

    public void goBackward() {
        JComponent currentComponent = super.getCurrentComponent();
        if (currentComponent == this.webAppGeneralInspector) {
            this.webBundleDescriptor = null;
        } else if (currentComponent == this.webComponentGeneralInspector) {
            if (this.getCurrentWebComponentDescriptor() instanceof ServletDescriptorImpl) {
                ((ServletDescriptorImpl)this.getCurrentWebComponentDescriptor()).setClassName(this.webComponentGeneralInspector.getJspFileOrServerClassname());
            } else {
                ((JspDescriptorImpl)this.getCurrentWebComponentDescriptor()).setJspFileName(this.webComponentGeneralInspector.getJspFileOrServerClassname());
            }
        } else if (currentComponent == this.environmentInspector && this.servletOrJspPanel.isNoComponentChoice()) {
            super.setCurrentState(super.getIndexOf(this.webComponentGeneralInspector));
        }
        super.goBackward();
        currentComponent = super.getCurrentComponent();
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)currentComponent));
    }

    public void goForward() {
        JComponent currentComponent = super.getCurrentComponent();
        if (currentComponent == this.servletOrJspPanel) {
            if (this.servletOrJspPanel.isNoComponentChoice()) {
                super.setCurrentState(super.getIndexOf(this.webComponentSecurityInspector));
            } else {
                File componentClass = null;
                Vector<String> classFiles = new Vector<String>();
                if (this.servletOrJspPanel.isServletChoice()) {
                    Set classNames = this.webAppGeneralInspector.getClassDescriptor().getClassNamesSet();
                    Iterator itr = classNames.iterator();
                    while (itr.hasNext()) {
                        classFiles.add((String)itr.next());
                    }
                } else {
                    Set componentFiles = this.webAppGeneralInspector.getContentsDescriptor().getFilesSet();
                    Iterator itr = componentFiles.iterator();
                    while (itr.hasNext()) {
                        componentClass = (File)itr.next();
                        if (!componentClass.getName().endsWith(".jsp")) continue;
                        classFiles.add(componentClass.toString());
                    }
                }
                if (!this.checkLoadWebComponentFile(classFiles)) {
                    return;
                }
                this.addAndCreateNewWebComponent();
                this.webComponentGeneralInspector.setComponentClassModel(classFiles);
            }
        } else if (currentComponent == this.webAppGeneralInspector) {
            if (this.getWebBundleDescriptor().getName().equals("")) {
                this.getWebBundleDescriptor().setName(localStrings.getLocalString("newwebcomponentwizard.webapp", "Web App"));
            }
        } else if (currentComponent == this.webComponentGeneralInspector && !this.checkNameNotEmpty()) {
            return;
        }
        super.goForward();
        JComponent newCurrent = super.getCurrentComponent();
        DeployToolActions.enableHelpOnButton(this.helpButton, CSH.getHelpIDString((Component)newCurrent));
        if (newCurrent == this.servletOrJspPanel) {
            this.finishButton.setEnabled(true);
        }
        if (newCurrent instanceof XMLDisplay) {
            this.refreshXmlDisplay();
        }
        this.delegateNotification(newCurrent);
    }

    void notifyCurrentComponentAction() {
        this.delegateNotification(this.getCurrentComponent());
    }

    private void refreshXmlDisplay() {
        try {
            XmlDocument document = WebBundleNode.getDocument(this.getWebBundleDescriptor());
            StringWriter sw = new StringWriter();
            XMLUtils.writeDocument(document, sw);
            this.xmlTextArea.setText(sw.toString());
        }
        catch (Throwable throwable) {
            System.out.println(localStrings.getLocalString("newwebcomponentwizard.error_forming_xml", "Warning: error forming XML"));
        }
    }

    private void setCurrentWebComponentDescriptor(WebComponentDescriptorImpl webComponentDescriptor) {
        this.webComponentDescriptor = webComponentDescriptor;
    }

    private File writeDescriptorAction() throws IOException {
        File descriptorFile = File.createTempFile("war", "xml");
        XmlDocument document = WebBundleNode.getDocument(this.getWebBundleDescriptor());
        FileWriter fw = new FileWriter(descriptorFile);
        XMLUtils.writeDocument(document, fw);
        System.out.println(String.valueOf(localStrings.getLocalString("newwebcomponentwizard.written", "Written ")) + descriptorFile.getAbsolutePath());
        return descriptorFile;
    }

    class XMLDisplay
    extends JPanel {
        public XMLDisplay(JTextArea ta) {
            CSH.setHelpIDString((Component)this, (String)"WWReview");
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(ta));
            ta.setEnabled(false);
        }
    }

    class ServletOrJspPanel
    extends JPanel {
        JRadioButton servletRadioButton = new JRadioButton(localStrings.getLocalString("newwebcomponentwizard.describe_a_servlet", "Describe a servlet"), true);
        JRadioButton jspRadioButton = new JRadioButton(localStrings.getLocalString("newwebcomponentwizard.describe_a_jsp", "Describe a JSP"));
        JRadioButton noComponentButton = new JRadioButton(localStrings.getLocalString("newwebcomponentwizard.no_web_component", "No web component"));

        ServletOrJspPanel() {
            String helpSetMapID = "WWChooseComp";
            CSH.setHelpIDString((Component)this, (String)helpSetMapID);
            this.setLayout(new BorderLayout());
            JPanel p2 = null;
            p2 = UIUtils.createBorderedPanel(localStrings.getLocalString("newwebcomponentwizard.describe_question", "Describe a servlet or a JSP ?"), new GridLayout(3, 1));
            ButtonGroup group = new ButtonGroup();
            group.add(this.servletRadioButton);
            group.add(this.jspRadioButton);
            group.add(this.noComponentButton);
            p2.add(this.servletRadioButton);
            p2.add(this.jspRadioButton);
            p2.add(this.noComponentButton);
            UIUtils.limitVertically(p2);
            this.add("North", p2);
        }

        boolean isJspChoice() {
            return this.jspRadioButton.isSelected();
        }

        boolean isNoComponentChoice() {
            return this.noComponentButton.isSelected();
        }

        boolean isServletChoice() {
            return this.servletRadioButton.isSelected();
        }
    }
}

