/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.main.ServerManager;
import com.sun.enterprise.tools.deployment.ui.ServerView;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ServerView
extends JPanel
implements NotificationListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ServerView != null ? class$com$sun$enterprise$tools$deployment$ui$ServerView : (class$com$sun$enterprise$tools$deployment$ui$ServerView = ServerView.class$("com.sun.enterprise.tools.deployment.ui.ServerView")));
    private static String VIEW_LABEL = localStrings.getLocalString("serverview.servers", "Servers");
    JList serverList;
    private ServerManager serverManager;
    JTextField serverNameTextField = new JTextField();
    JButton addButton = new JButton(localStrings.getLocalString("serverview.add", "Add"));
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ServerView;

    public ServerView(ServerManager serverManager) {
        this.serverManager = serverManager;
        DefaultListModel listModel = new DefaultListModel();
        this.serverList = new JList(listModel);
        this.serverList.setSelectionMode(0);
        this.setLayout(new BorderLayout());
        JPanel p2 = UIUtils.createBorderedPanel(VIEW_LABEL, new BorderLayout());
        p2.add(new JScrollPane(this.serverList));
        this.add("Center", p2);
        this.serverList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e10) {
                ServerView.this.listClickedAction();
            }
        });
        class ServerListCellRenderer
        extends DefaultListCellRenderer {
            ServerListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(UIUtils.getImageIconFor(UIUtils.HOST_ICON));
                return label;
            }
        }
        this.serverList.setCellRenderer(new ServerListCellRenderer());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getSelection() {
        return (String)this.serverList.getSelectedValue();
    }

    void listClickedAction() {
        String currentServer = this.getSelection();
        this.serverManager.setCurrentServer(currentServer);
    }

    public void notification(NotificationEvent ne) {
        if (ne.getSource() instanceof ServerManager) {
            final ServerManager serverManager = (ServerManager)ne.getSource();
            final Runnable updateRunnable = new Runnable(){

                public void run() {
                    this.updateList(serverManager);
                }
            };
            Thread appThread = new Thread(){

                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(updateRunnable);
                    }
                    catch (Exception e10) {
                        e10.printStackTrace();
                    }
                }
            };
            if (ne.getType().equals(ServerManager.SERVER_SELECTED)) {
                this.updateList(serverManager);
            } else {
                appThread.start();
            }
        }
    }

    void updateList(ServerManager serverManager) {
        DefaultListModel listModel = new DefaultListModel();
        Enumeration e10 = serverManager.getServerNames().elements();
        while (e10.hasMoreElements()) {
            listModel.addElement(e10.nextElement());
        }
        this.serverList.setModel(listModel);
        String currentServer = serverManager.getCurrentServer();
        this.serverList.setSelectedValue(currentServer, true);
    }
}

