/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.tools.deployment.ui.ContentChooser;
import com.sun.enterprise.tools.deployment.ui.IconChanger;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.OKCancelDialog;
import com.sun.enterprise.tools.deployment.ui.TreeCombo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class AppClientGeneralInspector
extends JPanel
implements Inspector,
IconChanger {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientGeneralInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientGeneralInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientGeneralInspector = AppClientGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.AppClientGeneralInspector")));
    private static final String CHOOSE_LARGE_ICON_TITLE = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.chooselargeicon", "Choose Large Icon");
    private static final String CHOOSE_SMALL_ICON_TITLE = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choosesmallicon", "Choose Small Icon");
    ApplicationClientDescriptor descriptor;
    String mode = "DeployerMode";
    JTextField txtJarFile = new JTextField();
    JTextField txtBaseDirectory = new JTextField();
    JComboBox mainClassCombo = new JComboBox();
    JTextField txtClientDisplayName = new JTextField();
    JTextField txtLargeIcon = new JTextField();
    JTextField txtSmallIcon = new JTextField();
    JTextArea txtDescription = new JTextArea();
    JList classpathList = new JList();
    JList lstContents;
    IconInspector iconInspector;
    JButton btnAdd = new JButton();
    JButton btnDelete = new JButton();
    JButton addLibJarButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addellipse", "Add..."));
    JButton removeLibJarButton = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.remove", "Remove..."));
    private JComponent targetChooser;
    private FileContentsDescriptor contentsMap = new FileContentsDescriptor();
    private ContentChooser contentChooser;
    private static String helpSetMapID = "LIGeneral";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientGeneralInspector;
    static /* synthetic */ Class class$java$awt$Frame;

    public AppClientGeneralInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.initializeLayout();
        this.addListeners();
    }

    public AppClientGeneralInspector(String mode) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.mode = mode;
        this.initializeLayout();
        this.addListeners();
    }

    public AppClientGeneralInspector(String mode, JComponent targetChooser) {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.mode = mode;
        this.targetChooser = targetChooser;
        this.initializeLayout();
        this.addListeners();
    }

    private void addContents(FileContentsDescriptor fcd) {
        if (this.mode.equals("DeveloperMode")) {
            Enumeration e10 = fcd.getFiles();
            while (e10.hasMoreElements()) {
                File nextKey = (File)e10.nextElement();
                this.contentsMap.add(nextKey, fcd.getDirectoryFor(nextKey));
            }
        } else {
            try {
                Archivist archivist = this.descriptor.getArchivist();
                archivist.addFiles(archivist.createEntryNameMap(fcd));
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
        this.refresh();
    }

    private void addContentsAction() {
        if (this.contentChooser == null) {
            this.contentChooser = new ContentChooser(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choosecontents", "Please click Browse and select the folder that represents the root directory of the files to be added.  Select a file or directory from the root directory and click Add."), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.appclientjarcontents", "Files to be Added:"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choosedirectory", "Root Directory"), new File(""), null);
        }
        this.contentChooser.setContentsMap(new FileContentsDescriptor());
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = AppClientGeneralInspector.class$("java.awt.Frame")), this);
        OKCancelDialog d10 = ContentChooser.createDialog(this.contentChooser, frame, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addfilestoappclient", "Add files to the Application Client"), "CWAddFile");
        d10.show();
        if (d10.isOK()) {
            this.addContents(this.contentChooser.getContentsMap());
        }
    }

    public void addLargeIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add32Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Icon could not be added.\n " + ioe.getMessage());
            }
        } else {
            if (!"".equals(this.descriptor.getLargeIconUri())) {
                this.contentsMap.removeFile(new File(this.descriptor.getLargeIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.contentsMap.add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setLargeIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    public void addLibJarAction() {
        Object[] manifestClasspaths = null;
        try {
            manifestClasspaths = this.mode.equals("DeveloperMode") ? ((Application)((TreeCombo)this.targetChooser).getSelectedDescriptor()).getApplicationArchivist().getLibraryJarUris().toArray() : this.descriptor.getApplication().getApplicationArchivist().getLibraryJarUris().toArray();
        }
        catch (Throwable throwable) {}
        if (Array.getLength(manifestClasspaths) > 0) {
            Object selectedValue = JOptionPane.showInputDialog(null, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choose_library_jar", "Choose a library .jar file"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.add_library_jar_title", "Add Library Jar"), 1, null, manifestClasspaths, manifestClasspaths[0]);
            if (selectedValue != null) {
                this.descriptor.getArchivist().addManfiestClasspath((String)selectedValue);
                this.refresh();
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.no_library_jars", "There are no library jar files currently in this application"));
        }
    }

    private void addListeners() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                if (e10.getSource() == AppClientGeneralInspector.this.txtClientDisplayName) {
                    AppClientGeneralInspector.this.descriptor.setName(AppClientGeneralInspector.this.txtClientDisplayName.getText());
                }
                if (e10.getSource() == AppClientGeneralInspector.this.txtSmallIcon) {
                    AppClientGeneralInspector.this.descriptor.setSmallIconUri(AppClientGeneralInspector.this.txtSmallIcon.getText());
                }
                if (e10.getSource() == AppClientGeneralInspector.this.txtLargeIcon) {
                    AppClientGeneralInspector.this.descriptor.setLargeIconUri(AppClientGeneralInspector.this.txtLargeIcon.getText());
                }
                if (e10.getSource() == AppClientGeneralInspector.this.mainClassCombo && !AppClientGeneralInspector.this.descriptor.getMainClassName().equals((String)AppClientGeneralInspector.this.mainClassCombo.getSelectedItem())) {
                    AppClientGeneralInspector.this.descriptor.setMainClassName((String)AppClientGeneralInspector.this.mainClassCombo.getSelectedItem());
                }
                if (e10.getSource() == AppClientGeneralInspector.this.txtDescription) {
                    AppClientGeneralInspector.this.descriptor.setDescription(AppClientGeneralInspector.this.txtDescription.getText());
                }
            }
        };
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e10) {
                if (e10.getSource() == AppClientGeneralInspector.this.txtClientDisplayName) {
                    AppClientGeneralInspector.this.descriptor.setName(AppClientGeneralInspector.this.txtClientDisplayName.getText());
                }
                if (e10.getSource() == AppClientGeneralInspector.this.txtSmallIcon) {
                    AppClientGeneralInspector.this.descriptor.setSmallIconUri(AppClientGeneralInspector.this.txtSmallIcon.getText());
                }
                if (e10.getSource() == AppClientGeneralInspector.this.txtLargeIcon) {
                    AppClientGeneralInspector.this.descriptor.setLargeIconUri(AppClientGeneralInspector.this.txtLargeIcon.getText());
                }
                if (e10.getSource() == AppClientGeneralInspector.this.txtDescription) {
                    AppClientGeneralInspector.this.descriptor.setDescription(AppClientGeneralInspector.this.txtDescription.getText());
                }
            }
        };
        this.txtClientDisplayName.addActionListener(actionListener);
        this.txtSmallIcon.addActionListener(actionListener);
        this.txtLargeIcon.addActionListener(actionListener);
        this.mainClassCombo.addActionListener(actionListener);
        this.txtDescription.addFocusListener(focusListener);
        this.txtClientDisplayName.addFocusListener(focusListener);
        this.txtSmallIcon.addFocusListener(focusListener);
        this.txtLargeIcon.addFocusListener(focusListener);
    }

    public void addSmallIcon(File iconFile) {
        if (!this.mode.equals("DeveloperMode")) {
            ApplicationArchivist archivist = this.descriptor.getApplication().getApplicationArchivist();
            try {
                archivist.add16Icon(this.descriptor, this.descriptor, iconFile);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Icon could not be added.\n " + ioe.getMessage());
            }
        } else {
            if (!"".equals(this.descriptor.getSmallIconUri())) {
                this.contentsMap.removeFile(new File(this.descriptor.getSmallIconUri()));
            }
            File absoluteIconFile = new File(iconFile.getAbsolutePath());
            this.contentsMap.add(new File(absoluteIconFile.getName()), absoluteIconFile.getParentFile());
            this.descriptor.setSmallIconUri(absoluteIconFile.getName());
            this.refresh();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private JPanel createAppClientPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.appclient", "Application client:")));
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        left.setBorder(new EmptyBorder(0, 5, 5, 5));
        panel.add((Component)left, "Center");
        JLabel mainClassLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.mainclassname", "Main class:"));
        left.add(mainClassLabel);
        left.add(Box.createRigidArea(new Dimension(0, 2)));
        left.add(this.mainClassCombo);
        left.add(Box.createRigidArea(new Dimension(0, 5)));
        JLabel displayNameLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.clientdisplayname", "Display name:"));
        left.add(displayNameLabel);
        left.add(Box.createRigidArea(new Dimension(0, 2)));
        this.txtClientDisplayName.setMaximumSize(new Dimension(this.txtClientDisplayName.getMaximumSize().width, Math.max(this.mainClassCombo.getPreferredSize().height, this.txtClientDisplayName.getPreferredSize().height)));
        left.add(this.txtClientDisplayName);
        left.add(Box.createRigidArea(new Dimension(5, 5)));
        JLabel descriptionLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.description", "Description:"));
        left.add(descriptionLabel);
        left.add(Box.createRigidArea(new Dimension(0, 2)));
        this.txtDescription.setText("");
        this.txtDescription.setLineWrap(true);
        JScrollPane scrlDescription = new JScrollPane(this.txtDescription);
        scrlDescription.setPreferredSize(new Dimension(240, 35));
        left.add(scrlDescription);
        mainClassLabel.setAlignmentX(0.0f);
        this.mainClassCombo.setAlignmentX(0.0f);
        displayNameLabel.setAlignmentX(0.0f);
        this.txtClientDisplayName.setAlignmentX(0.0f);
        descriptionLabel.setAlignmentX(0.0f);
        scrlDescription.setAlignmentX(0.0f);
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        right.setBorder(new EmptyBorder(0, 0, 0, 5));
        panel.add((Component)right, "East");
        right.add(Box.createGlue());
        this.iconInspector = new IconInspector(this);
        this.iconInspector.setPreferredSize(new Dimension(150, this.iconInspector.getPreferredSize().height));
        right.add(this.iconInspector);
        return panel;
    }

    private JPanel createContentsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.contents", "Contents:")));
        this.lstContents = new JList(new DefaultListModel());
        this.lstContents.setVisibleRowCount(13);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder(new EmptyBorder(0, 5, 5, 5));
        wrapper.add((Component)new JScrollPane(this.lstContents), "Center");
        panel.add((Component)wrapper, "Center");
        Box buttons = new Box(0);
        JPanel buttonWrapper = new JPanel(new BorderLayout());
        buttonWrapper.setBorder(new EmptyBorder(0, 0, 0, 5));
        buttonWrapper.add((Component)buttons, "Center");
        panel.add((Component)buttonWrapper, "East");
        this.btnAdd.setText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addellipse", "Add..."));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AppClientGeneralInspector.this.addContentsAction();
            }
        });
        this.btnDelete.setText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.remove", "Remove..."));
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                AppClientGeneralInspector.this.removeContentsAction();
            }
        });
        buttons.add(this.btnAdd);
        buttons.add(Box.createRigidArea(new Dimension(5, 5)));
        buttons.add(this.btnDelete);
        return panel;
    }

    private JPanel createManifestPanel() {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        this.classpathList.setVisibleRowCount(2);
        JScrollPane scroller = new JScrollPane(this.classpathList);
        box.add(scroller);
        box.add(Box.createRigidArea(new Dimension(5, 0)));
        box.add(this.addLibJarButton);
        box.add(Box.createRigidArea(new Dimension(5, 0)));
        box.add(this.removeLibJarButton);
        return box;
    }

    public String getBaseDirectory() {
        return this.txtBaseDirectory.getText();
    }

    public JList getContentList() {
        return this.lstContents;
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        return this.contentsMap;
    }

    public String getJarFile() {
        return this.txtJarFile.getText();
    }

    public String getMainClass() {
        return (String)this.mainClassCombo.getSelectedItem();
    }

    private void initializeLayout() {
        CSH.setHelpIDString((Component)this, (String)localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.appclientgeneralinspectortab", "Application_Client_General_Inspector_Tab"));
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        String targetText = this.targetChooser != null ? localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.targetappllication", "Target Application:") : localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.jarfile", "JAR File:");
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        Box northPanel = new Box(1);
        mainPanel.add((Component)northPanel, "North");
        JLabel targetLabel = new JLabel(targetText);
        targetLabel.setAlignmentX(0.0f);
        northPanel.add(targetLabel);
        northPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        this.txtJarFile.setText(new File("client.jar").getAbsolutePath());
        if (this.targetChooser != null) {
            this.targetChooser.setAlignmentX(0.0f);
            this.targetChooser.setMaximumSize(this.targetChooser.getPreferredSize());
            northPanel.add(this.targetChooser);
        } else {
            this.txtJarFile.setAlignmentX(0.0f);
            this.txtJarFile.setMaximumSize(this.txtJarFile.getPreferredSize());
            northPanel.add(this.txtJarFile);
        }
        northPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel contentsPanel = this.createContentsPanel();
        mainPanel.add((Component)contentsPanel, "Center");
        Box southPanel = new Box(1);
        mainPanel.add((Component)southPanel, "South");
        southPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JLabel manifestLabel = new JLabel(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.manifestclasspath", "Manifest Classpath:"));
        manifestLabel.setAlignmentX(0.0f);
        southPanel.add(manifestLabel);
        southPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        JPanel manifestPanel = this.createManifestPanel();
        manifestPanel.setAlignmentX(0.0f);
        southPanel.add(manifestPanel);
        southPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel appClientPanel = this.createAppClientPanel();
        this.add((Component)appClientPanel, "South");
        this.addLibJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                AppClientGeneralInspector.this.addLibJarAction();
            }
        });
        this.removeLibJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                AppClientGeneralInspector.this.removeLibJarAction();
            }
        });
    }

    private void refresh() {
        DefaultListModel dlm;
        if (this.descriptor == null) {
            return;
        }
        this.iconInspector.setObject(this.descriptor);
        if (!this.mode.equals("DeveloperMode")) {
            this.txtBaseDirectory.setEnabled(false);
            this.txtJarFile.setEnabled(false);
            Object mainClass = this.mainClassCombo.getSelectedItem();
            DefaultComboBoxModel<String> classNameModel = new DefaultComboBoxModel<String>();
            try {
                Vector classNames = this.descriptor.getArchivist().getClassNames();
                int entryIndex = 0;
                while (entryIndex < classNames.size()) {
                    classNameModel.addElement((String)classNames.elementAt(entryIndex));
                    ++entryIndex;
                }
                this.mainClassCombo.setModel(classNameModel);
                if (mainClass != null) {
                    this.mainClassCombo.setSelectedItem(mainClass);
                }
            }
            catch (Throwable throwable) {}
            this.txtJarFile.setText(this.descriptor.getArchivist().getArchiveUri());
            try {
                Vector entryNames = this.descriptor.getArchivist().getEntryNames();
                DefaultListModel<File> contentsListModel = new DefaultListModel<File>();
                int entryIndex = 0;
                while (entryIndex < entryNames.size()) {
                    contentsListModel.addElement(new File((String)entryNames.elementAt(entryIndex)));
                    ++entryIndex;
                }
                this.lstContents.setModel(contentsListModel);
            }
            catch (Throwable throwable) {}
        } else {
            dlm = new DefaultListModel();
            Enumeration e10 = this.contentsMap.getFiles();
            while (e10.hasMoreElements()) {
                dlm.addElement(e10.nextElement());
            }
            this.lstContents.setModel(dlm);
            if (this.contentChooser != null) {
                Object mainClass = this.mainClassCombo.getSelectedItem();
                DefaultComboBoxModel<String> classFileModel = new DefaultComboBoxModel<String>();
                Set classFiles = this.contentChooser.getContentsMap().getClassNamesSet();
                Iterator itr = classFiles.iterator();
                while (itr.hasNext()) {
                    classFileModel.addElement((String)itr.next());
                }
                this.mainClassCombo.setModel(classFileModel);
                if (mainClass != null) {
                    this.mainClassCombo.setSelectedItem(mainClass);
                }
            }
        }
        dlm = new DefaultListModel();
        Iterator itr = this.descriptor.getArchivist().getManifestClasspaths().iterator();
        while (itr.hasNext()) {
            String next = (String)itr.next();
            dlm.addElement(next);
        }
        this.classpathList.setModel(dlm);
        this.txtClientDisplayName.setText(this.descriptor.getName());
        this.txtDescription.setText(this.descriptor.getDescription());
        this.txtSmallIcon.setText(this.descriptor.getSmallIconUri());
        this.txtLargeIcon.setText(this.descriptor.getLargeIconUri());
    }

    private void removeContentsAction() {
        Object[] selection = this.lstContents.getSelectedValues();
        if (selection == null) {
            return;
        }
        if (this.mode.equals("DeveloperMode")) {
            int i2 = 0;
            while (i2 < selection.length) {
                this.contentsMap.removeFile((File)selection[i2]);
                ++i2;
            }
        } else {
            try {
                int i3 = 0;
                while (i3 < selection.length) {
                    if (((File)selection[i3]).toString().startsWith("META-INF")) {
                        JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.cannotdeletecontent", "This content cannot be deleted"));
                    } else {
                        this.descriptor.getArchivist().removeEntry(((File)selection[i3]).toString());
                    }
                    ++i3;
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
        this.refresh();
    }

    public void removeLibJarAction() {
        if (this.classpathList.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.no_library_jars", "There are no library jar files currently in this application"));
            return;
        }
        Object[] selection = this.classpathList.getSelectedValues();
        if (selection != null) {
            int i2 = 0;
            while (i2 < selection.length) {
                this.descriptor.getArchivist().removeManifestClasspath((String)selection[i2]);
                ++i2;
            }
            this.refresh();
        }
    }

    public void setJarFile(String jarFilename) {
        this.txtJarFile.setText(jarFilename);
    }

    public void setObject(Object object) {
        if (object instanceof ApplicationClientDescriptor) {
            this.descriptor = (ApplicationClientDescriptor)object;
            this.refresh();
        }
    }
}

