/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.gui.ControlPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ResultsPanel
extends JPanel
implements ChangeListener {
    JTable table;
    DefaultTableModel tableModel;
    JScrollPane tableScrollPane;
    JScrollPane textScrollPane;
    JTextArea detailText;
    Vector details = new Vector();
    private static Vector passResults = new Vector();
    private static Vector failResults = new Vector();
    private static Vector warnResults = new Vector();
    private static Vector naResults = new Vector();
    private static Vector notImplementedResults = new Vector();
    private static Vector notRunResults = new Vector();
    private static Vector defaultResults = new Vector();
    int tableIndex;
    static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    final String[] columnNames = new String[]{smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item"), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name"), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")};
    static /* synthetic */ Class class$java$lang$Object;

    public ResultsPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.ResultsPanelLabel", "Results: (Click on Item to show test Details below)")));
        CheckMgr.addChangeListener(this);
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.tableScrollPane = new JScrollPane(this.table);
        this.sizeTableColumns();
        this.table.setDefaultEditor(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ResultsPanel.class$("java.lang.Object")), new DefaultCellEditor(new JTextField()){

            public boolean isCellEditable(EventObject anEvent) {
                return false;
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (!e10.getValueIsAdjusting()) {
                    ResultsPanel.this.tableIndex = e10.getLastIndex() == ResultsPanel.this.tableIndex ? e10.getFirstIndex() : e10.getLastIndex();
                    ResultsPanel.this.setDetailText((String)ResultsPanel.this.details.elementAt(ResultsPanel.this.tableIndex));
                }
            }
        });
        this.detailText = new JTextArea(4, 50);
        this.detailText.setEditable(false);
        this.textScrollPane = new JScrollPane(this.detailText);
        this.textScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.DetailsPanelLabel", "Details:")));
        this.add("Center", this.tableScrollPane);
        this.add("South", this.textScrollPane);
        RadioListener myListener = new RadioListener();
        ControlPanel.addRadioButtonListener(myListener);
    }

    public void addDetailText(String details) {
        this.detailText.append(details);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clearOldResults() {
        passResults = new Vector();
        failResults = new Vector();
        warnResults = new Vector();
        naResults = new Vector();
        notImplementedResults = new Vector();
        notRunResults = new Vector();
        defaultResults = new Vector();
    }

    public void clearResults() {
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table.setModel(this.tableModel);
        this.sizeTableColumns();
        this.setDetailText("");
        this.details = new Vector();
    }

    private Vector getDefaultResultsForDisplay() {
        return defaultResults;
    }

    private Vector getFailResultsForDisplay() {
        return failResults;
    }

    private Vector getNaResultsForDisplay() {
        return naResults;
    }

    private Vector getNotImplementedResultsForDisplay() {
        return notImplementedResults;
    }

    private Vector getNotRunResultsForDisplay() {
        return notRunResults;
    }

    private Vector getPassResultsForDisplay() {
        return passResults;
    }

    private Vector getWarnResultsForDisplay() {
        return warnResults;
    }

    private void saveDefaultResultsForDisplay(Result r2) {
        defaultResults.addElement(r2);
    }

    private void saveFailResultsForDisplay(Result r2) {
        failResults.addElement(r2);
    }

    private void saveNaResultsForDisplay(Result r2) {
        naResults.addElement(r2);
    }

    private void saveNotImplementedResultsForDisplay(Result r2) {
        notImplementedResults.addElement(r2);
    }

    private void saveNotRunResultsForDisplay(Result r2) {
        notRunResults.addElement(r2);
    }

    private void savePassResultsForDisplay(Result r2) {
        passResults.addElement(r2);
    }

    private void saveWarnResultsForDisplay(Result r2) {
        warnResults.addElement(r2);
    }

    public void setDetailText(String details) {
        this.detailText.setText(details);
        JScrollBar scrollBar = this.textScrollPane.getVerticalScrollBar();
        if (scrollBar != null) {
            scrollBar.setValue(0);
        }
    }

    void sizeTableColumns() {
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setMinWidth(150);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setMaxWidth(200);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setPreferredWidth(180);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name")).setMinWidth(150);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name")).setPreferredWidth(180);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setMinWidth(120);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setMaxWidth(200);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setPreferredWidth(160);
        this.table.setAutoResizeMode(4);
        this.table.sizeColumnsToFit(0);
    }

    public void stateChanged(ChangeEvent evt) {
        Enumeration e10;
        String status;
        Result r2 = (Result)evt.getSource();
        switch (r2.getStatus()) {
            case 0: {
                status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Passed", "Passed");
                this.savePassResultsForDisplay(r2);
                break;
            }
            case 1: {
                status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Failed", "FAILED");
                this.saveFailResultsForDisplay(r2);
                break;
            }
            case 2: {
                status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Warning", "WARNING");
                this.saveWarnResultsForDisplay(r2);
                break;
            }
            case 3: {
                status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotApplicable", "Not Applicable");
                this.saveNaResultsForDisplay(r2);
                break;
            }
            case 5: {
                status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotImplemented", "Not Implemented");
                this.saveNotImplementedResultsForDisplay(r2);
                break;
            }
            case 4: {
                status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotRun", "Not Run");
                this.saveNotRunResultsForDisplay(r2);
                break;
            }
            default: {
                status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Unknown", "Unknown");
                this.saveDefaultResultsForDisplay(r2);
            }
        }
        Object[] row = new Object[]{r2.getComponentName(), r2.getTestName(), status};
        String s2 = new String("");
        if (Verifier.getReportLevel() == 0 && r2.getStatus() == 1) {
            this.tableModel.addRow(row);
            e10 = r2.getErrorDetails().elements();
            while (e10.hasMoreElements()) {
                s2 = String.valueOf(s2) + (String)e10.nextElement();
                s2 = String.valueOf(s2) + "\n";
            }
            this.details.add(s2);
        }
        if (Verifier.getReportLevel() == 1 && (r2.getStatus() == 1 || r2.getStatus() == 2)) {
            this.tableModel.addRow(row);
            e10 = r2.getErrorDetails().elements();
            while (e10.hasMoreElements()) {
                s2 = String.valueOf(s2) + (String)e10.nextElement();
                s2 = String.valueOf(s2) + "\n";
            }
            e10 = r2.getWarningDetails().elements();
            while (e10.hasMoreElements()) {
                s2 = String.valueOf(s2) + (String)e10.nextElement();
                s2 = String.valueOf(s2) + "\n";
            }
            this.details.add(s2);
        }
        if (Verifier.getReportLevel() == 2) {
            this.tableModel.addRow(row);
            e10 = r2.getErrorDetails().elements();
            while (e10.hasMoreElements()) {
                s2 = String.valueOf(s2) + (String)e10.nextElement();
                s2 = String.valueOf(s2) + "\n";
            }
            e10 = r2.getWarningDetails().elements();
            while (e10.hasMoreElements()) {
                s2 = String.valueOf(s2) + (String)e10.nextElement();
                s2 = String.valueOf(s2) + "\n";
            }
            e10 = r2.getGoodDetails().elements();
            while (e10.hasMoreElements()) {
                s2 = String.valueOf(s2) + (String)e10.nextElement();
                s2 = String.valueOf(s2) + "\n";
            }
            e10 = r2.getNaDetails().elements();
            while (e10.hasMoreElements()) {
                s2 = String.valueOf(s2) + (String)e10.nextElement();
                s2 = String.valueOf(s2) + "\n";
            }
            this.details.add(s2);
        }
        this.table.sizeColumnsToFit(0);
    }

    public void upDateDisplay(int status) {
        this.clearResults();
        if (status == 2) {
            this.upDateDisplayAll();
        }
        if (status == 0) {
            this.upDateDisplayFail();
        }
        if (status == 1) {
            this.upDateDisplayFail();
            this.upDateDisplayWarn();
        }
    }

    private void upDateDisplayAll() {
        this.upDateDisplayFail();
        this.upDateDisplayWarn();
        this.upDateDisplayPass();
        this.upDateDisplayNa();
        this.upDateDisplayNotImplemented();
        this.upDateDisplayNotRun();
        this.upDateDisplayDefault();
    }

    private void upDateDisplayDefault() {
        this.updateTableRows(this.getDefaultResultsForDisplay());
    }

    private void upDateDisplayFail() {
        this.updateTableRows(this.getFailResultsForDisplay());
    }

    private void upDateDisplayNa() {
        this.updateTableRows(this.getNaResultsForDisplay());
    }

    private void upDateDisplayNotImplemented() {
        this.updateTableRows(this.getNotImplementedResultsForDisplay());
    }

    private void upDateDisplayNotRun() {
        this.updateTableRows(this.getNotRunResultsForDisplay());
    }

    private void upDateDisplayPass() {
        this.updateTableRows(this.getPassResultsForDisplay());
    }

    private void upDateDisplayWarn() {
        this.updateTableRows(this.getWarnResultsForDisplay());
    }

    private void updateTableRows(Vector results) {
        int i2 = 0;
        while (i2 < results.size()) {
            Enumeration e10;
            String status;
            Result r2 = (Result)results.elementAt(i2);
            String s2 = new String("");
            switch (r2.getStatus()) {
                case 0: {
                    status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Passed", "Passed");
                    e10 = r2.getGoodDetails().elements();
                    break;
                }
                case 1: {
                    status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Failed", "FAILED");
                    e10 = r2.getErrorDetails().elements();
                    break;
                }
                case 2: {
                    status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Warning", "WARNING");
                    e10 = r2.getWarningDetails().elements();
                    break;
                }
                case 3: {
                    status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotApplicable", "Not Applicable");
                    e10 = r2.getNaDetails().elements();
                    break;
                }
                case 5: {
                    status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotImplemented", "Not Implemented");
                    e10 = r2.getNaDetails().elements();
                    break;
                }
                case 4: {
                    status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotRun", "Not Run");
                    e10 = r2.getNaDetails().elements();
                    break;
                }
                default: {
                    status = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Unknown", "Unknown");
                    e10 = r2.getNaDetails().elements();
                }
            }
            Object[] row = new Object[]{r2.getComponentName(), r2.getTestName(), status};
            this.tableModel.addRow(row);
            if (r2.getStatus() == 0 || r2.getStatus() == 1 || r2.getStatus() == 2 || r2.getStatus() == 5 || r2.getStatus() == 3) {
                while (e10.hasMoreElements()) {
                    s2 = String.valueOf(s2) + (String)e10.nextElement();
                    s2 = String.valueOf(s2) + "\n";
                }
                this.details.add(s2);
            }
            this.table.sizeColumnsToFit(0);
            ++i2;
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent e10) {
            if (e10.getSource() == ControlPanel.allButton) {
                if (ResultsPanel.this.getPassResultsForDisplay().size() > 0 || ResultsPanel.this.getFailResultsForDisplay().size() > 0 || ResultsPanel.this.getWarnResultsForDisplay().size() > 0 || ResultsPanel.this.getNaResultsForDisplay().size() > 0 || ResultsPanel.this.getNotImplementedResultsForDisplay().size() > 0 || ResultsPanel.this.getNotRunResultsForDisplay().size() > 0 || ResultsPanel.this.getDefaultResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(2);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
            if (e10.getSource() == ControlPanel.failButton) {
                if (ResultsPanel.this.getFailResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(0);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
            if (e10.getSource() == ControlPanel.warnButton) {
                if (ResultsPanel.this.getFailResultsForDisplay().size() > 0 || ResultsPanel.this.getWarnResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(1);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
        }
    }
}

