/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class EjbFinderMethodException
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                boolean ejbFindMethodFound = false;
                boolean throwsRemoteException = false;
                boolean oneFailed = false;
                int foundWarning = 0;
                int foundAtLeastOne = 0;
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        int j2 = 0;
                        while (j2 < ejbFinderMethods.length) {
                            throwsRemoteException = false;
                            ejbFindMethodFound = false;
                            if (ejbFinderMethods[j2].getName().startsWith("ejbFind")) {
                                ejbFindMethodFound = true;
                                ++foundAtLeastOne;
                                Class[] exceptions = ejbFinderMethods[j2].getExceptionTypes();
                                if (EjbUtils.isValidRemoteException(exceptions)) {
                                    throwsRemoteException = true;
                                }
                                if (ejbFindMethodFound && !throwsRemoteException) {
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] declares [ {1} ] method, which properly does not throw java.rmi.RemoteException", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                                } else if (ejbFindMethodFound && throwsRemoteException) {
                                    result.addWarningDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{descriptor.getEjbClassName(), ejbFinderMethods[j2].getName()}));
                                    result.addWarningDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warning", "Warning: Compatibility Note:\n An [ {0} ] method was found, but\n EJB 1.0 allowed the ejbFind<METHOD> method to throw the \n java.rmi.RemoteException to indicate a non-application\n exception. This practice is deprecated in EJB 1.1\n ---an EJB 1.1 compliant enterprise bean should\n throw the javax.ejb.EJBException or another \n RuntimeException to indicate non-application exceptions\n to the Container. ", new Object[]{ejbFinderMethods[j2].getName()}));
                                    result.addWarningDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                                    ++foundWarning;
                                }
                            }
                            ++j2;
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && foundAtLeastOne == 0);
                    if (foundAtLeastOne == 0) {
                        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "[ {0} ] does not declare any ejbFind<METHOD>(...) methods.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundAtLeastOne == 0) {
                    result.setStatus(3);
                } else if (foundWarning > 0) {
                    result.setStatus(2);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

