/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class HomeInterfaceFindByPrimaryKeyArg
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            boolean findByPrimaryKeyMethodFound = false;
            boolean foundOne = false;
            boolean oneFailed = false;
            boolean paramValid = false;
            boolean onlyOneParam = false;
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> homeInterfaceClass = jcl.loadClass(descriptor.getHomeClassName());
                Method[] ejbFinderMethods = homeInterfaceClass.getDeclaredMethods();
                String primaryKeyType = ((EjbEntityDescriptor)descriptor).getPrimaryKeyClassName();
                int j2 = 0;
                while (j2 < ejbFinderMethods.length) {
                    paramValid = false;
                    onlyOneParam = false;
                    findByPrimaryKeyMethodFound = false;
                    if (ejbFinderMethods[j2].getName().equals("findByPrimaryKey")) {
                        findByPrimaryKeyMethodFound = true;
                        Class<?>[] ejbFinderMethodParameterTypes = ejbFinderMethods[j2].getParameterTypes();
                        if (ejbFinderMethodParameterTypes.length == 1) {
                            onlyOneParam = true;
                            int k2 = 0;
                            while (k2 < ejbFinderMethodParameterTypes.length) {
                                if (ejbFinderMethodParameterTypes[k2].getName().equals(primaryKeyType)) {
                                    paramValid = true;
                                    break;
                                }
                                ++k2;
                            }
                        } else {
                            onlyOneParam = false;
                            paramValid = false;
                        }
                        if (findByPrimaryKeyMethodFound && paramValid) {
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j2].getName()}));
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "A findByPrimaryKey method with valid parameter type was found."));
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            foundOne = true;
                            break;
                        }
                        if (findByPrimaryKeyMethodFound && onlyOneParam && !paramValid) {
                            if (this.debug) {
                                result.addNaDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j2].getName()}));
                                result.addNaDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "A findByPrimaryKey method was found, but with non-PrimaryKeyClass arg parameter type."));
                                result.addNaDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            }
                        } else if (findByPrimaryKeyMethodFound && !onlyOneParam && this.debug) {
                            result.addNaDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j2].getName()}));
                            result.addNaDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "A findByPrimaryKey method was found, but with non-single arg parameters."));
                            result.addNaDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                        }
                    }
                    ++j2;
                }
                if (!foundOne) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug3", "For home interface [ {0} ]", new Object[]{homeInterfaceClass.getName()}));
                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: No single arg findByPrimaryKey(PrimaryKeyClass) method was found in home interface class [ {0} ].", new Object[]{homeInterfaceClass.getName()}));
                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getHomeClassName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

