/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Arrays;

public class RemoteInterfaceMatchMethodException
implements EjbCheck {
    static String[] EJBObjectMethods = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical", "remove"};
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        boolean businessMethodFound = false;
        boolean oneFailed = false;
        boolean exceptionsMatch = false;
        try {
            Arrays.sort(EJBObjectMethods);
            JarClassLoader jcl = JarClassLoader.getInstance();
            Class<?> remoteInterfaceClass = jcl.loadClass(descriptor.getRemoteClassName());
            Method[] remoteInterfaceMethods = remoteInterfaceClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < remoteInterfaceMethods.length) {
                if (Arrays.binarySearch(EJBObjectMethods, remoteInterfaceMethods[i2].getName()) < 0) {
                    Class[] methodExceptionTypes = remoteInterfaceMethods[i2].getExceptionTypes();
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] businessMethods = EJBClass.getDeclaredMethods();
                        businessMethodFound = false;
                        exceptionsMatch = false;
                        int j2 = 0;
                        while (j2 < businessMethods.length) {
                            if (remoteInterfaceMethods[i2].getName().equals(businessMethods[j2].getName())) {
                                businessMethodFound = true;
                                Class[] businessMethodExceptionTypes = businessMethods[j2].getExceptionTypes();
                                if (RmiIIOPUtils.isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(businessMethodExceptionTypes, methodExceptionTypes)) {
                                    exceptionsMatch = true;
                                    break;
                                }
                            }
                            ++j2;
                        }
                        if (businessMethodFound && exceptionsMatch) {
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Remote Interface [ {0} ] method [ {1} ]", new Object[]{remoteInterfaceClass.getName(), remoteInterfaceMethods[i2].getName()}));
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "The corresponding business method with matching exceptions was found."));
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            continue;
                        }
                        if (!businessMethodFound || exceptionsMatch || !this.debug) continue;
                        System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Remote Interface [ {0} ] method [ {1} ]", new Object[]{remoteInterfaceClass.getName(), remoteInterfaceMethods[i2].getName()}));
                        System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug3", "A corresponding business method [ {0} ] was found, but the exceptions did not match.", new Object[]{remoteInterfaceMethods[i2].getName()}));
                        System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && (!businessMethodFound || !exceptionsMatch));
                    if (!exceptionsMatch) {
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Remote Interface [ {0} ] method [ {1} ]", new Object[]{remoteInterfaceClass.getName(), remoteInterfaceMethods[i2].getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: No corresponding business method with matching exceptions was found for method [ {0} ].", new Object[]{remoteInterfaceMethods[i2].getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                    }
                }
                ++i2;
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getRemoteClassName(), descriptor.getName()}));
            oneFailed = true;
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

