/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.http.HttpServlet;

public class ServletInterface
implements WebCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    final String servletClassPath = "WEB-INF/classes";

    public Result check(WebBundleDescriptor descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (!descriptor.getServletDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean implementsInterface = false;
            Set servlets = descriptor.getServletDescriptors();
            Iterator itr = servlets.iterator();
            while (itr.hasNext()) {
                String servletClassName;
                block20: {
                    ServletDescriptorImpl servlet = (ServletDescriptorImpl)itr.next();
                    servletClassName = servlet.getClassName();
                    try {
                        File warfile = new File(System.getProperty("java.io.tmpdir"));
                        warfile = new File(warfile, "wartmp");
                        Archivist.extractJarFile(Verifier.getWarFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), warfile);
                        File warclasses = new File(warfile, "WEB-INF/classes");
                        FileClassLoader cl2 = new FileClassLoader(warclasses.getAbsolutePath());
                        Verifier.debug("servlet classpath: " + warclasses.getAbsolutePath());
                        Class<?> c10 = cl2.loadClass(servletClassName);
                        Class<?>[] interfaces = c10.getInterfaces();
                        int i2 = 0;
                        while (i2 < interfaces.length) {
                            if (interfaces[i2].getName().equals("javax.servlet.Servlet")) {
                                implementsInterface = true;
                                break;
                            }
                            ++i2;
                        }
                        if (implementsInterface) break block20;
                        try {
                            if (c10.newInstance() instanceof GenericServlet || c10.newInstance() instanceof HttpServlet) {
                                implementsInterface = true;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InstantiationException instantiationException) {}
                    }
                    catch (ClassNotFoundException e10) {
                        Verifier.debug(e10);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".ClassNotFoundException", "Error: [ {0} ] class not found.", new Object[]{servletClassName}));
                        break;
                    }
                    catch (IOException e11) {
                        Verifier.debug(e11);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".IOException", "Error: IOError trying to open [ {0} ], {1}", new Object[]{Verifier.getWarFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), e11.getMessage()}));
                        break;
                    }
                }
                if (implementsInterface) {
                    result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Servlet class [ {0} ] directly or indirectly implements javax.servlet.Servlet", new Object[]{servletClassName}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: Servlet class [ {0} ] does not directly or indirectly implement javax.servlet.Servlet", new Object[]{servletClassName}));
            }
            File wartmp = new File(System.getProperty("java.io.tmpdir"));
            wartmp = new File(wartmp, "wartmp");
            wartmp.delete();
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no servlet components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

